/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.directory.dao.EmploymentDao;
import org.joget.directory.dao.GradeDao;
import org.joget.directory.dao.OrganizationDao;
import org.joget.directory.model.Employment;
import org.joget.directory.model.Grade;
import org.joget.directory.model.Organization;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.directory.model.service.ExtDirectoryManager;

public class DirectoryGradeAPI
extends ApiPluginAbstract {
    public String getName() {
        return "DirectoryGradeAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-users\"></i>";
    }

    @Override
    public String getTag() {
        return "grade";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@DirectoryGradeAPI.addGrade.summary@@", description="@@DirectoryGradeAPI.addGrade.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Grade"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addGrade(@Param(value="body", description="@@DirectoryGradeAPI.addGrade.body.desc@@", definition="Grade") Grade body) {
        String org;
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getId() == null || body.getId().isEmpty()) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getOrganization() != null) {
            org = body.getOrganization().getId();
            if (org == null || org.isEmpty() || this.getOrganization(org) == null) {
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.405.noOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        } else {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.405.noOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        body.setOrganization(this.getOrganization(org));
        GradeDao dao = (GradeDao)AppUtil.getApplicationContext().getBean("gradeDao");
        if (dao.addGrade(body).booleanValue()) {
            return new ApiResponse(200, body, this.getFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@DirectoryGradeAPI.updateGrade.summary@@", description="@@DirectoryGradeAPI.updateGrade.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Grade"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateGrade(@Param(value="body", description="@@DirectoryGradeAPI.updateGrade.body.desc@@", definition="Grade") Grade body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        GradeDao dao = (GradeDao)AppUtil.getApplicationContext().getBean("gradeDao");
        Grade grade = dao.getGrade(body.getId());
        if (grade != null) {
            String org;
            if (body.getOrganization() != null && (org = body.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                body.setOrganization(this.getOrganization(org));
            }
            ApiService.mergeObject(grade, body);
            if (dao.updateGrade(grade).booleanValue()) {
                return new ApiResponse(200, grade, this.getFields());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@DirectoryGradeAPI.findGrade.summary@@", description="@@DirectoryGradeAPI.findGrade.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Grade", array=true)})
    public ApiResponse findGrade(@Param(value="nameFilter", required=false, description="@@DirectoryGradeAPI.findGrade.nameFilter.desc@@") String nameFilter, @Param(value="organizationId", required=false, description="@@DirectoryGradeAPI.findGrade.organizationId.desc@@") String orgId, @Param(value="sort", required=false, description="@@DirectoryGradeAPI.findGrade.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryGradeAPI.findGrade.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryGradeAPI.findGrade.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryGradeAPI.findGrade.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection grades = dm.getGradesByOrganizationId(nameFilter, orgId, sort, desc, startOffset, pageSize);
        for (Grade grade : grades) {
            String org;
            if (grade.getOrganization() == null || (org = grade.getOrganization().getId()) == null || org.isEmpty() || this.getOrganization(org) == null) continue;
            grade.setOrganization(this.getOrganization(org));
        }
        return new ApiResponse(200, grades, this.getFields());
    }

    @Operation(path="/{id}", type=Operation.MethodType.GET, summary="@@DirectoryGradeAPI.getGrade.summary@@", description="@@DirectoryGradeAPI.getGrade.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Grade"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getGrade(@Param(value="id", description="@@DirectoryGradeAPI.getGrade.id.desc@@") String id) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Grade grade = dm.getGradeById(id);
        if (grade != null) {
            String org;
            if (grade.getOrganization() != null && (org = grade.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                grade.setOrganization(this.getOrganization(org));
            }
            return new ApiResponse(200, grade, this.getFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{id}", type=Operation.MethodType.DELETE, summary="@@DirectoryGradeAPI.deleteGrade.summary@@", description="@@DirectoryGradeAPI.deleteGrade.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteGrade(@Param(value="id", description="@@DirectoryGradeAPI.deleteGrade.id.desc@@") String id) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        GradeDao dao = (GradeDao)AppUtil.getApplicationContext().getBean("gradeDao");
        if (dao.deleteGrade(id).booleanValue()) {
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/assignUser/{grade}/{username}", type=Operation.MethodType.POST, summary="@@DirectoryGradeAPI.assignUser.summary@@", description="@@DirectoryGradeAPI.assignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Employment"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse assignUser(@Param(value="grade", description="@@DirectoryGradeAPI.assignUser.grade.desc@@") String grade, @Param(value="username", description="@@DirectoryGradeAPI.assignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        Employment employment = null;
        if (user != null) {
            if (user.getEmployments() != null && !user.getEmployments().isEmpty()) {
                employment = (Employment)user.getEmployments().iterator().next();
            } else {
                employment = new Employment();
                employment.setUserId(user.getId());
                employment.setUser(user);
            }
            Grade gradeObj = dm.getGradeById(grade);
            if (gradeObj != null) {
                employment.setGradeId(grade);
                if (employment.getOrganizationId() != null && !employment.getOrganizationId().isEmpty() && !gradeObj.getOrganization().getId().equalsIgnoreCase(employment.getOrganizationId())) {
                    return new ApiResponse(405, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.405.invalidOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
                employment.setOrganizationId(gradeObj.getOrganization().getId());
                if (employment.getId() == null) {
                    employmentDao.addEmployment(employment);
                } else {
                    employmentDao.updateEmployment(employment);
                }
            } else {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"DirectoryGradeAPI.error.404.noGrade", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            return new ApiResponse(200, employment, this.getEmploymentFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/unassignUser/{grade}/{username}", type=Operation.MethodType.DELETE, summary="@@DirectoryGradeAPI.unassignUser.summary@@", description="@@DirectoryGradeAPI.unassignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse unassignUser(@Param(value="grade", description="@@DirectoryGradeAPI.unassignUser.grade.desc@@") String grade, @Param(value="username", description="@@DirectoryGradeAPI.unassignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        if (user != null && user.getEmployments() != null) {
            try {
                Employment employment = (Employment)user.getEmployments().iterator().next();
                if (employment.getGrade() != null && grade.equalsIgnoreCase(employment.getGradeId())) {
                    employment.setGradeId(null);
                    employmentDao.updateEmployment(employment);
                    return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
            }
            catch (Exception e) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Override
    public Map<String, String> getOperationOptions() {
        Map<String, String> options = super.getOperationOptions();
        if (DirectoryUtil.isCustomDirectoryManager()) {
            options.remove("post:/");
            options.remove("put:/");
            options.remove("delete:/{id}");
        }
        return options;
    }

    protected Organization getOrganization(String organization) {
        OrganizationDao orgDao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        Organization orgById = orgDao.getOrganization(organization);
        Organization orgByName = orgDao.getOrganizationByName(organization);
        if (orgById != null) {
            return orgById;
        }
        if (orgByName != null) {
            return orgByName;
        }
        return null;
    }

    protected String[] getFields() {
        return new String[]{"id", "name", "description", "organization", "org.joget.directory.model.Organization", "org.joget.directory.model.Organization:id"};
    }

    protected String[] getEmploymentFields() {
        return new String[]{"userId", "startDate", "endDate", "employeeCode", "gradeId", "departmentId", "organizationId"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("Grade", new ApiDefinition(new Grade(), this.getFields()));
        defs.put("Employment", new ApiDefinition(new Employment(), this.getEmploymentFields()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

