/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.directory.dao.GroupDao;
import org.joget.directory.dao.OrganizationDao;
import org.joget.directory.dao.UserDao;
import org.joget.directory.model.Group;
import org.joget.directory.model.Organization;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.directory.model.service.ExtDirectoryManager;

public class DirectoryGroupAPI
extends ApiPluginAbstract {
    public String getName() {
        return "DirectoryGroupAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-users\"></i>";
    }

    @Override
    public String getTag() {
        return "group";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@DirectoryGroupAPI.addGroup.summary@@", description="@@DirectoryGroupAPI.addGroup.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Group"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addGroup(@Param(value="body", description="@@DirectoryGroupAPI.addGroup.body.desc@@", definition="Group") Group body) {
        GroupDao dao;
        String org;
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGroupAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getId() == null || body.getId().isEmpty()) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getOrganization() != null && (org = body.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
            body.setOrganization(this.getOrganization(org));
        }
        if ((dao = (GroupDao)AppUtil.getApplicationContext().getBean("groupDao")).addGroup(body).booleanValue()) {
            return new ApiResponse(200, body, this.getFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@DirectoryGroupAPI.updateGroup.summary@@", description="@@DirectoryGroupAPI.updateGroup.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Group"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateGroup(@Param(value="body", description="@@DirectoryGroupAPI.updateGroup.body.desc@@", definition="Group") Group body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGroupAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        GroupDao dao = (GroupDao)AppUtil.getApplicationContext().getBean("groupDao");
        Group group = dao.getGroup(body.getId());
        if (group != null) {
            String org;
            if (body.getOrganization() != null && (org = body.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                body.setOrganization(this.getOrganization(org));
            }
            ApiService.mergeObject(group, body);
            if (dao.updateGroup(group).booleanValue()) {
                return new ApiResponse(200, group, this.getFields());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@DirectoryGroupAPI.findGroup.summary@@", description="@@DirectoryGroupAPI.findGroup.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Group", array=true)})
    public ApiResponse findGroup(@Param(value="nameFilter", required=false, description="@@DirectoryGroupAPI.findGroup.nameFilter.desc@@") String nameFilter, @Param(value="organizationId", required=false, description="@@DirectoryGroupAPI.findGroup.organizationId.desc@@") String orgId, @Param(value="sort", required=false, description="@@DirectoryGroupAPI.findGroup.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryGroupAPI.findGroup.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryGroupAPI.findGroup.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryGroupAPI.findGroup.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection groups = dm.getGroupsByOrganizationId(nameFilter, orgId, sort, desc, startOffset, pageSize);
        for (Group group : groups) {
            String org;
            if (group.getOrganization() == null || (org = group.getOrganization().getId()) == null || org.isEmpty() || this.getOrganization(org) == null) continue;
            group.setOrganization(this.getOrganization(org));
        }
        return new ApiResponse(200, groups, this.getFields());
    }

    @Operation(path="/findByUser/{username}", type=Operation.MethodType.GET, summary="@@DirectoryGroupAPI.findGroupByUser.summary@@", description="@@DirectoryGroupAPI.findGroupByUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Group", array=true)})
    public ApiResponse findGroupByUser(@Param(value="username", description="@@DirectoryGroupAPI.findGroupByUser.username.desc@@") String username, @Param(value="nameFilter", required=false, description="@@DirectoryGroupAPI.findGroupByUser.nameFilter.desc@@") String nameFilter, @Param(value="organizationId", required=false, description="@@DirectoryGroupAPI.findGroupByUser.organizationId.desc@@") String orgId, @Param(value="inGroup", required=false, description="@@DirectoryGroupAPI.findGroupByUser.inGroup.desc@@") Boolean inGroup, @Param(value="sort", required=false, description="@@DirectoryGroupAPI.findGroupByUser.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryGroupAPI.findGroupByUser.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryGroupAPI.findGroupByUser.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryGroupAPI.findGroupByUser.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection groups = dm.getGroupsByUserId(nameFilter, username, orgId, inGroup, sort, desc, startOffset, pageSize);
        for (Group group : groups) {
            String org;
            if (group.getOrganization() == null || (org = group.getOrganization().getId()) == null || org.isEmpty() || this.getOrganization(org) == null) continue;
            group.setOrganization(this.getOrganization(org));
        }
        return new ApiResponse(200, groups, this.getFields());
    }

    @Operation(path="/{id}", type=Operation.MethodType.GET, summary="@@DirectoryGroupAPI.getGroup.summary@@", description="@@DirectoryGroupAPI.getGroup.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Group"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getGroup(@Param(value="id", description="@@DirectoryGroupAPI.getGroup.id.desc@@") String id) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Group group = dm.getGroupById(id);
        if (group != null) {
            String org;
            if (group.getOrganization() != null && (org = group.getOrganization().getId()) != null && !org.isEmpty() && this.getOrganization(org) != null) {
                group.setOrganization(this.getOrganization(org));
            }
            return new ApiResponse(200, group, this.getFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{id}", type=Operation.MethodType.DELETE, summary="@@DirectoryGroupAPI.deleteGroup.summary@@", description="@@DirectoryGroupAPI.deleteGroup.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteGroup(@Param(value="id", description="@@DirectoryGroupAPI.deleteGroup.id.desc@@") String id) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryGroupAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        GroupDao dao = (GroupDao)AppUtil.getApplicationContext().getBean("groupDao");
        if (dao.deleteGroup(id).booleanValue()) {
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/assignUser/{group}/{username}", type=Operation.MethodType.POST, summary="@@DirectoryGroupAPI.assignUser.summary@@", description="@@DirectoryGroupAPI.assignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse assignUser(@Param(value="group", description="@@DirectoryGroupAPI.assignUser.group.desc@@") String group, @Param(value="username", description="@@DirectoryGroupAPI.assignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        UserDao userDao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        User user = dm.getUserByUsername(username);
        if (user != null) {
            if (userDao.assignUserToGroup(username, group).booleanValue()) {
                if (user.getGroups() != null && !user.getGroups().isEmpty()) {
                    for (Group g : user.getGroups()) {
                        if (g.getOrganization() == null) continue;
                        g.setOrganizationId(g.getOrganization().getId());
                    }
                }
                return new ApiResponse(200, user, this.getUserFields());
            }
            return new ApiResponse(404, AppPluginUtil.getMessage((String)"DirectoryGroupAPI.error.404.noGroup", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/unassignUser/{group}/{username}", type=Operation.MethodType.DELETE, summary="@@DirectoryGroupAPI.unassignUser.summary@@", description="@@DirectoryGroupAPI.unassignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse unassignUser(@Param(value="group", description="@@DirectoryGroupAPI.unassignUser.group.desc@@") String group, @Param(value="username", description="@@DirectoryGroupAPI.unassignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        UserDao userDao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        User user = dm.getUserByUsername(username);
        if (user != null) {
            if (userDao.unassignUserFromGroup(username, group).booleanValue()) {
                return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            return new ApiResponse(404, AppPluginUtil.getMessage((String)"DirectoryGroupAPI.error.404.noGroup", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Override
    public Map<String, String> getOperationOptions() {
        Map<String, String> options = super.getOperationOptions();
        if (DirectoryUtil.isCustomDirectoryManager()) {
            options.remove("post:/");
            options.remove("put:/");
            options.remove("delete:/{id}");
        }
        return options;
    }

    protected Organization getOrganization(String organization) {
        OrganizationDao orgDao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        Organization orgById = orgDao.getOrganization(organization);
        Organization orgByName = orgDao.getOrganizationByName(organization);
        if (orgById != null) {
            return orgById;
        }
        if (orgByName != null) {
            return orgByName;
        }
        return null;
    }

    protected String[] getFields() {
        return new String[]{"id", "name", "description", "organization", "org.joget.directory.model.Organization", "org.joget.directory.model.Organization:id"};
    }

    protected String[] getUserFields() {
        return new String[]{"username", "groups", "org.joget.directory.model.Group", "org.joget.directory.model.Group:id", "org.joget.directory.model.Group:name", "org.joget.directory.model.Group:description", "org.joget.directory.model.Group:organizationId"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("Group", new ApiDefinition(new Group(), this.getFields()));
        defs.put("User", new ApiDefinition(new User(), this.getUserFields()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

