/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.directory.dao.EmploymentDao;
import org.joget.directory.dao.OrganizationDao;
import org.joget.directory.model.Employment;
import org.joget.directory.model.Organization;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.directory.model.service.ExtDirectoryManager;

public class DirectoryOrganizationAPI
extends ApiPluginAbstract {
    public String getName() {
        return "DirectoryOrganizationAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-users\"></i>";
    }

    @Override
    public String getTag() {
        return "organization";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@DirectoryOrganizationAPI.addOrganization.summary@@", description="@@DirectoryOrganizationAPI.addOrganization.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Organization"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addOrganization(@Param(value="body", description="@@DirectoryOrganizationAPI.addOrganization.body.desc@@", definition="Organization") Organization body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"api.error.400", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        OrganizationDao dao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        if (dao.addOrganization(body).booleanValue()) {
            return new ApiResponse(200, body, this.getFields());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@DirectoryOrganizationAPI.updateOrganization.summary@@", description="@@DirectoryOrganizationAPI.updateOrganization.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Organization"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateOrganization(@Param(value="body", description="@@DirectoryOrganizationAPI.updateOrganization.body.desc@@", definition="Organization") Organization body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"api.error.400", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        OrganizationDao dao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        Organization org = dao.getOrganization(body.getId());
        if (org != null) {
            ApiService.mergeObject(org, body);
            if (dao.updateOrganization(org).booleanValue()) {
                return new ApiResponse(200, org, this.getFields());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@DirectoryOrganizationAPI.findOrganization.summary@@", description="@@DirectoryOrganizationAPI.findOrganization.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Organization", array=true)})
    public ApiResponse findOrganization(@Param(value="nameFilter", required=false, description="@@DirectoryOrganizationAPI.findOrganization.nameFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@DirectoryOrganizationAPI.findOrganization.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryOrganizationAPI.findOrganization.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryOrganizationAPI.findOrganization.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryOrganizationAPI.findOrganization.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection orgs = dm.getOrganizationsByFilter(nameFilter, sort, desc, startOffset, pageSize);
        return new ApiResponse(200, orgs, this.getFields());
    }

    @Operation(path="/{id}", type=Operation.MethodType.GET, summary="@@DirectoryOrganizationAPI.getOrganization.summary@@", description="@@DirectoryOrganizationAPI.getOrganization.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Organization"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getOrganization(@Param(value="id", description="@@DirectoryOrganizationAPI.getOrganization.id.desc@@") String id) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Organization org = dm.getOrganization(id);
        if (org != null) {
            return new ApiResponse(200, org, this.getFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{id}", type=Operation.MethodType.DELETE, summary="@@DirectoryOrganizationAPI.deleteOrganization.summary@@", description="@@DirectoryOrganizationAPI.deleteOrganization.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteOrganization(@Param(value="id", description="@@DirectoryOrganizationAPI.deleteOrganization.id.desc@@") String id) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"api.error.400", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        OrganizationDao dao = (OrganizationDao)AppUtil.getApplicationContext().getBean("organizationDao");
        if (dao.deleteOrganization(id).booleanValue()) {
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/assignUser/{organization}/{username}", type=Operation.MethodType.POST, summary="@@DirectoryOrganizationAPI.assignUser.summary@@", description="@@DirectoryOrganizationAPI.assignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Employment"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse assignUser(@Param(value="organization", description="@@DirectoryOrganizationAPI.assignUser.organization.desc@@") String organization, @Param(value="username", description="@@DirectoryOrganizationAPI.assignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        Employment employment = null;
        if (user != null) {
            if (user.getEmployments() != null && !user.getEmployments().isEmpty()) {
                employment = (Employment)user.getEmployments().iterator().next();
            } else {
                employment = new Employment();
                employment.setUserId(user.getId());
                employment.setUser(user);
            }
            Organization orgObj = dm.getOrganization(organization);
            if (orgObj != null) {
                if (employment.getOrganization() != null && !organization.equalsIgnoreCase(employment.getOrganizationId())) {
                    employment.setDepartmentId(null);
                    employment.setGradeId(null);
                }
                employment.setOrganizationId(organization);
                if (employment.getId() == null) {
                    employmentDao.addEmployment(employment);
                } else {
                    employmentDao.updateEmployment(employment);
                }
            } else {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"DirectoryOrganizationAPI.error.404.noOrg", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            return new ApiResponse(200, employment, this.getEmploymentFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/unassignUser/{organization}/{username}", type=Operation.MethodType.DELETE, summary="@@DirectoryOrganizationAPI.unassignUser.summary@@", description="@@DirectoryOrganizationAPI.unassignUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse unassignUser(@Param(value="organization", description="@@DirectoryOrganizationAPI.unassignUser.organization.desc@@") String organization, @Param(value="username", description="@@DirectoryOrganizationAPI.unassignUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
        User user = dm.getUserByUsername(username);
        if (user != null && user.getEmployments() != null) {
            try {
                Employment employment = (Employment)user.getEmployments().iterator().next();
                if (employment.getOrganization() != null && organization.equalsIgnoreCase(employment.getOrganizationId())) {
                    employment.setOrganizationId(null);
                    employment.setDepartmentId(null);
                    employment.setGradeId(null);
                    employmentDao.updateEmployment(employment);
                    return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
                }
            }
            catch (Exception e) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Override
    public Map<String, String> getOperationOptions() {
        Map<String, String> options = super.getOperationOptions();
        if (DirectoryUtil.isCustomDirectoryManager()) {
            options.remove("post:/");
            options.remove("put:/");
            options.remove("delete:/{id}");
        }
        return options;
    }

    protected String[] getFields() {
        return new String[]{"id", "name", "description"};
    }

    protected String[] getEmploymentFields() {
        return new String[]{"userId", "startDate", "endDate", "employeeCode", "gradeId", "departmentId", "organizationId"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("Organization", new ApiDefinition(new Organization(), this.getFields()));
        defs.put("Employment", new ApiDefinition(new Employment(), this.getEmploymentFields()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

