/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.StringUtil;
import org.joget.directory.dao.EmploymentDao;
import org.joget.directory.dao.RoleDao;
import org.joget.directory.dao.UserDao;
import org.joget.directory.model.Employment;
import org.joget.directory.model.Role;
import org.joget.directory.model.User;
import org.joget.directory.model.service.DirectoryUtil;
import org.joget.directory.model.service.ExtDirectoryManager;
import org.joget.directory.model.service.UserSecurity;
import org.json.JSONObject;

public class DirectoryUserAPI
extends ApiPluginAbstract {
    public String getName() {
        return "DirectoryUserAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-user\"></i>";
    }

    @Override
    public String getTag() {
        return "user";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@DirectoryUserAPI.addUser.summary@@", description="@@DirectoryUserAPI.addUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse addUser(@Param(value="body", description="@@DirectoryUserAPI.addUser.body.desc@@", definition="User") User body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryUserAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        if (body.getPassword() == null || body.getPassword().isEmpty()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"api.error.400.password", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        UserDao userDao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        RoleDao roleDao = (RoleDao)AppUtil.getApplicationContext().getBean("roleDao");
        Role userRole = roleDao.getRole("ROLE_USER");
        HashSet<Role> roleSet = new HashSet<Role>();
        roleSet.add(userRole);
        body.setRoles(roleSet);
        body = this.encryptUserPassword(body);
        String username = body.getUsername();
        String id = body.getId();
        if (!username.equals(id)) {
            username = id;
            body.setUsername(username);
        }
        if (userDao.addUser(body).booleanValue()) {
            UserSecurity us = DirectoryUtil.getUserSecurity();
            if (us != null) {
                us.insertUserPostProcessing(body);
            }
            return new ApiResponse(200, body, this.getFieldsWithoutPassword());
        }
        return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@DirectoryUserAPI.updateUser.summary@@", description="@@DirectoryUserAPI.updateUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateUser(@Param(value="body", description="@@DirectoryUserAPI.updateUser.body.desc@@", definition="User") User body) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryUserAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        UserDao dao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        User user = dao.getUser(body.getUsername());
        if (user != null) {
            if (body.getPassword() != null && !body.getPassword().isEmpty()) {
                if (body.getUsername() == null || body.getUsername().isEmpty()) {
                    body.setUsername(user.getUsername());
                }
                body = this.encryptUserPassword(body);
            }
            ApiService.mergeObject(user, body);
            String username = user.getUsername();
            String id = user.getId();
            if (!username.equals(id)) {
                username = id;
                user.setUsername(username);
            }
            if (dao.updateUser(user).booleanValue()) {
                UserSecurity us = DirectoryUtil.getUserSecurity();
                if (us != null) {
                    us.updateUserPostProcessing(user);
                }
                return new ApiResponse(200, user, this.getFieldsWithoutPassword());
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/updateEmployment", type=Operation.MethodType.PUT, summary="@@DirectoryUserAPI.updateEmployment.summary@@", description="@@DirectoryUserAPI.updateEmployment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="EmploymentUpdate"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse updateEmployment(@Param(value="body", description="@@DirectoryUserAPI.updateEmployment.body.desc@@", definition="EmploymentUpdate") JSONObject body) throws ParseException {
        UserDao dao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        User user = dao.getUser(body.getString("id"));
        if (user != null) {
            EmploymentDao employmentDao = (EmploymentDao)AppUtil.getApplicationContext().getBean("employmentDao");
            Employment employment = null;
            if (user.getEmployments() != null && user.getEmployments().size() > 0) {
                employment = (Employment)user.getEmployments().iterator().next();
                employment.setEmployeeCode(body.getString("employeeCode"));
                employment.setRole(body.getString("role"));
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String startDate = body.getString("startDate").trim();
                String endDate = body.getString("endDate").trim();
                employment.setStartDate(startDate.isEmpty() ? null : df.parse(startDate));
                employment.setEndDate(endDate.isEmpty() ? null : df.parse(endDate));
                employmentDao.updateEmployment(employment);
            }
            return new ApiResponse(200, body);
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.findUser.summary@@", description="@@DirectoryUserAPI.findUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User", array=true)})
    public ApiResponse findUser(@Param(value="nameFilter", required=false, description="@@DirectoryUserAPI.findUser.nameFilter.desc@@") String nameFilter, @Param(value="organizationId", required=false, description="@@DirectoryUserAPI.findUser.organizationId.desc@@") String orgId, @Param(value="departmentId", required=false, description="@@DirectoryUserAPI.findUser.departmentId.desc@@") String departmentId, @Param(value="gradeId", required=false, description="@@DirectoryUserAPI.findUser.gradeId.desc@@") String gradeId, @Param(value="groupId", required=false, description="@@DirectoryUserAPI.findUser.groupId.desc@@") String groupId, @Param(value="roleId", required=false, description="@@DirectoryUserAPI.findUser.roleId.desc@@") String roleId, @Param(value="active", required=false, description="@@DirectoryUserAPI.findUser.active.desc@@") Integer active, @Param(value="sort", required=false, description="@@DirectoryUserAPI.findUser.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@DirectoryUserAPI.findUser.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@DirectoryUserAPI.findUser.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@DirectoryUserAPI.findUser.pageSize.desc@@") Integer pageSize) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        String activeStatus = null;
        if (active != null) {
            activeStatus = active.toString();
        }
        Collection users = dm.getUsers(nameFilter, orgId, departmentId, gradeId, groupId, roleId, activeStatus, sort, desc, startOffset, pageSize);
        return new ApiResponse(200, users, this.getFieldsWithoutPassword());
    }

    @Operation(path="/{username}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.getUser.summary@@", description="@@DirectoryUserAPI.getUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getUser(@Param(value="username", description="@@DirectoryUserAPI.getUser.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        User user = dm.getUserByUsername(username);
        if (user != null) {
            return new ApiResponse(200, user, this.getFieldsWithoutPassword());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/{username}", type=Operation.MethodType.DELETE, summary="@@DirectoryUserAPI.deleteUser.summary@@", description="@@DirectoryUserAPI.deleteUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=400, description="@@api.error.400@@", definition="ApiResponse"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse deleteUser(@Param(value="username", description="@@DirectoryUserAPI.deleteUser.username.desc@@") String username) {
        if (DirectoryUtil.isCustomDirectoryManager()) {
            return new ApiResponse(400, AppPluginUtil.getMessage((String)"DirectoryUserAPI.error.400.isCustomDM", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        UserDao dao = (UserDao)AppUtil.getApplicationContext().getBean("userDao");
        if (dao.deleteUser(username).booleanValue()) {
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/findSubordinate/{username}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.findSubordinate.summary@@", description="@@DirectoryUserAPI.findSubordinate.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User", array=true)})
    public ApiResponse findSubordinate(@Param(value="username", description="@@DirectoryUserAPI.findSubordinate.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection users = dm.getUserSubordinate(username);
        return new ApiResponse(200, users, this.getFieldsWithoutPassword());
    }

    @Operation(path="/roles/{username}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.getRoles.summary@@", description="@@DirectoryUserAPI.getRoles.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Role", array=true), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getRoles(@Param(value="username", description="@@DirectoryUserAPI.getRoles.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        User user = dm.getUserByUsername(username);
        if (user != null) {
            Collection roles = dm.getUserRoles(username);
            return new ApiResponse(200, roles, this.getRoleFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/findHod/{username}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.findHod.summary@@", description="@@DirectoryUserAPI.findHod.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User", array=true)})
    public ApiResponse findHod(@Param(value="username", description="@@DirectoryUserAPI.findHod.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        Collection users = dm.getUserHod(username);
        return new ApiResponse(200, users, this.getFieldsWithoutPassword());
    }

    @Operation(path="/findHodByDepartment/{departmentId}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.findHodByDepartment.summary@@", description="@@DirectoryUserAPI.findHodByDepartment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="User")})
    public ApiResponse findHodByDepartment(@Param(value="departmentId", description="@@DirectoryUserAPI.findHodByDepartment.departmentId.desc@@") String departmentId) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        User user = dm.getDepartmentHod(departmentId);
        return new ApiResponse(200, user, this.getFieldsWithoutPassword());
    }

    @Operation(path="/employment/{username}", type=Operation.MethodType.GET, summary="@@DirectoryUserAPI.getEmployment.summary@@", description="@@DirectoryUserAPI.getEmployment.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Employment"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getEmployment(@Param(value="username", description="@@DirectoryUserAPI.getEmployment.username.desc@@") String username) {
        ExtDirectoryManager dm = (ExtDirectoryManager)AppUtil.getApplicationContext().getBean("directoryManager");
        User user = dm.getUserByUsername(username);
        if (user != null) {
            Employment employment = (Employment)user.getEmployments().iterator().next();
            return new ApiResponse(200, employment, this.getEmploymentFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Override
    public Map<String, String> getOperationOptions() {
        Map<String, String> options = super.getOperationOptions();
        if (DirectoryUtil.isCustomDirectoryManager()) {
            options.remove("post:/");
            options.remove("put:/");
            options.remove("delete:/{username}");
        }
        return options;
    }

    protected String[] getFields() {
        return new String[]{"id", "username", "firstName", "lastName", "password", "email", "active", "timeZone", "locale"};
    }

    protected String[] getFieldsWithoutPassword() {
        ArrayList<String> userFieldList = new ArrayList<String>(Arrays.asList(this.getFields()));
        userFieldList.remove("password");
        String[] userStrArray = userFieldList.toArray(new String[0]);
        return userStrArray;
    }

    protected User encryptUserPassword(User body) {
        UserSecurity us = DirectoryUtil.getUserSecurity();
        String username = body.getUsername();
        String password = body.getPassword();
        if (password != null && !password.isEmpty()) {
            if (us != null) {
                body.setPassword(us.encryptPassword(username, password));
            } else {
                body.setPassword(StringUtil.md5Base16((String)password));
            }
        }
        return body;
    }

    protected String[] getEmploymentFields() {
        return new String[]{"startDate", "endDate", "employeeCode", "gradeId", "departmentId", "organizationId"};
    }

    protected String[] getRoleFields() {
        return new String[]{"id", "name", "description"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("User", new ApiDefinition(new User(), this.getFields()));
        defs.put("Employment", new ApiDefinition(new Employment(), this.getEmploymentFields()));
        defs.put("Role", new ApiDefinition(new Role(), this.getRoleFields()));
        defs.put("EmploymentUpdate", new ApiDefinition(new Employment(), new String[]{"id", "employeeCode", "role", "startDate", "endDate"}));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

