/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.dao.FormDataAuditTrailDao;
import org.joget.apps.form.model.FormDataAuditTrail;

public class FormAuditTrailAPI
extends ApiPluginAbstract {
    public String getName() {
        return "FormAuditTrailAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-shoe-prints\"></i>";
    }

    @Override
    public String getTag() {
        return "formAuditTrails";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", type=Operation.MethodType.GET, summary="@@FormAuditTrailAPI.listFormDataAuditTrail.summary@@", description="@@FormAuditTrailAPI.listFormDataAuditTrail.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="FormDataAuditTrail", array=true)})
    public ApiResponse listFormDataAuditTrail(@Param(value="search", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.search.desc@@") String search, @Param(value="dateFrom", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.dateForm.desc@@") Date from, @Param(value="dateTo", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.dateTo.desc@@") Date to, @Param(value="sort", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@FormAuditTrailAPI.listFormDataAuditTrail.pageSize.desc@@") Integer pageSize) {
        String condition = "";
        ArrayList<Object> args = new ArrayList<Object>();
        if (search != null && !search.isEmpty()) {
            condition = "(e.formId like ? or e.tableName like ? or e.username like ? or e.action like ? or e.data like ?)";
            args.add("%" + search + "%");
            args.add("%" + search + "%");
            args.add("%" + search + "%");
            args.add("%" + search + "%");
            args.add("%" + search + "%");
        }
        if (from != null) {
            if (!condition.isEmpty()) {
                condition = condition + " and ";
            }
            condition = condition + "e.datetime >= ?";
            args.add(from);
        }
        if (to != null) {
            if (!condition.isEmpty()) {
                condition = condition + " and ";
            }
            condition = condition + "e.datetime <= ?";
            args.add(to);
        }
        if (!condition.isEmpty()) {
            condition = "where " + condition;
        }
        FormDataAuditTrailDao auditTrailDao = (FormDataAuditTrailDao)AppUtil.getApplicationContext().getBean("formDataAuditTrailDao");
        List auditTrailList = auditTrailDao.getAuditTrails(condition, args.toArray(), sort, desc, startOffset, pageSize);
        return new ApiResponse(200, auditTrailList);
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("FormDataAuditTrail", new ApiDefinition(new FormDataAuditTrail()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

