/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.lib.APIFormUtil;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.FormDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.FormDefinition;
import org.joget.apps.app.model.PackageActivityForm;
import org.joget.apps.app.model.PackageDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.dao.FormDataDao;
import org.joget.apps.form.model.Element;
import org.joget.apps.form.model.Form;
import org.joget.apps.form.model.FormData;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.service.FormService;
import org.joget.apps.form.service.FormUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.TimeZoneUtil;
import org.joget.directory.model.User;
import org.joget.plugin.base.Plugin;
import org.joget.plugin.base.PluginManager;
import org.joget.workflow.model.WorkflowActivity;
import org.joget.workflow.model.WorkflowProcess;
import org.joget.workflow.model.WorkflowProcessResult;
import org.joget.workflow.model.WorkflowVariable;
import org.joget.workflow.model.service.WorkflowManager;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProcessAPI
extends ApiPluginAbstract {
    public String getName() {
        return "ProcessAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)("/properties/api/" + this.getName() + ".json"), null, (boolean)true, (String)this.getResourceBundlePath());
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-tasks\"></i>";
    }

    @Override
    public String getTag() {
        return "process/{processDefId}";
    }

    @Operation(path="/startProcess", summary="@@ProcessAPI.startProcess.summary@@", description="@@ProcessAPI.startProcess.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ProcessResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse startProcess(@Param(value="body", description="@@ProcessAPI.processData@@", definition="{processDefId}-ProcessData") JSONObject body, @Param(value="processInstanceId", description="@@ProcessAPI.processInstanceId@@", required=false) String processInstanceId, @Param(value="recordId", description="@@ProcessAPI.recordId@@", required=false) String recordId) {
        return this.startProcessByUser(body, null, processInstanceId, recordId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(path="/startProcessByUser/{username}", summary="@@ProcessAPI.startProcessByUser.summary@@", description="@@ProcessAPI.startProcessByUser.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ProcessResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse startProcessByUser(@Param(value="body", description="@@ProcessAPI.processData@@", definition="{processDefId}-ProcessData", required=false) JSONObject body, @Param(value="username", description="@@ProcessAPI.startProcessByUser.username.desc@@") String username, @Param(value="processInstanceId", description="@@ProcessAPI.processInstanceId@@", required=false) String processInstanceId, @Param(value="recordId", description="@@ProcessAPI.recordId@@", required=false) String recordId) {
        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = wum.getCurrentUser();
        try {
            String processDefId;
            WorkflowManager workflowManager;
            if (username != null) {
                wum.setCurrentThreadUser(username);
            }
            if ((workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager")).isUserInWhiteList(processDefId = this.getProcessDefId()).booleanValue()) {
                WorkflowProcess processStarted;
                AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                appService.getAppDefinitionWithProcessDefId(processDefId);
                Map<String, String> variables = new HashMap<String, String>();
                JSONObject jsonObject = new JSONObject();
                Form form = this.getForm();
                if (form != null) {
                    FormData formData = new FormData();
                    if ("true".equalsIgnoreCase(this.getPropertyString("ignorePermission"))) {
                        formData.addFormResult("_PREVIEW_MODE", "true");
                    }
                    if (body.has("id")) {
                        if (!body.getString("id").isEmpty() && !"string".equalsIgnoreCase(body.getString("id"))) {
                            recordId = body.getString("id");
                        }
                        body.remove("id");
                    }
                    formData.setPrimaryKeyValue(recordId);
                    FormUtil.executeLoadBinders((Element)form, (FormData)formData);
                    APIFormUtil.jsonToFormData((Element)form, formData, body, this.getPropertyString("ignorePermission"));
                    FormData submitted = appService.submitForm(form, formData, false);
                    if (!submitted.getFormErrors().isEmpty()) {
                        jsonObject.put("id", (Object)"");
                        jsonObject.put("errors", submitted.getFormErrors());
                        ApiResponse apiResponse = new ApiResponse(200, jsonObject);
                        return apiResponse;
                    }
                    recordId = form.getPrimaryKeyValue(submitted);
                    FormRowSet rows = appService.loadFormData(form, recordId);
                    if (!rows.isEmpty()) {
                        FormUtil.retrieveWorkflowVariables((FormRow)((FormRow)rows.get(0)), (Element)form, (FormData)submitted);
                        variables = submitted.getWorkflowVariables();
                    }
                } else {
                    Iterator keys = body.keys();
                    while (keys.hasNext()) {
                        String value;
                        String key = (String)keys.next();
                        if (!body.has(key) || (value = body.getString(key)) == null || value.isEmpty()) continue;
                        variables.put(key, value);
                    }
                }
                WorkflowProcessResult result = workflowManager.processStart(processDefId, processInstanceId, variables, null, recordId, false);
                recordId = result.getParentProcessId();
                String processId = "";
                String activityId = "";
                if (result != null && (processStarted = result.getProcess()) != null) {
                    processId = processStarted.getInstanceId();
                    String packageId = WorkflowUtil.getProcessDefPackageId((String)processStarted.getId());
                    String packageVersion = WorkflowUtil.getProcessDefVersion((String)processStarted.getId());
                    boolean continueNextAssignment = appService.isActivityAutoContinue(packageId, packageVersion, processDefId, "runProcess");
                    Collection activities = result.getActivities();
                    if (continueNextAssignment && activities != null && activities.size() > 0) {
                        activityId = ((WorkflowActivity)activities.iterator().next()).getId();
                    }
                }
                jsonObject.put("processId", (Object)processId);
                jsonObject.put("recordId", (Object)recordId);
                JSONArray startedActivities = new JSONArray();
                startedActivities.put((Object)activityId);
                jsonObject.put("activities", (Object)startedActivities);
                ApiResponse apiResponse = new ApiResponse(200, jsonObject);
                return apiResponse;
            }
            ApiResponse apiResponse = new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            return apiResponse;
        }
        catch (Exception e) {
            ApiResponse apiResponse = new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            return apiResponse;
        }
        finally {
            wum.setCurrentThreadUser(currentUser);
        }
    }

    protected Form getForm() {
        FormDefinition formDef;
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        PackageActivityForm startFormDef = null;
        Form form = null;
        FormService formService = (FormService)AppUtil.getApplicationContext().getBean("formService");
        FormDefinitionDao formDefinitionDao = (FormDefinitionDao)AppUtil.getApplicationContext().getBean("formDefinitionDao");
        startFormDef = appService.retrieveMappedForm(appDef.getAppId(), Long.toString(appDef.getVersion()), this.getPropertyString("processDefId"), "runProcess");
        if (startFormDef != null && startFormDef.getFormId() != null && !startFormDef.getFormId().isEmpty() && (formDef = formDefinitionDao.loadById(startFormDef.getFormId(), appDef)) != null && formDef.getJson() != null) {
            String formJson = formDef.getJson();
            formJson = AppUtil.processHashVariable((String)formJson, null, (String)"json", null);
            form = (Form)formService.createElementFromJson(formJson);
        }
        return form;
    }

    @Operation(path="/abortProcess/{processId}", summary="@@ProcessAPI.abortProcess.summary@@", description="@@ProcessAPI.abortProcess.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse abortProcess(@Param(value="processId", description="@@ProcessAPI.abortProcess.processId.desc@@") String processId) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.processAbort(processId);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/copyProcess/{processId}", summary="@@ProcessAPI.copyProcess.summary@@", description="@@ProcessAPI.copyProcess.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ProcessResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse copyProcess(@Param(value="processId", description="@@ProcessAPI.copyProcess.processId.desc@@") String processId, @Param(value="abortCurrent", description="@@ProcessAPI.abortCurrent@@", required=false) Boolean abortCurrent) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            appService.getAppDefinitionForWorkflowProcess(processId);
            boolean abortFlag = abortCurrent != null ? abortCurrent : false;
            String processDefId = this.getProcessDefId();
            WorkflowProcessResult processResult = workflowManager.processCopyFromInstanceId(processId, processDefId, abortFlag);
            String newProcessId = "";
            String[] startedActivities = new String[]{};
            WorkflowProcess processStarted = processResult.getProcess();
            if (processStarted != null) {
                newProcessId = processStarted.getInstanceId();
                Collection activities = processResult.getActivities();
                ArrayList<String> activityDefIdList = new ArrayList<String>();
                for (WorkflowActivity act : activities) {
                    activityDefIdList.add(act.getId());
                }
                startedActivities = activityDefIdList.toArray(startedActivities);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("processId", (Object)newProcessId);
            jsonObject.put("activities", (Object)startedActivities);
            return new ApiResponse(200, jsonObject);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/listRunning", type=Operation.MethodType.GET, summary="@@ProcessAPI.listRunning.summary@@", description="@@ProcessAPI.listRunning.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Process", array=true)})
    public ApiResponse listRunning(@Param(value="sort", required=false, description="@@ProcessAPI.listRunning.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@ProcessAPI.listRunning.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@ProcessAPI.listRunning.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@ProcessAPI.listRunning.pageSize.desc@@") Integer pageSize) {
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        Collection list = workflowManager.getRunningProcessList(null, this.getPropertyString("processDefId"), null, null, sort, desc, startOffset, pageSize);
        JSONArray datas = new JSONArray();
        for (WorkflowProcess workflowProcess : list) {
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningProcess(workflowProcess.getInstanceId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", workflowProcess.getInstanceId());
            data.put("name", workflowProcess.getName());
            data.put("state", workflowProcess.getState());
            data.put("version", workflowProcess.getVersion());
            data.put("startedTime", TimeZoneUtil.convertToTimeZone((Date)workflowProcess.getStartedTime(), null, (String)AppUtil.getAppDateFormat()));
            data.put("requesterId", workflowProcess.getRequesterId());
            data.put("due", workflowProcess.getDue() != null ? TimeZoneUtil.convertToTimeZone((Date)workflowProcess.getDue(), null, (String)AppUtil.getAppDateFormat()) : "-");
            data.put("serviceLevelMonitor", WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            datas.put(data);
        }
        return new ApiResponse(200, datas);
    }

    @Operation(path="/listParticipated", type=Operation.MethodType.GET, summary="@@ProcessAPI.listParticipated.summary@@", description="@@ProcessAPI.listParticipated.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Process", array=true), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse listParticipated(@Param(value="sort", required=false, description="@@ProcessAPI.listParticipated.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@ProcessAPI.listParticipated.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@ProcessAPI.listParticipated.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@ProcessAPI.listParticipated.pageSize.desc@@") Integer pageSize, @Param(value="processDataTable", required=false, description="@@ProcessAPI.listParticipated.pageSize.desc@@") String processDataTable) {
        String username;
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        Plugin plugin = pluginManager.getPlugin("org.joget.process.ProcessListMenu");
        if (plugin == null) {
            return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()) + ", process enhancement plugin not installed");
        }
        if (processDataTable == null) {
            processDataTable = AppUtil.getCurrentAppDefinition().getAppId() + "_pd";
        }
        if ((username = workflowUserManager.getCurrentUsername()) == null) {
            username = "roleAnonymous";
        }
        FormDataDao dao = (FormDataDao)AppUtil.getApplicationContext().getBean("formDataDao");
        FormRowSet rows = dao.find(processDataTable, processDataTable, "where e.customProperties.processDefId = ? and e.createdBy = ?", (Object[])new String[]{this.getPropertyString("processDefId"), username}, sort, desc, startOffset, pageSize);
        JSONArray datas = new JSONArray();
        for (FormRow r : rows) {
            WorkflowProcess workflowProcess = workflowManager.getRunningProcessById(r.getProperty("processId"));
            if (workflowProcess == null) continue;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", workflowProcess.getInstanceId());
            data.put("name", workflowProcess.getName());
            data.put("state", workflowProcess.getState());
            data.put("version", workflowProcess.getVersion());
            data.put("requesterId", workflowProcess.getRequesterId());
            datas.put(data);
        }
        return new ApiResponse(200, datas);
    }

    @Operation(path="/listCompleted", type=Operation.MethodType.GET, summary="@@ProcessAPI.listCompleted.summary@@", description="@@ProcessAPI.listCompleted.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Process", array=true)})
    public ApiResponse listCompleted(@Param(value="sort", required=false, description="@@ProcessAPI.listCompleted.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@ProcessAPI.listCompleted.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@ProcessAPI.listCompleted.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@ProcessAPI.listCompleted.pageSize.desc@@") Integer pageSize) {
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        Collection list = workflowManager.getCompletedProcessList(null, this.getPropertyString("processDefId"), null, null, sort, desc, startOffset, pageSize);
        JSONArray datas = new JSONArray();
        for (WorkflowProcess workflowProcess : list) {
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningProcess(workflowProcess.getInstanceId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", workflowProcess.getInstanceId());
            data.put("name", workflowProcess.getName());
            data.put("state", workflowProcess.getState());
            data.put("version", workflowProcess.getVersion());
            data.put("startedTime", TimeZoneUtil.convertToTimeZone((Date)workflowProcess.getStartedTime(), null, (String)AppUtil.getAppDateFormat()));
            data.put("requesterId", workflowProcess.getRequesterId());
            data.put("due", workflowProcess.getDue() != null ? TimeZoneUtil.convertToTimeZone((Date)workflowProcess.getDue(), null, (String)AppUtil.getAppDateFormat()) : "-");
            data.put("serviceLevelMonitor", WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            datas.put(data);
        }
        return new ApiResponse(200, datas);
    }

    @Operation(path="/getVariables/{processId}", type=Operation.MethodType.GET, summary="@@ProcessAPI.getVariables.summary@@", description="@@ProcessAPI.getVariables.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Variables", array=true)})
    public ApiResponse getVariables(@Param(value="processId", description="@@ProcessAPI.getVariables.processId.desc@@") String processId) {
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        Collection list = workflowManager.getProcessVariableList(processId);
        JSONObject variables = new JSONObject();
        try {
            for (WorkflowVariable variable : list) {
                variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)processId);
        }
        return new ApiResponse(200, variables);
    }

    @Operation(path="/getProcessDetail/{processId}", type=Operation.MethodType.GET, summary="@@ProcessAPI.getProcessDetail.summary@@", description="@@ProcessAPI.getProcessDetail.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ProcessDetail"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse getProcessDetail(@Param(value="processId", description="@@ProcessAPI.getProcessDetail.processId.desc@@") String processId) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowProcess process = workflowManager.getRunningProcessById(processId);
            if (process == null || process.getId() == null) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningProcess(processId);
            WorkflowProcess trackWflowProcess = workflowManager.getRunningProcessInfo(processId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("processDefId", (Object)process.getId());
            jsonObject.put("processId", (Object)process.getInstanceId());
            jsonObject.put("packageId", (Object)process.getPackageId());
            jsonObject.put("packageName", (Object)process.getPackageName());
            jsonObject.put("name", (Object)process.getName());
            jsonObject.put("version", (Object)process.getVersion());
            jsonObject.put("states", (Object)process.getState());
            jsonObject.put("serviceLevelMonitor", (Object)WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            jsonObject.put("requester", (Object)process.getRequesterId());
            jsonObject.put("states", (Object)process.getState());
            jsonObject.put("startedTime", (Object)TimeZoneUtil.convertToTimeZone((Date)trackWflowProcess.getCreatedTime(), null, (String)AppUtil.getAppDateFormat()));
            jsonObject.put("limit", (Object)trackWflowProcess.getLimit());
            jsonObject.put("dueDate", (Object)TimeZoneUtil.convertToTimeZone((Date)trackWflowProcess.getDue(), null, (String)AppUtil.getAppDateFormat()));
            jsonObject.put("delay", (Object)trackWflowProcess.getDelay());
            jsonObject.put("finishTime", (Object)TimeZoneUtil.convertToTimeZone((Date)trackWflowProcess.getFinishTime(), null, (String)AppUtil.getAppDateFormat()));
            jsonObject.put("timeConsumingFromDateStarted", (Object)trackWflowProcess.getTimeConsumingFromDateCreated());
            JSONObject variables = new JSONObject();
            Collection variableList = workflowManager.getProcessVariableList(processId);
            for (WorkflowVariable variable : variableList) {
                variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
            }
            jsonObject.put("variables", (Object)variables);
            return new ApiResponse(200, jsonObject);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/abortActivity/{processId}/{activityId}", summary="@@ProcessAPI.abortActivity.summary@@", description="@@ProcessAPI.abortActivity.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse abortActivity(@Param(value="processId", description="@@ProcessAPI.abortActivity.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.abortActivity.activityId.desc@@") String activityId) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.activityAbort(processId, activityId);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/listActivities/{processId}", type=Operation.MethodType.GET, summary="@@ProcessAPI.listActivities.summary@@", description="@@ProcessAPI.listActivities.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Activity", array=true)})
    public ApiResponse listActivities(@Param(value="processId", description="@@ProcessAPI.listActivities.processId.desc@@") String processId, @Param(value="sort", required=false, description="@@ProcessAPI.listActivities.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@ProcessAPI.listActivities.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@ProcessAPI.listActivities.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@ProcessAPI.listActivities.pageSize.desc@@") Integer pageSize) {
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        Collection list = workflowManager.getActivityList(processId, startOffset, pageSize, sort, desc);
        JSONArray datas = new JSONArray();
        for (WorkflowActivity workflowActivity : list) {
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningActivity(workflowActivity.getId());
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", workflowActivity.getId());
            data.put("name", workflowActivity.getName());
            data.put("state", workflowActivity.getState());
            data.put("dateCreated", TimeZoneUtil.convertToTimeZone((Date)workflowActivity.getCreatedTime(), null, (String)AppUtil.getAppDateFormat()));
            data.put("serviceLevelMonitor", WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            datas.put(data);
        }
        return new ApiResponse(200, datas);
    }

    @Operation(path="/reassignActivity/{processId}/{activityId}", summary="@@ProcessAPI.reassignActivity.summary@@", description="@@ProcessAPI.reassignActivity.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse reassignActivity(@Param(value="processId", description="@@ProcessAPI.reassignActivity.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.reassignActivity.activityId.desc@@") String activityId, @Param(value="assignee", description="@@ProcessAPI.reassignActivity.assignee.desc@@") String assignee, @Param(value="replacement", description="@@ProcessAPI.reassignActivity.replacement.desc@@") String replacement) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.assignmentReassign(null, processId, activityId, replacement, assignee);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/reevaluateActivity/{processId}/{activityId}", summary="@@ProcessAPI.reevaluateActivity.summary@@", description="@@ProcessAPI.reevaluateActivity.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse reevaluateActivity(@Param(value="processId", description="@@ProcessAPI.reevaluateActivity.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.reevaluateActivity.activityId.desc@@") String activityId) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.reevaluateAssignmentsForActivity(activityId);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/startActivity/{processId}/{activityDefId}", summary="@@ProcessAPI.startActivity.summary@@", description="@@ProcessAPI.startActivity.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ProcessResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse startActivity(@Param(value="processId", description="@@ProcessAPI.startActivity.processId.desc@@") String processId, @Param(value="activityDefId", description="@@ProcessAPI.startActivity.activityDefId.desc@@") String activityDefId, @Param(value="abortCurrent", description="@@ProcessAPI.abortCurrentActivity@@", required=false) Boolean abortCurrent, @Param(value="retrieveVariables", description="@@ProcessAPI.completeActivity.retrieveVariables.desc@@", required=false) Boolean retrieveVariables) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
            appService.getAppDefinitionForWorkflowProcess(processId);
            boolean abortFlag = abortCurrent != null ? abortCurrent : false;
            boolean result = workflowManager.activityStart(processId, activityDefId, abortFlag);
            if (result) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("processId", (Object)processId);
                JSONArray startedActivities = new JSONArray();
                WorkflowActivity act = workflowManager.getActivityByProcess(processId, activityDefId);
                startedActivities.put((Object)act.getId());
                jsonObject.put("activities", (Object)startedActivities);
                if (retrieveVariables != null && retrieveVariables.booleanValue()) {
                    JSONObject variables = new JSONObject();
                    Collection list = workflowManager.getActivityVariableList(act.getId());
                    try {
                        for (WorkflowVariable variable : list) {
                            variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
                        }
                    }
                    catch (Exception e) {
                        LogUtil.error((String)this.getClassName(), (Throwable)e, (String)processId);
                    }
                    jsonObject.put("variables", (Object)variables);
                }
                return new ApiResponse(200, jsonObject);
            }
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/getActivityVariables/{processId}/{activityId}", type=Operation.MethodType.GET, summary="@@ProcessAPI.getActivityVariables.summary@@", description="@@ProcessAPI.getActivityVariables.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Variables", array=true)})
    public ApiResponse getActivityVariables(@Param(value="processId", description="@@ProcessAPI.getActivityVariables.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.getActivityVariables.activityId.desc@@") String activityId) {
        WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
        Collection list = workflowManager.getActivityVariableList(activityId);
        JSONObject variables = new JSONObject();
        try {
            for (WorkflowVariable variable : list) {
                variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)processId);
        }
        return new ApiResponse(200, variables);
    }

    @Operation(path="/setActivityVariables/{processId}/{activityId}", summary="@@ProcessAPI.setActivityVariables.summary@@", description="@@ProcessAPI.setActivityVariables.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse setActivityVariables(@Param(value="processId", description="@@ProcessAPI.setActivityVariables.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.setActivityVariables.activityId.desc@@") String activityId, @Param(value="variables", required=false, description="@@ProcessAPI.variables@@") Map variables) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            workflowManager.activityVariables(activityId, variables);
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/getActivityDetail/{processId}/{activityId}", type=Operation.MethodType.GET, summary="@@ProcessAPI.getActivityDetail.summary@@", description="@@ProcessAPI.getActivityDetail.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ActivityDetail"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse getActivityDetail(@Param(value="processId", description="@@ProcessAPI.getActivityDetail.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.getActivityDetail.activityId.desc@@") String activityId) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowActivity activity = workflowManager.getActivityById(activityId);
            if (activity == null || activity.getId() == null) {
                return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            WorkflowActivity activityInfo = workflowManager.getRunningActivityInfo(activityId);
            double serviceLevelMonitor = workflowManager.getServiceLevelMonitorForRunningActivity(activityId);
            WorkflowActivity trackWflowActivity = workflowManager.getRunningActivityInfo(activityId);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("activityId", (Object)activity.getId());
            jsonObject.put("activityDefId", (Object)activity.getActivityDefId());
            jsonObject.put("processId", (Object)activity.getProcessId());
            jsonObject.put("processDefId", (Object)activity.getProcessDefId());
            jsonObject.put("processVersion", (Object)activity.getProcessVersion());
            jsonObject.put("processName", (Object)activity.getProcessName());
            jsonObject.put("activityName", (Object)activity.getName());
            jsonObject.put("description", (Object)activity.getDescription());
            jsonObject.put("participant", (Object)activityInfo.getPerformer());
            jsonObject.put("acceptedUser", (Object)activityInfo.getNameOfAcceptedUser());
            jsonObject.put("serviceLevelMonitor", (Object)WorkflowUtil.getServiceLevelIndicator((double)serviceLevelMonitor));
            jsonObject.put("state", (Object)activityInfo.getState());
            jsonObject.put("createdTime", (Object)trackWflowActivity.getCreatedTime());
            jsonObject.put("dateLimit", (Object)trackWflowActivity.getLimit());
            jsonObject.put("dueDate", (Object)TimeZoneUtil.convertToTimeZone((Date)trackWflowActivity.getDue(), null, (String)AppUtil.getAppDateFormat()));
            jsonObject.put("delay", (Object)trackWflowActivity.getDelay());
            jsonObject.put("finishTime", (Object)TimeZoneUtil.convertToTimeZone((Date)trackWflowActivity.getFinishTime(), null, (String)AppUtil.getAppDateFormat()));
            jsonObject.put("timeConsumingFromDateCreated", (Object)trackWflowActivity.getTimeConsumingFromDateCreated());
            String[] assignmentUsers = activityInfo.getAssignmentUsers();
            JSONArray assignee = new JSONArray();
            for (String user : assignmentUsers) {
                assignee.put((Object)user);
            }
            jsonObject.put("assignee", (Object)assignee);
            JSONObject variables = new JSONObject();
            Collection variableList = workflowManager.getActivityVariableList(activityId);
            for (WorkflowVariable variable : variableList) {
                variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
            }
            jsonObject.put("variables", (Object)variables);
            return new ApiResponse(200, jsonObject);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    @Operation(path="/completeActivity/{processId}/{activityId}", summary="@@ProcessAPI.completeActivity.summary@@", description="@@ProcessAPI.completeActivity.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse completeActivity(@Param(value="processId", description="@@ProcessAPI.completeActivity.processId.desc@@") String processId, @Param(value="activityId", description="@@ProcessAPI.completeActivity.activityId.desc@@") String activityId, @Param(value="retrieveVariables", description="@@ProcessAPI.completeActivity.retrieveVariables.desc@@", required=false) Boolean retrieveVariables) {
        try {
            WorkflowManager workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager");
            WorkflowActivity assignment = workflowManager.getActivityById(activityId);
            if (assignment == null) {
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
            JSONObject variables = new JSONObject();
            if (retrieveVariables != null && retrieveVariables.booleanValue()) {
                Collection list = workflowManager.getActivityVariableList(activityId);
                try {
                    for (WorkflowVariable variable : list) {
                        variables.put(variable.getId(), variable.getVal() != null ? variable.getVal() : "");
                    }
                }
                catch (Exception e) {
                    LogUtil.error((String)this.getClassName(), (Throwable)e, (String)processId);
                }
            }
            String processDefId = assignment.getProcessDefId();
            if ("tool".equals(assignment.getType())) {
                workflowManager.activityForceComplete(processDefId, processId, activityId);
            } else {
                WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
                AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                String username = workflowUserManager.getCurrentUsername();
                if (username == null) {
                    username = "roleAnonymous";
                }
                appService.getAppDefinitionForWorkflowActivity(activityId);
                workflowManager.assignmentForceComplete(processDefId, processId, activityId, username);
            }
            if (retrieveVariables != null && retrieveVariables.booleanValue()) {
                return new ApiResponse(200, variables);
            }
            return new ApiResponse(200, AppPluginUtil.getMessage((String)"FormAPI.resp.200", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
        catch (Exception e) {
            return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
        }
    }

    protected String getProcessDefId() {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        PackageDefinition packageDef = appDef.getPackageDefinition();
        return AppUtil.getProcessDefIdWithVersion((String)packageDef.getId(), (String)packageDef.getVersion().toString(), (String)this.getPropertyString("processDefId"));
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        LinkedHashMap<String, Class> processDef = new LinkedHashMap<String, Class>();
        processDef.put("id", String.class);
        processDef.put("name", String.class);
        processDef.put("state", String.class);
        processDef.put("version", String.class);
        processDef.put("startedTime", String.class);
        processDef.put("requesterId", String.class);
        processDef.put("due", String.class);
        processDef.put("serviceLevelMonitor", String.class);
        defs.put("Process", new ApiDefinition(processDef));
        LinkedHashMap<String, Class> processDetailDef = new LinkedHashMap<String, Class>();
        processDetailDef.put("processDefId", String.class);
        processDetailDef.put("processId", String.class);
        processDetailDef.put("packageId", String.class);
        processDetailDef.put("packageName", String.class);
        processDetailDef.put("name", String.class);
        processDetailDef.put("version", String.class);
        processDetailDef.put("states", String.class);
        processDetailDef.put("serviceLevelMonitor", String.class);
        processDetailDef.put("requester", String.class);
        processDetailDef.put("states", String.class);
        processDetailDef.put("startedTime", String.class);
        processDetailDef.put("limit", String.class);
        processDetailDef.put("dueDate", String.class);
        processDetailDef.put("delay", String.class);
        processDetailDef.put("finishTime", String.class);
        processDetailDef.put("timeConsumingFromDateStarted", String.class);
        processDetailDef.put("variables", Map.class);
        defs.put("ProcessDetail", new ApiDefinition(processDetailDef));
        LinkedHashMap<String, Class> activityDef = new LinkedHashMap<String, Class>();
        activityDef.put("id", String.class);
        activityDef.put("name", String.class);
        activityDef.put("state", String.class);
        activityDef.put("dateCreated", String.class);
        activityDef.put("serviceLevelMonitor", String.class);
        defs.put("Activity", new ApiDefinition(activityDef));
        LinkedHashMap<String, Class> activityDetailDef = new LinkedHashMap<String, Class>();
        activityDetailDef.put("activityId", String.class);
        activityDetailDef.put("activityDefId", String.class);
        activityDetailDef.put("processId", String.class);
        activityDetailDef.put("processDefId", String.class);
        activityDetailDef.put("processVersion", String.class);
        activityDetailDef.put("processName", String.class);
        activityDetailDef.put("activityName", String.class);
        activityDetailDef.put("description", String.class);
        activityDetailDef.put("participant", String.class);
        activityDetailDef.put("acceptedUser", String.class);
        activityDetailDef.put("serviceLevelMonitor", String.class);
        activityDetailDef.put("state", String.class);
        activityDetailDef.put("createdTime", String.class);
        activityDetailDef.put("dateLimit", String.class);
        activityDetailDef.put("dueDate", String.class);
        activityDetailDef.put("delay", String.class);
        activityDetailDef.put("finishTime", String.class);
        activityDetailDef.put("timeConsumingFromDateCreated", String.class);
        activityDetailDef.put("assignee", String[].class);
        activityDetailDef.put("variables", Map.class);
        defs.put("ActivityDetail", new ApiDefinition(activityDetailDef));
        defs.put("Variables", new ApiDefinition(ApiService.getSchema(Map.class, null, true)));
        LinkedHashMap<String, Class> processResponseDef = new LinkedHashMap<String, Class>();
        processResponseDef.put("processId", String.class);
        processResponseDef.put("recordId", String.class);
        processResponseDef.put("activities", String[].class);
        processResponseDef.put("variables", Map.class);
        defs.put("ProcessResponse", new ApiDefinition(processResponseDef));
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)"object");
            JSONOrderedObject properties = new JSONOrderedObject();
            properties.put("id", ApiService.getSchema(String.class, null, false));
            Form form = this.getForm();
            if (form != null) {
                FormData formData = new FormData();
                APIFormUtil.recursiveGenerateDefinition(formData, properties, (Element)form, false);
                properties.put("dateCreated", ApiService.getSchema(Date.class, null, false));
                properties.put("dateModified", ApiService.getSchema(Date.class, null, false));
                properties.put("createdBy", ApiService.getSchema(String.class, null, false));
                properties.put("createdByName", ApiService.getSchema(String.class, null, false));
                properties.put("modifiedBy", ApiService.getSchema(String.class, null, false));
                properties.put("modifiedByName", ApiService.getSchema(String.class, null, false));
                obj.put("properties", (Object)properties);
                defs.put(this.getPropertyString("processDefId") + "-ProcessData", new ApiDefinition(obj));
            } else {
                defs.put(this.getPropertyString("processDefId") + "-ProcessData", new ApiDefinition(ApiService.getSchema(Map.class, null, true)));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

