/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.report.model.ReportRow;
import org.joget.report.service.ReportManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;

public class SlaAPI
extends ApiPluginAbstract {
    public String getName() {
        return "SlaAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-tasks\"></i>";
    }

    @Override
    public String getTag() {
        return "sla";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", type=Operation.MethodType.GET, summary="@@SlaAPI.list.summary@@", description="@@SlaAPI.list.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Sla", array=true)})
    public ApiResponse list(@Param(value="appId", required=false, description="@@SlaAPI.list.appId.desc@@") String appId, @Param(value="appVersion", required=false, description="@@SlaAPI.list.appVersion.desc@@") String appVersion, @Param(value="processDefId", required=false, description="@@SlaAPI.list.processDefId.desc@@") String processDefId, @Param(value="sort", required=false, description="@@SlaAPI.list.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@SlaAPI.list.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@SlaAPI.list.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@SlaAPI.list.pageSize.desc@@") Integer pageSize) {
        ReportManager reportManager = (ReportManager)AppUtil.getApplicationContext().getBean("reportManager");
        Collection activitySla = reportManager.getWorkflowActivitySlaReport(appId, appVersion, processDefId, sort, desc, startOffset, pageSize);
        JSONArray datas = new JSONArray();
        for (ReportRow row : activitySla) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("activityDefId", row.getId());
            data.put("activityName", row.getName());
            data.put("minDelay", row.getMinDelay());
            data.put("maxDelay", row.getMaxDelay());
            data.put("ratioWithDelay", row.getRatioWithDelay());
            data.put("ratioOnTime", row.getRatioOnTime());
            data.put("serviceLevelMonitor", WorkflowUtil.getServiceLevelIndicator((double)row.getRatioOnTime()));
            datas.put(data);
        }
        return new ApiResponse(200, datas);
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        LinkedHashMap<String, Class> slaResponseDef = new LinkedHashMap<String, Class>();
        slaResponseDef.put("activityDefId", String.class);
        slaResponseDef.put("activityName", String.class);
        slaResponseDef.put("minDelay", Double.class);
        slaResponseDef.put("maxDelay", Double.class);
        slaResponseDef.put("ratioWithDelay", Double.class);
        slaResponseDef.put("ratioOnTime", Double.class);
        slaResponseDef.put("serviceLevelMonitor", String.class);
        defs.put("Sla", new ApiDefinition(slaResponseDef));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

