/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiBuilder;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.workflow.model.dao.WorkflowHelper;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONObject;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;

public class SsoAPI
extends ApiPluginAbstract {
    public String getName() {
        return "SsoAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-user\"></i>";
    }

    @Override
    public String getTag() {
        return "sso";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", summary="@@SsoAPI.sso.summary@@", description="@@SsoAPI.sso.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="SsoResponse"), @Response(responseCode=401, description="@@FormAPI.resp.401@@", definition="ApiResponse")})
    public ApiResponse sso(HttpServletRequest httpRequest, HttpServletResponse httpResponse, @Param(value="j_username", required=false, description="@@SsoAPI.username@@") String username, @Param(value="j_password", required=false, description="@@SsoAPI.password@@") String password, @Param(value="hash", required=false, description="@@SsoAPI.hash@@") String hash) {
        block11: {
            boolean loginWithFilter = false;
            String header = httpRequest.getHeader("Authorization");
            if (header != null && header.startsWith("Basic ")) {
                loginWithFilter = true;
            }
            if (username != null && !username.isEmpty() && !loginWithFilter) {
                String ip = AppUtil.getClientIp((HttpServletRequest)httpRequest);
                WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
                try {
                    boolean authenticated;
                    if (password == null) {
                        password = hash;
                    }
                    UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
                    AuthenticationManager authenticationManager = (AuthenticationManager)AppUtil.getApplicationContext().getBean("authenticationManager");
                    Authentication result = authenticationManager.authenticate((Authentication)request);
                    SecurityContextHolder.getContext().setAuthentication(result);
                    HttpSession session = httpRequest.getSession(false);
                    if (session != null) {
                        SavedRequest savedRequest = new HttpSessionRequestCache().getRequest(httpRequest, httpResponse);
                        session.invalidate();
                        session = httpRequest.getSession(true);
                        if (savedRequest != null) {
                            new HttpSessionRequestCache().saveRequest(httpRequest, httpResponse);
                        }
                    }
                    if (authenticated = result.isAuthenticated()) {
                        wum.clearCurrentThreadUser();
                    }
                    LogUtil.info((String)this.getClass().getName(), (String)("Authentication for user " + username + " (" + ip + ") : " + authenticated));
                    WorkflowHelper workflowHelper = (WorkflowHelper)AppUtil.getApplicationContext().getBean("workflowHelper");
                    workflowHelper.addAuditTrail(this.getClass().getName(), "authenticate", "Authentication for user " + username + " (" + ip + ") : " + authenticated);
                }
                catch (AuthenticationException e) {
                    if (username == null) break block11;
                    LogUtil.info((String)this.getClass().getName(), (String)("Authentication for user " + username + " (" + ip + ") : false"));
                    WorkflowHelper workflowHelper = (WorkflowHelper)AppUtil.getApplicationContext().getBean("workflowHelper");
                    workflowHelper.addAuditTrail(this.getClass().getName(), "authenticate", "Authentication for user " + username + " (" + ip + ") : false");
                }
            }
        }
        if (WorkflowUtil.isCurrentUserAnonymous()) {
            return ApiBuilder.writeUnauthorized(httpResponse);
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("username", (Object)WorkflowUtil.getCurrentUsername());
            boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
            jsonObject.put("isAdmin", isAdmin);
            String csrfToken = SecurityUtil.getCsrfTokenName() + "=" + SecurityUtil.getCsrfTokenValue((HttpServletRequest)httpRequest);
            jsonObject.put("token", (Object)csrfToken);
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        return new ApiResponse(200, jsonObject);
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        LinkedHashMap<String, Class> ssoResponseDef = new LinkedHashMap<String, Class>();
        ssoResponseDef.put("username", String.class);
        ssoResponseDef.put("isAdmin", Boolean.class);
        ssoResponseDef.put("token", String.class);
        defs.put("SsoResponse", new ApiDefinition(ssoResponseDef));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

