/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiPluginAbstract;
import org.joget.api.model.ApiResponse;
import org.joget.api.service.ApiService;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.spring.model.Setting;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SetupManager;

public class SystemAPI
extends ApiPluginAbstract {
    public String getName() {
        return "SystemAPI";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getClassName() {
        return this.getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-cog\"></i>";
    }

    @Override
    public String getTag() {
        return "system";
    }

    @Override
    public String getTagDesc() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".tagDesc"), (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    @Operation(path="/", type=Operation.MethodType.PUT, summary="@@SystemAPI.updateSetting.summary@@", description="@@SystemAPI.updateSetting.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Setting"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse"), @Response(responseCode=405, description="@@FormAPI.resp.405@@", definition="ApiResponse")})
    public ApiResponse updateSetting(@Param(value="body", description="@@SystemAPI.body@@", definition="Setting") Setting body) {
        SetupManager manager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting obj = manager.getSettingByProperty(body.getProperty());
        if (obj != null) {
            ApiService.mergeObject(obj, body);
            try {
                manager.saveSetting(obj);
                return new ApiResponse(200, obj, this.getFields());
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
                return new ApiResponse(405, AppPluginUtil.getMessage((String)"FormAPI.resp.405", (String)this.getClassName(), (String)this.getResourceBundlePath()));
            }
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    @Operation(path="/find", type=Operation.MethodType.GET, summary="@@SystemAPI.findSetting.summary@@", description="@@SystemAPI.findSetting.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Setting", array=true)})
    public ApiResponse findSetting(@Param(value="propertyFilter", required=false, description="@@SystemAPI.findSetting.propertyFilter.desc@@") String nameFilter, @Param(value="sort", required=false, description="@@SystemAPI.findSetting.sort.desc@@") String sort, @Param(value="sortDescending", required=false, description="@@SystemAPI.findSetting.sortDescending.desc@@") Boolean desc, @Param(value="startOffset", required=false, description="@@SystemAPI.findSetting.startOffset.desc@@") Integer startOffset, @Param(value="pageSize", required=false, description="@@SystemAPI.findSetting.pageSize.desc@@") Integer pageSize) {
        SetupManager manager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Collection objs = manager.getSettingList(nameFilter, sort, desc, startOffset, pageSize);
        return new ApiResponse(200, objs, this.getFields());
    }

    @Operation(path="/{property}", type=Operation.MethodType.GET, summary="@@SystemAPI.getSetting.summary@@", description="@@SystemAPI.getSetting.desc@@")
    @Responses(value={@Response(responseCode=200, description="@@FormAPI.resp.200@@", definition="Setting"), @Response(responseCode=404, description="@@FormAPI.resp.404@@", definition="ApiResponse")})
    public ApiResponse getSetting(@Param(value="property", description="@@SystemAPI.property@@") String property) {
        SetupManager manager = (SetupManager)AppUtil.getApplicationContext().getBean("setupManager");
        Setting obj = manager.getSettingByProperty(property);
        if (obj != null) {
            return new ApiResponse(200, obj, this.getFields());
        }
        return new ApiResponse(404, AppPluginUtil.getMessage((String)"FormAPI.resp.404", (String)this.getClassName(), (String)this.getResourceBundlePath()));
    }

    protected String[] getFields() {
        return new String[]{"property", "value"};
    }

    @Override
    public Map<String, ApiDefinition> getDefinitions() {
        HashMap<String, ApiDefinition> defs = new HashMap<String, ApiDefinition>();
        defs.put("Setting", new ApiDefinition(new Setting(), this.getFields()));
        return defs;
    }

    @Override
    public String getResourceBundlePath() {
        return "messages/apiPlugin";
    }
}

