/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.model;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSerializer;
import java.io.Writer;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.joget.api.service.ApiResponseExclusionStrategy;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.ResourceBundleUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiResponse {
    protected int status;
    protected String message = null;
    protected String content = null;
    protected String contentType = "application/json; charset=utf-8";
    protected boolean isCustomResponse = false;
    protected Parameter[] parameters;
    protected List<Object> parameterValues;

    public ApiResponse(int status, String message) {
        this.status = status;
        this.message = message;
    }

    public ApiResponse(int status, JSONObject json) {
        this.status = status;
        this.content = json.toString();
    }

    public ApiResponse(int status, JSONArray json) {
        this.status = status;
        this.content = json.toString();
    }

    public ApiResponse(int status, Object obj) {
        this(status, obj, null, true);
    }

    public ApiResponse(int status, Object obj, String[] fields) {
        this(status, obj, fields, false);
    }

    public ApiResponse(int status, Object obj, String[] fields, boolean isExclude) {
        this(status, obj, fields, isExclude, null);
    }

    public ApiResponse(int status, Object obj, String[] fields, boolean isExclude, Map<Type, JsonSerializer> serializers) {
        this.status = status;
        try {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new ApiResponseExclusionStrategy(fields, isExclude)}).serializeNulls();
            if (serializers != null) {
                for (Type type : serializers.keySet()) {
                    gsonBuilder.registerTypeAdapter(type, (Object)serializers.get(type));
                }
            }
            Gson gson = gsonBuilder.create();
            this.content = gson.toJson(obj);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiResponse.class.getName(), (Throwable)e, (String)"");
            this.status = 500;
            this.message = ResourceBundleUtil.getMessage((String)"api.error.500");
        }
    }

    public ApiResponse(int status, String content, String contentType) {
        this.status = status;
        this.content = content;
        if (contentType != null && !contentType.isEmpty()) {
            this.contentType = contentType;
        }
    }

    public ApiResponse(int status, boolean isCustomResponse) {
        this.status = status;
        this.isCustomResponse = isCustomResponse;
    }

    public void write(HttpServletResponse response) {
        response.setStatus(this.status);
        if (!this.isCustomResponse) {
            response.setContentType(this.contentType);
            try {
                if (this.status >= 400) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("code", (Object)Integer.toString(this.status));
                    jsonObject.put("message", (Object)this.message);
                    jsonObject.put("date", (Object)new Date());
                    jsonObject.write((Writer)response.getWriter());
                } else if (this.contentType.contains("/json") && this.content == null && this.message != null) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("code", (Object)Integer.toString(this.status));
                    jsonObject.put("message", (Object)this.message);
                    jsonObject.put("date", (Object)new Date());
                    jsonObject.write((Writer)response.getWriter());
                } else if (this.content != null) {
                    response.getWriter().write(this.content);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)ApiResponse.class.getName(), (Throwable)e, (String)"Unable to write response");
            }
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getContent() {
        return this.content;
    }

    public Parameter[] getParameter() {
        return this.parameters;
    }

    public void setParameter(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List<Object> parameterValues) {
        this.parameterValues = parameterValues;
    }
}

