/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.model;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.joget.commons.util.LogUtil;

public class FieldsSerializer
implements JsonSerializer {
    private String[] fields;

    public FieldsSerializer(String[] fields) {
        this.fields = fields;
    }

    public JsonElement serialize(Object obj, Type type, JsonSerializationContext context) {
        JsonObject jsonObj = new JsonObject();
        if (this.fields != null) {
            for (String field : this.fields) {
                try {
                    Object value = this.getAttribute(obj, field);
                    if (value != null) {
                        jsonObj.add(field, context.serialize(value));
                        continue;
                    }
                    jsonObj.add(field, (JsonElement)new JsonNull());
                }
                catch (Exception e) {
                    LogUtil.info((String)FieldsSerializer.class.getName(), (String)("Failed to retrieving attribute " + field));
                }
            }
        }
        return jsonObj;
    }

    protected Object getAttribute(Object obj, String attribute) throws Exception {
        if (obj != null) {
            String subAttr = "";
            if (attribute.contains(".")) {
                subAttr = attribute.substring(attribute.indexOf(".") + 1);
                attribute = attribute.substring(0, attribute.indexOf("."));
            }
            char firstChar = attribute.charAt(0);
            firstChar = Character.toUpperCase(firstChar);
            attribute = firstChar + attribute.substring(1, attribute.length());
            Method method = null;
            try {
                method = obj.getClass().getDeclaredMethod("get" + attribute, new Class[0]);
            }
            catch (Exception ex) {
                try {
                    method = obj.getClass().getDeclaredMethod("is" + attribute, new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?> clazz = obj.getClass();
                while (method == null && clazz.getSuperclass() != null) {
                    clazz = clazz.getSuperclass();
                    try {
                        method = clazz.getDeclaredMethod("get" + attribute, new Class[0]);
                    }
                    catch (Exception ex) {
                        try {
                            method = clazz.getDeclaredMethod("is" + attribute, new Class[0]);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (method == null) {
                throw new RuntimeException("method not exist");
            }
            method.setAccessible(true);
            Object returnResult = method.invoke(obj, new Object[0]);
            if (returnResult == null) {
                return null;
            }
            if (!subAttr.isEmpty()) {
                return this.getAttribute(returnResult, subAttr);
            }
            return returnResult;
        }
        return null;
    }
}

