/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.service;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.joget.api.annotations.Operation;
import org.joget.api.annotations.Param;
import org.joget.api.annotations.Response;
import org.joget.api.annotations.Responses;
import org.joget.api.dao.ApiCredentialDao;
import org.joget.api.dao.ApiLogDao;
import org.joget.api.model.ApiAuthenticatorAbstract;
import org.joget.api.model.ApiCredential;
import org.joget.api.model.ApiDefinition;
import org.joget.api.model.ApiLog;
import org.joget.api.model.ApiPlugin;
import org.joget.api.model.ApiResponse;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiAppContext;
import org.joget.api.service.ApiService;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.CustomBuilder;
import org.joget.apps.app.model.CustomBuilderAbstract;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.apps.userview.model.Permission;
import org.joget.commons.util.DynamicDataSourceManager;
import org.joget.commons.util.FileStore;
import org.joget.commons.util.HostManager;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.ResourceBundleUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.Plugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.workflow.model.dao.WorkflowHelper;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class ApiBuilder
extends CustomBuilderAbstract
implements PluginWebSupport {
    public String getName() {
        return "apiBuilder";
    }

    public String getObjectName() {
        return "api";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getIcon() {
        return "fas fa-key";
    }

    public String getColor() {
        return "#85ea2d";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/apiPlugin");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/apiPlugin");
    }

    public String getObjectLabel() {
        return AppPluginUtil.getMessage((String)"apiBuilder.apiKey", (String)this.getClassName(), (String)"messages/apiPlugin");
    }

    public String getIdPrefix() {
        return "API-";
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/api/setting.json", null, (boolean)true, (String)"messages/apiPlugin");
    }

    public String getBuilderConfig() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/api/api_builder.json", null, (boolean)false, (String)"messages/apiPlugin");
    }

    public String getResourceBundlePath() {
        return "messages/apiBuilder";
    }

    public String getBuilderJS(String contextPath, String buildNumber) {
        return "<script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.api.service.ApiBuilder/api/apibuilder.js?build=" + this.getVersion() + buildNumber + "\"></script>";
    }

    public String getBuilderCSS(String contextPath, String buildNumber) {
        String css = "<link href=\"" + contextPath + "/plugin/org.joget.api.service.ApiBuilder/api/apibuilder.css?build=" + this.getVersion() + buildNumber + "\" rel=\"stylesheet\" type=\"text/css\" />";
        return css;
    }

    public String getBuilderHTML(BuilderDefinition def, String json, HttpServletRequest request, HttpServletResponse response) {
        String cacheKey = DynamicDataSourceManager.getCurrentProfile() + "_API_BUILDER_" + def.getId();
        Cache cache = (Cache)AppUtil.getApplicationContext().getBean("fluCache");
        cache.remove((Serializable)((Object)cacheKey));
        return "";
    }

    public void builderPreview(String json, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=utf-8");
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("spec", this.getBuilderResult(json, new HashMap<String, Object>()));
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            model.put("api_id", ApiBuilder.addToPreviewCache(appDef.getAppId(), json));
            model.put("api_key", "******************");
            model.put("api_secret", "******************");
            String html = CustomBuilderUtil.generateHtml((CustomBuilder)this, (String)"templates/swagger-ui.ftl", model, (HttpServletRequest)request);
            response.getWriter().write(html);
        }
        catch (Exception ex) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)ex, (String)"");
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        try {
            JSONArray jsonArray = new JSONArray();
            for (ApiPlugin e : ApiBuilder.getAvailableElements()) {
                HashMap<String, Object> option = new HashMap<String, Object>();
                option.put("className", e.getClassName());
                option.put("icon", e.getIcon());
                option.put("label", e.getLabel());
                option.put("propertyOptions", e.getPropertyOptions());
                option.put("tag", e.getTag());
                ArrayList operations = new ArrayList();
                for (Map.Entry<String, String> o : e.getOperationOptions().entrySet()) {
                    HashMap<String, String> temp = new HashMap<String, String>();
                    temp.put("value", o.getKey());
                    temp.put("label", o.getValue());
                    operations.add(temp);
                }
                option.put("operations", operations);
                option.put("isSimple", e.usingSimpleConfig());
                if (e.getPropertyOptions() != null && !e.getPropertyOptions().isEmpty()) {
                    option.put("defaultProperties", PropertyUtil.getDefaultPropertyValues((String)option.get("propertyOptions").toString()));
                } else {
                    option.put("defaultProperties", "{}");
                }
                jsonArray.put(option);
            }
            jsonArray.write((Writer)response.getWriter());
        }
        catch (Exception ex) {
            LogUtil.error((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex, (String)"Get available report element plugin error!");
        }
    }

    public Object getBuilderResult(String json, Map<String, Object> config) {
        if (json == null) {
            this.serveApi((HttpServletRequest)config.get("request"), (HttpServletResponse)config.get("response"), (Date)config.get("timestamp"));
        } else {
            try {
                JSONArray elements;
                JSONObject api = new JSONObject(json);
                JSONObject apiProps = api.getJSONObject("properties");
                HashSet<String> usedDef = new HashSet<String>();
                HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
                if (request != null) {
                    request.setAttribute("api_id", (Object)apiProps.getString("id"));
                }
                JSONOrderedObject swagger = new JSONOrderedObject();
                swagger.put("openapi", "3.0.1");
                JSONOrderedObject info = new JSONOrderedObject();
                info.put("description", apiProps.getString("description"));
                info.put("version", ResourceBundleUtil.getMessage((String)"build.version"));
                info.put("title", apiProps.getString("name"));
                if (apiProps.has("termsOfService") && !apiProps.getString("termsOfService").isEmpty()) {
                    info.put("termsOfService", apiProps.getString("termsOfService"));
                }
                if (apiProps.has("contactEmail") && !apiProps.getString("contactEmail").isEmpty()) {
                    JSONOrderedObject contact = new JSONOrderedObject();
                    contact.put("email", apiProps.getString("contactEmail"));
                    if (apiProps.has("contactName") && !apiProps.getString("contactName").isEmpty()) {
                        contact.put("name", apiProps.getString("contactName"));
                    }
                    info.put("contact", (Object)contact);
                }
                if (apiProps.has("licenseUrl") && !apiProps.getString("licenseUrl").isEmpty()) {
                    JSONOrderedObject license = new JSONOrderedObject();
                    license.put("url", apiProps.getString("licenseUrl"));
                    if (apiProps.has("licenseName") && !apiProps.getString("licenseName").isEmpty()) {
                        license.put("name", apiProps.getString("licenseName"));
                    }
                    info.put("license", (Object)license);
                }
                swagger.put("info", (Object)info);
                String scheme = request.getScheme();
                String serverName = request.getServerName();
                int serverPort = request.getServerPort();
                StringBuilder url = new StringBuilder();
                url.append(scheme).append("://");
                url.append(serverName);
                if (serverPort != 80 && serverPort != 443) {
                    url.append(":").append(serverPort);
                }
                url.append(request.getContextPath()).append("/api");
                swagger.put("servers", new Object[]{new JSONOrderedObject().put("url", url)});
                JSONOrderedObject securityDefinitions = new JSONOrderedObject();
                securityDefinitions.put("api_id", new JSONOrderedObject().put("type", "apiKey").put("in", (Object)"header").put("name", (Object)"api_id"));
                securityDefinitions.put("api_key", new JSONOrderedObject().put("type", "apiKey").put("in", (Object)"header").put("name", (Object)"api_key"));
                securityDefinitions.put("token", new JSONOrderedObject().put("type", "apiKey").put("in", (Object)"header").put("name", (Object)"token"));
                securityDefinitions.put("Authorization", new JSONOrderedObject().put("type", "apiKey").put("in", (Object)"header").put("name", (Object)"Authorization"));
                JSONArray security = new JSONArray();
                JSONObject security1 = new JSONObject();
                security1.put("api_id", (Object)new JSONOrderedObject());
                security1.put("api_key", (Object)new JSONOrderedObject());
                security.put((Object)security1);
                JSONObject security2 = new JSONObject();
                security2.put("api_id", (Object)new JSONOrderedObject());
                security2.put("api_key", (Object)new JSONOrderedObject());
                security2.put("token", (Object)new JSONOrderedObject());
                security.put((Object)security2);
                JSONObject security3 = new JSONObject();
                security3.put("api_id", (Object)new JSONOrderedObject());
                security3.put("api_key", (Object)new JSONOrderedObject());
                security3.put("Authorization", (Object)new JSONOrderedObject());
                security.put((Object)security3);
                JSONOrderedObject definitions = new JSONOrderedObject();
                LinkedHashMap paths = new LinkedHashMap();
                JSONArray tags = new JSONArray();
                if (api.has("elements") && (elements = api.getJSONArray("elements")).length() > 0) {
                    PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                    JSONObject element = null;
                    JSONObject properties = null;
                    ApiPlugin apiPlugin = null;
                    String className = null;
                    String tag = null;
                    Object key = null;
                    Object value = null;
                    boolean propertyNotFound = false;
                    JSONOrderedObject tagObj = null;
                    for (int i = 0; i < elements.length(); ++i) {
                        element = elements.getJSONObject(i);
                        if (!element.has("className") || (className = element.getString("className")) == null || className.isEmpty() || (apiPlugin = (ApiPlugin)pluginManager.getPlugin(className)) == null || (tag = apiPlugin.getTag()).contains("{") && tag.contains("}") && (!element.has("properties") || (tag = ApiBuilder.populateVariable(tag, properties = element.getJSONObject("properties"))).contains("{") && tag.contains("}"))) continue;
                        apiPlugin.setProperties(PropertyUtil.getProperties((JSONObject)element.getJSONObject("properties")));
                        tagObj = new JSONOrderedObject();
                        tagObj.put("name", tag);
                        tagObj.put("description", apiPlugin.getTagDesc());
                        if (apiPlugin.getExternalDocsURL() != null && !apiPlugin.getExternalDocsURL().isEmpty()) {
                            JSONOrderedObject ext = new JSONOrderedObject();
                            ext.put("url", apiPlugin.getExternalDocsURL());
                            if (apiPlugin.getExternalDocsURL() != null && !apiPlugin.getExternalDocsURL().isEmpty()) {
                                ext.put("description", apiPlugin.getExternalDocsDesc());
                            }
                            tagObj.put("externalDocs", (Object)ext);
                        }
                        for (Method m : apiPlugin.getOperationMethods().values()) {
                            Parameter[] parameters;
                            HashMap<String, JSONOrderedObject> opObject;
                            Operation op;
                            if (!m.isAnnotationPresent(Operation.class) || !apiPlugin.isAPIEnabled((op = m.getAnnotation(Operation.class)).type().toString(), op.path()).booleanValue()) continue;
                            String oPath = "/" + tag;
                            if (!op.path().equals("/")) {
                                oPath = oPath + op.path();
                            }
                            if ((opObject = (HashMap<String, JSONOrderedObject>)paths.get(oPath)) == null) {
                                opObject = new HashMap<String, JSONOrderedObject>();
                                paths.put(oPath, opObject);
                            }
                            JSONOrderedObject obj = new JSONOrderedObject();
                            obj.put("tags", new String[]{tag});
                            obj.put("summary", ApiService.getMessage(apiPlugin, op.summary()));
                            obj.put("description", ApiService.getMessage(apiPlugin, op.description()));
                            obj.put("operationId", m.getName());
                            JSONArray params = new JSONArray();
                            for (Parameter p : parameters = m.getParameters()) {
                                String pdef;
                                JSONOrderedObject rs;
                                JSONOrderedObject rContent;
                                JSONOrderedObject requestBody;
                                Param pAnno = p.getAnnotation(Param.class);
                                if (pAnno == null) continue;
                                JSONOrderedObject pObj = new JSONOrderedObject();
                                String name = pAnno.value();
                                pObj.put("name", name);
                                if ("body".equalsIgnoreCase(name)) {
                                    requestBody = new JSONOrderedObject();
                                    if (!pAnno.description().isEmpty()) {
                                        requestBody.put("description", ApiService.getMessage(apiPlugin, pAnno.description()));
                                    }
                                    rContent = new JSONOrderedObject();
                                    if (!pAnno.definition().isEmpty()) {
                                        rs = new JSONOrderedObject();
                                        pdef = pAnno.definition();
                                        if (pdef.contains("{")) {
                                            pdef = ApiBuilder.populateVariable(pdef, element.getJSONObject("properties"));
                                        }
                                        usedDef.add(pdef);
                                        rs.put("$ref", "#/components/schemas/" + pdef);
                                        rContent.put("schema", (Object)rs);
                                    }
                                    requestBody.put("content", new JSONOrderedObject().put(op.bodyContentType(), (Object)rContent));
                                    obj.put("requestBody", (Object)requestBody);
                                    continue;
                                }
                                if (pAnno.header()) {
                                    pObj.put("in", "header");
                                } else if (op.path().contains("{" + name + "}")) {
                                    pObj.put("in", "path");
                                } else {
                                    if (byte[].class.isAssignableFrom(p.getType()) || InputStream.class.isAssignableFrom(p.getType())) {
                                        requestBody = new JSONOrderedObject();
                                        if (!pAnno.description().isEmpty()) {
                                            requestBody.put("description", ApiService.getMessage(apiPlugin, pAnno.description()));
                                        }
                                        rContent = new JSONOrderedObject();
                                        if (!pAnno.definition().isEmpty()) {
                                            rs = new JSONOrderedObject();
                                            pdef = pAnno.definition();
                                            if (pdef.contains("{")) {
                                                pdef = ApiBuilder.populateVariable(pdef, element.getJSONObject("properties"));
                                            }
                                            usedDef.add(pdef);
                                            rs.put("$ref", "#/components/schemas/" + pdef);
                                            rContent.put("schema", (Object)rs);
                                        } else {
                                            JSONOrderedObject file = new JSONOrderedObject();
                                            file.put("type", "string");
                                            file.put("format", "binary");
                                            rContent.put("schema", (Object)file);
                                        }
                                        requestBody.put("content", new JSONOrderedObject().put("application/octet-stream", (Object)rContent));
                                        obj.put("requestBody", (Object)requestBody);
                                        continue;
                                    }
                                    pObj.put("in", "query");
                                }
                                if (!pAnno.description().isEmpty()) {
                                    pObj.put("description", ApiService.getMessage(apiPlugin, pAnno.description()));
                                }
                                pObj.put("required", pAnno.required() || op.path().contains("{" + name + "}"));
                                String def = null;
                                if (!pAnno.definition().isEmpty()) {
                                    def = pAnno.definition();
                                    if (def.contains("{")) {
                                        def = ApiBuilder.populateVariable(def, element.getJSONObject("properties"));
                                    }
                                    usedDef.add(def);
                                    def = "#/components/schemas/" + def;
                                }
                                pObj.put("schema", ApiService.getSchema(p.getType(), def));
                                params.put((Object)pObj);
                            }
                            if (params.length() > 0) {
                                obj.put("parameters", params);
                            }
                            JSONOrderedObject responses = new JSONOrderedObject();
                            Responses resps = m.getAnnotation(Responses.class);
                            for (Response r : resps.value()) {
                                JSONOrderedObject rObj = new JSONOrderedObject();
                                rObj.put("description", ApiService.getMessage(apiPlugin, r.description()));
                                JSONOrderedObject rContent = new JSONOrderedObject();
                                if (!r.definition().isEmpty()) {
                                    JSONOrderedObject rs = new JSONOrderedObject();
                                    String rdef = r.definition();
                                    if (rdef.contains("{")) {
                                        rdef = ApiBuilder.populateVariable(rdef, element.getJSONObject("properties"));
                                    }
                                    if (rdef.startsWith("{") && rdef.endsWith("}")) {
                                        rs = new JSONObject(rdef);
                                    } else {
                                        usedDef.add(rdef);
                                        if (r.array()) {
                                            rs.put("type", "array");
                                            rs.put("items", new JSONObject().put("$ref", (Object)("#/components/schemas/" + rdef)));
                                        } else {
                                            rs.put("$ref", "#/components/schemas/" + rdef);
                                        }
                                    }
                                    rContent.put("schema", (Object)rs);
                                }
                                rObj.put("content", new JSONOrderedObject().put(r.contentType(), (Object)rContent));
                                responses.put(Integer.toString(r.responseCode()), (Object)rObj);
                            }
                            obj.put("responses", (Object)responses);
                            obj.put("security", security);
                            if (op.deprecated()) {
                                obj.put("deprecated", true);
                            }
                            opObject.put(op.type().toString(), obj);
                        }
                        Map<String, ApiDefinition> defs = apiPlugin.getDefinitions();
                        if (defs != null && !defs.isEmpty()) {
                            for (String defKey : defs.keySet()) {
                                if (!usedDef.contains(defKey)) continue;
                                ApiDefinition apiDef = defs.get(defKey);
                                definitions.put(defKey, apiDef.getDefinition());
                            }
                        }
                        tags.put((Object)tagObj);
                    }
                }
                swagger.put("tags", tags);
                swagger.put("paths", paths);
                JSONOrderedObject components = new JSONOrderedObject();
                components.put("securitySchemes", (Object)securityDefinitions);
                LinkedHashMap<String, Class> apiResponseDef = new LinkedHashMap<String, Class>();
                apiResponseDef.put("code", Integer.class);
                apiResponseDef.put("message", String.class);
                apiResponseDef.put("date", Date.class);
                definitions.put("ApiResponse", new ApiDefinition(apiResponseDef).getDefinition());
                components.put("schemas", (Object)definitions);
                swagger.put("components", (Object)components);
                if (apiProps.has("externalDocUrl") && !apiProps.getString("externalDocUrl").isEmpty()) {
                    JSONOrderedObject extdoc = new JSONOrderedObject();
                    extdoc.put("url", apiProps.getString("externalDocUrl"));
                    if (apiProps.has("externalDocDesc") && !apiProps.getString("externalDocDesc").isEmpty()) {
                        extdoc.put("description", apiProps.getString("externalDocDesc"));
                    }
                    swagger.put("externalDocs", (Object)extdoc);
                }
                if (!config.containsKey("output") || !"yaml".equalsIgnoreCase(config.get("output").toString())) {
                    return swagger.toString();
                }
            }
            catch (Exception e) {
                LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)"");
            }
        }
        return null;
    }

    public static Collection<ApiPlugin> getAvailableElements() {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        ArrayList<ApiPlugin> list = new ArrayList<ApiPlugin>();
        Collection pluginList = pluginManager.list(ApiPlugin.class);
        for (Plugin plugin : pluginList) {
            if (!(plugin instanceof ApiPlugin)) continue;
            list.add((ApiPlugin)plugin);
        }
        return list;
    }

    public String getCreateNewPageHtml() {
        HashMap<String, UUID> model = new HashMap<String, UUID>();
        model.put("apiKey", UUID.randomUUID());
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        String content = pluginManager.getPluginFreeMarkerTemplate(model, ((Object)((Object)this)).getClass().getName(), "/templates/apiBuilderNew.ftl", null);
        return content;
    }

    public String createNewJSON(String id, String name, String description, BuilderDefinition copyDef) {
        String secret = UUID.randomUUID().toString().replaceAll("-", "");
        String json = "";
        if (copyDef != null) {
            String copyJson = copyDef.getJson();
            try {
                JSONObject obj = new JSONObject(copyJson);
                if (!obj.isNull("properties")) {
                    JSONObject objProperty = obj.getJSONObject("properties");
                    objProperty.put("id", (Object)id);
                    objProperty.put("name", (Object)name);
                    objProperty.put("description", (Object)description);
                }
                json = obj.toString();
            }
            catch (Exception exception) {}
        } else {
            json = AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/api/defaultDefinition.json", (Object[])new String[]{id, name, description, secret}, (boolean)true, null);
        }
        return json;
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Allow", "GET, POST, PUT, DELETE, HEAD, TRACE, OPTIONS");
        response.setHeader("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, HEAD, TRACE, OPTIONS");
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Credentials", "true");
        response.setHeader("Access-Control-Allow-Headers", "*");
    }

    @Transactional
    protected void serveApi(HttpServletRequest request, HttpServletResponse response, Date timestamp) {
        block41: {
            String pathInfo = request.getPathInfo();
            String path = pathInfo.substring(1);
            String method = request.getMethod();
            if (method.equals("OPTIONS")) {
                this.doOptions(request, response);
            } else if (path.startsWith("API-") && !path.contains("/")) {
                BuilderDefinition def = ApiBuilder.getJson(path);
                try {
                    if (def != null) {
                        request.setAttribute("api_id", (Object)path);
                        HashMap config = new HashMap();
                        response.setContentType("text/html; charset=utf-8");
                        HashMap<String, Object> model = new HashMap<String, Object>();
                        model.put("spec", this.getBuilderResult(def.getJson(), new HashMap<String, Object>()));
                        model.put("api_id", path);
                        String html = CustomBuilderUtil.generateHtml((CustomBuilder)this, (String)"templates/swagger-ui.ftl", model, (HttpServletRequest)request);
                        response.getWriter().write(html);
                        break block41;
                    }
                    response.sendError(404);
                }
                catch (Exception ex) {
                    LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)ex, (String)"");
                }
            } else {
                long startTime = System.currentTimeMillis();
                HostManager.initHost();
                ApiResponse res = null;
                String apiId = request.getHeader("api_id");
                String apiKey = request.getHeader("api_key");
                if (apiId == null || "".equals(apiId)) {
                    res = ApiBuilder.writeBadRequest(response);
                    res.write(response);
                    return;
                }
                JSONObject api = ApiBuilder.getAPI(apiId, request);
                if (api == null) {
                    res = ApiBuilder.writeBadRequest(response);
                } else {
                    try {
                        JSONObject apiProps = api.getJSONObject("properties");
                        request.setAttribute("api_id", (Object)apiProps.getString("id"));
                    }
                    catch (Exception e) {
                        LogUtil.error((String)this.getClassName(), (Throwable)e, (String)path);
                    }
                    boolean auth = false;
                    try {
                        auth = ApiBuilder.authenticate(request, response, timestamp, api);
                    }
                    catch (Exception e) {
                        LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)path);
                    }
                    if (!auth) {
                        res = ApiBuilder.writeUnauthorized(response);
                    } else {
                        try {
                            res = ApiBuilder.runOperation(path, request.getMethod(), api, request, response);
                        }
                        catch (Exception e) {
                            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)path);
                            res = ApiBuilder.writeSystemError(response);
                        }
                    }
                }
                if (res != null) {
                    res.write(response);
                    if (!apiId.startsWith("API-") && apiId.contains("_API_BUILDER_PREVIEW_")) {
                        return;
                    }
                    if (api == null) {
                        return;
                    }
                    try {
                        JSONObject apiProps = api.getJSONObject("properties");
                        boolean enableInternal = false;
                        if (apiProps.has("enableInternal") && !apiProps.isNull("enableInternal")) {
                            enableInternal = "true".equalsIgnoreCase(apiProps.getString("enableInternal"));
                        }
                        String internalKey = "";
                        if (apiProps.has("internalKey") && !apiProps.isNull("internalKey")) {
                            internalKey = apiProps.getString("internalKey");
                        }
                        if (apiKey != null && enableInternal && apiKey.equals(internalKey)) {
                            return;
                        }
                    }
                    catch (Exception e) {
                        LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)"");
                    }
                    ApiCredentialDao credentialDao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
                    ApiCredential credential = credentialDao.get(apiKey);
                    if (credential.getLog() != null && credential.getLog().equalsIgnoreCase("true")) {
                        ApiLogDao dao = (ApiLogDao)ApiAppContext.getInstance().getAppContext().getBean("apiLogDao");
                        ApiLog log = new ApiLog();
                        log.setId(UUID.randomUUID().toString());
                        log.setApiId(apiId);
                        log.setApiKey(apiKey);
                        log.setMethod(path);
                        log.setSourceIp(AppUtil.getClientIp((HttpServletRequest)request));
                        log.setStatus(res.getStatus());
                        log.setMessage(res.getMessage());
                        log.setTimestamp(timestamp);
                        log.setUserAgent(request.getHeader("User-Agent"));
                        log.setExecTimeMs(System.currentTimeMillis() - startTime);
                        if (credential.getLogDetails() != null && credential.getLogDetails().equalsIgnoreCase("true")) {
                            JSONObject logDetails = new JSONObject();
                            try {
                                if (request.getQueryString() != null && !request.getQueryString().isEmpty()) {
                                    logDetails.put("queryString", (Object)request.getQueryString());
                                }
                                if (request.getHeaderNames() != null) {
                                    HashMap<String, String> headerMaps = new HashMap<String, String>();
                                    Enumeration headerNames = request.getHeaderNames();
                                    while (headerNames.hasMoreElements()) {
                                        String key = (String)headerNames.nextElement();
                                        String value = request.getHeader(key);
                                        headerMaps.put(key, value);
                                    }
                                    logDetails.put("headers", headerMaps);
                                }
                                if (res.getParameter() != null) {
                                    HashMap<String, Object> payloadMaps = new HashMap<String, Object>();
                                    Parameter[] parameters = res.getParameter();
                                    List<Object> parameterValues = res.getParameterValues();
                                    for (int i = 0; i < parameters.length; ++i) {
                                        Param pAnno = parameters[i].getAnnotation(Param.class);
                                        if (pAnno == null) continue;
                                        String name = pAnno.value();
                                        if (parameterValues.get(i) == null) continue;
                                        payloadMaps.put(name, parameterValues.get(i));
                                    }
                                    logDetails.put("payload", payloadMaps);
                                }
                                if (res.getContent() != null && !res.getContent().isEmpty()) {
                                    if (res.getContent().startsWith("[") && res.getContent().endsWith("]")) {
                                        JSONArray array = new JSONArray(res.getContent());
                                        logDetails.put("content", (Object)array);
                                    } else if (res.getContent().startsWith("{") && res.getContent().endsWith("}")) {
                                        JSONObject object = new JSONObject(res.getContent());
                                        logDetails.put("content", (Object)object);
                                    }
                                }
                            }
                            catch (Exception e) {
                                LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)apiKey);
                            }
                            try {
                                log.setLogDetails(logDetails.toString(4));
                            }
                            catch (JSONException e) {
                                LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)apiKey);
                            }
                        }
                        dao.save(log);
                    }
                }
            }
        }
    }

    public static ApiResponse writeBadRequest(HttpServletResponse response) {
        return new ApiResponse(400, AppPluginUtil.getMessage((String)"api.error.400", (String)ApiBuilder.class.getName(), (String)"messages/apiPlugin"));
    }

    public static ApiResponse writeUnauthorized(HttpServletResponse response) {
        return new ApiResponse(401, AppPluginUtil.getMessage((String)"api.error.401", (String)ApiBuilder.class.getName(), (String)"messages/apiPlugin"));
    }

    public static ApiResponse writeSystemError(HttpServletResponse response) {
        return new ApiResponse(500, AppPluginUtil.getMessage((String)"api.error.500", (String)ApiBuilder.class.getName(), (String)"messages/apiPlugin"));
    }

    public static boolean authenticate(HttpServletRequest request, HttpServletResponse response, Date timestamp, JSONObject api) throws JSONException {
        String apiId = request.getHeader("api_id");
        if (!apiId.startsWith("API-") && apiId.contains("_API_BUILDER_PREVIEW_")) {
            return true;
        }
        String apiKey = request.getHeader("api_key");
        JSONObject apiProps = api.getJSONObject("properties");
        boolean enableInternal = false;
        if (apiProps.has("enableInternal") && !apiProps.isNull("enableInternal")) {
            enableInternal = "true".equalsIgnoreCase(apiProps.getString("enableInternal"));
        }
        String internalKey = "";
        if (apiProps.has("internalKey") && !apiProps.isNull("internalKey")) {
            internalKey = apiProps.getString("internalKey");
        }
        if (!(apiKey == null || enableInternal && apiKey.equals(internalKey))) {
            ApiCredentialDao dao = (ApiCredentialDao)ApiAppContext.getInstance().getAppContext().getBean("apiCredentialDao");
            ApiCredential credential = dao.get(apiKey);
            if (credential == null) {
                return false;
            }
            boolean auth = false;
            try {
                if (credential.getCustomAuthMethod() == null || "".equalsIgnoreCase(credential.getCustomAuthMethod()) || "add".equalsIgnoreCase(credential.getCustomAuthMethod())) {
                    if ("token".equalsIgnoreCase(credential.getType())) {
                        String tokenPattern = credential.getSetting();
                        String token = request.getHeader("token");
                        String method = "";
                        if (tokenPattern.contains("(")) {
                            method = tokenPattern.substring(0, tokenPattern.indexOf("("));
                            tokenPattern = tokenPattern.substring(tokenPattern.indexOf("(") + 1, tokenPattern.length() - 1);
                        }
                        if ((tokenPattern = tokenPattern.replaceAll(StringUtil.escapeRegex((String)"{api_key}"), StringUtil.escapeRegex((String)apiKey))).indexOf("{api_secret}") != -1) {
                            String secret = SecurityUtil.decrypt((String)credential.getApiSecret());
                            tokenPattern = tokenPattern.replaceAll(StringUtil.escapeRegex((String)"{api_secret}"), StringUtil.escapeRegex((String)secret));
                        }
                        if (tokenPattern.contains("{")) {
                            String temp = ApiBuilder.populateTime(tokenPattern, timestamp);
                            if (ApiBuilder.validate(method, temp, token)) {
                                auth = true;
                            } else {
                                Calendar cal = Calendar.getInstance();
                                cal.setTime(timestamp);
                                cal.add(12, -1);
                                temp = ApiBuilder.populateTime(tokenPattern, cal.getTime());
                                auth = ApiBuilder.validate(method, temp, token);
                            }
                        } else {
                            auth = ApiBuilder.validate(method, tokenPattern, token);
                        }
                    } else if ("basic".equalsIgnoreCase(credential.getType())) {
                        String header = request.getHeader("Authorization");
                        if (header == null || !header.startsWith("Basic ")) {
                            return false;
                        }
                        String[] tokens = ApiBuilder.extractAndDecodeHeader(header);
                        if (tokens.length != 2) {
                            return false;
                        }
                        WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
                        try {
                            UsernamePasswordAuthenticationToken arequest = new UsernamePasswordAuthenticationToken((Object)tokens[0], (Object)tokens[1]);
                            AuthenticationManager authenticationManager = (AuthenticationManager)AppUtil.getApplicationContext().getBean("authenticationManager");
                            Authentication result = authenticationManager.authenticate((Authentication)arequest);
                            SecurityContextHolder.getContext().setAuthentication(result);
                            HttpSession session = request.getSession(false);
                            if (session != null) {
                                SavedRequest savedRequest = new HttpSessionRequestCache().getRequest(request, response);
                                session.invalidate();
                                session = request.getSession(true);
                                if (savedRequest != null) {
                                    new HttpSessionRequestCache().saveRequest(request, response);
                                }
                            }
                            if (auth = result.isAuthenticated()) {
                                wum.clearCurrentThreadUser();
                            }
                            String ip = AppUtil.getClientIp((HttpServletRequest)request);
                            LogUtil.info((String)ApiBuilder.class.getName(), (String)("Authentication for user " + tokens[0] + " (" + ip + ") : " + auth));
                            WorkflowHelper workflowHelper = (WorkflowHelper)AppUtil.getApplicationContext().getBean("workflowHelper");
                            workflowHelper.addAuditTrail(ApiBuilder.class.getName(), "authenticate", "Authentication for user " + tokens[0] + " (" + ip + ") : " + auth);
                        }
                        catch (Exception ex) {
                            String ip = AppUtil.getClientIp((HttpServletRequest)request);
                            LogUtil.info((String)ApiBuilder.class.getName(), (String)("Authentication for user " + tokens[0] + " (" + ip + ") : " + auth));
                            WorkflowHelper workflowHelper = (WorkflowHelper)AppUtil.getApplicationContext().getBean("workflowHelper");
                            workflowHelper.addAuditTrail(ApiBuilder.class.getName(), "authenticate", "Authentication for user " + tokens[0] + " (" + ip + ") : " + auth);
                            return false;
                        }
                        if (!auth) {
                            return false;
                        }
                        String props = credential.getSetting();
                        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                        String permissionClassName = SecurityUtil.decrypt((String)credential.getApiSecret());
                        Permission permission = null;
                        if (permissionClassName != null && !permissionClassName.isEmpty()) {
                            permission = (Permission)pluginManager.getPlugin(permissionClassName);
                        }
                        if (permission != null) {
                            if (props != null) {
                                permission.setProperties(PropertyUtil.getPropertiesValueFromJson((String)props));
                            }
                            permission.setRequestParameters(request.getParameterMap());
                            permission.setCurrentUser(wum.getCurrentUser());
                            auth = permission.isAuthorize();
                        }
                    } else if ("simple".equalsIgnoreCase(credential.getType())) {
                        auth = true;
                    }
                }
                if (auth && "add".equalsIgnoreCase(credential.getCustomAuthMethod()) || "replace".equalsIgnoreCase(credential.getCustomAuthMethod())) {
                    String propsCustom = credential.getSettingCustom();
                    PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                    String customClassName = credential.getApiCustom();
                    ApiAuthenticatorAbstract customPlugin = null;
                    if (customClassName != null && !customClassName.isEmpty()) {
                        customPlugin = (ApiAuthenticatorAbstract)pluginManager.getPlugin(customClassName);
                    }
                    if (customPlugin != null) {
                        if (propsCustom != null) {
                            customPlugin.setProperties(PropertyUtil.getPropertiesValueFromJson((String)propsCustom));
                        }
                        auth = customPlugin.authenticate(request, response);
                    }
                }
                if (auth) {
                    String domainWhitelist = credential.getDomainWhitelist();
                    String ipWhitelist = credential.getIpWhitelist();
                    if (!"*".equals(domainWhitelist) && !"*".equals(ipWhitelist)) {
                        String domain = SecurityUtil.getDomainName((String)request.getHeader("referer"));
                        String ip = AppUtil.getClientIp((HttpServletRequest)request);
                        ArrayList<String> dWhitelist = new ArrayList<String>();
                        dWhitelist.add(request.getServerName());
                        if (domainWhitelist != null) {
                            dWhitelist.addAll(Arrays.asList(domainWhitelist.split("\\r?\\n")));
                        }
                        ArrayList<String> iWhitelist = new ArrayList<String>();
                        if (ipWhitelist != null) {
                            iWhitelist.addAll(Arrays.asList(ipWhitelist.split("\\r?\\n")));
                        }
                        if (!SecurityUtil.isAllowedDomain((String)domain, dWhitelist) && !SecurityUtil.isAllowedDomain((String)ip, iWhitelist)) {
                            LogUtil.info((String)ApiBuilder.class.getName(), (String)("Possible CSRF attack from url(" + request.getRequestURI() + ") referer(" + request.getHeader("referer") + ") IP(" + ip + ")"));
                            auth = false;
                        }
                    }
                    if ("*".equals(domainWhitelist) || auth && request.getHeader("Origin") != null) {
                        String origin = request.getHeader("Origin");
                        if (origin != null) {
                            origin = origin.replace("\n", "").replace("\r", "");
                        } else if ("*".equals(domainWhitelist)) {
                            origin = "*";
                        }
                        response.setHeader("Access-Control-Allow-Origin", origin);
                        response.setHeader("Access-Control-Allow-Credentials", "true");
                        response.setHeader("Access-Control-Allow-Headers", "*");
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)apiKey);
            }
            return auth;
        }
        if (apiKey != null && enableInternal && apiKey.equals(internalKey)) {
            WorkflowUserManager wum = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
            String domain = SecurityUtil.getDomainName((String)request.getHeader("referer"));
            ArrayList<String> dWhitelist = new ArrayList<String>();
            dWhitelist.add(request.getServerName());
            if (!SecurityUtil.isAllowedDomain((String)domain, dWhitelist)) {
                LogUtil.info((String)ApiBuilder.class.getName(), (String)("Possible CSRF attack from url(" + request.getRequestURI() + ") referer(" + request.getHeader("referer") + ")"));
                return false;
            }
            JSONObject permissionProps = apiProps.getJSONObject("internalPermission");
            if (permissionProps != null) {
                String permissionClassName = permissionProps.getString("className");
                PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                Permission permission = null;
                if (permissionClassName != null && !permissionClassName.isEmpty()) {
                    permission = (Permission)pluginManager.getPlugin(permissionClassName);
                }
                if (permission != null) {
                    if (permissionProps.has("properties")) {
                        permission.setProperties(PropertyUtil.getProperties((JSONObject)permissionProps.getJSONObject("properties")));
                    }
                    permission.setRequestParameters(request.getParameterMap());
                    permission.setCurrentUser(wum.getCurrentUser());
                    return permission.isAuthorize();
                }
            }
            return false;
        }
        return false;
    }

    public static BuilderDefinition getJson(String apiId) {
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
        String cacheKey = DynamicDataSourceManager.getCurrentProfile() + "_API_BUILDER_" + apiId;
        Cache cache = (Cache)AppUtil.getApplicationContext().getBean("fluCache");
        Element element = cache.get((Serializable)((Object)cacheKey));
        if (element == null) {
            Collection defs;
            if (builderDefinitionDao != null && !(defs = builderDefinitionDao.find("and id=?", new Object[]{apiId}, null, null, null, null, null)).isEmpty()) {
                Iterator defsIterator = defs.iterator();
                BuilderDefinition def = null;
                Long publishedAppVersion = appService.getPublishedVersion(((BuilderDefinition)defs.iterator().next()).getAppId());
                while (!(def = (BuilderDefinition)defsIterator.next()).getAppVersion().equals(publishedAppVersion)) {
                }
                element = new Element((Serializable)((Object)cacheKey), (Serializable)def);
                cache.put(element);
                return def;
            }
            return null;
        }
        BuilderDefinition builderDefinition = (BuilderDefinition)element.getValue();
        AppDefinition appDef = appService.getPublishedAppDefinition(builderDefinition.getAppDefinition().getAppId());
        if (element.getCreationTime() < appDef.getDateModified().getTime()) {
            builderDefinition = builderDefinitionDao.loadById(builderDefinition.getId(), appDef);
            element = new Element((Serializable)((Object)cacheKey), (Serializable)builderDefinition);
            cache.put(element);
        }
        return builderDefinition;
    }

    public static JSONObject getAPI(String apiId, HttpServletRequest request) {
        JSONObject api = null;
        try {
            BuilderDefinition apiDef = ApiBuilder.getJson(apiId);
            if (apiDef == null) {
                String refer;
                String json = ApiBuilder.getPreviewCache(apiId);
                if (json != null && !json.isEmpty() && (refer = request.getHeader("referer")) != null && refer.matches("^.+/app/[^/]+/[0-9]+/cbuilder/api/preview/.+$")) {
                    String[] appIdAndVersion = refer.substring(refer.indexOf("/app/") + 5, refer.indexOf("/cbuilder/api/preview/")).split("/");
                    AppService appService = (AppService)AppUtil.getApplicationContext().getBean("appService");
                    AppDefinition appDef = appService.getAppDefinition(appIdAndVersion[0], appIdAndVersion[1]);
                    api = new JSONObject(json = AppUtil.processHashVariable((String)json, null, (String)"json", null));
                    if (api.has("properties") && refer.endsWith(api.getJSONObject("properties").getString("id"))) {
                        return api;
                    }
                }
                return null;
            }
            AppUtil.setCurrentAppDefinition((AppDefinition)apiDef.getAppDefinition());
            String json = apiDef.getJson();
            json = AppUtil.processHashVariable((String)json, null, (String)"json", null);
            api = new JSONObject(json);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)apiId);
        }
        return api;
    }

    public static ApiResponse runOperation(String path, String method, JSONObject api, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONArray elements;
            Object plugin = null;
            Method operation = null;
            Map<String, String> pathParams = null;
            if (api.has("elements") && (elements = api.getJSONArray("elements")).length() > 0) {
                PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                JSONObject element = null;
                JSONObject properties = null;
                ApiPlugin apiPlugin = null;
                String className = null;
                String tag = null;
                String key = null;
                String value = null;
                boolean propertyNotFound = false;
                for (int i = 0; i < elements.length(); ++i) {
                    element = elements.getJSONObject(i);
                    if (!element.has("className") || (className = element.getString("className")) == null || className.isEmpty() || (apiPlugin = (ApiPlugin)pluginManager.getPlugin(className)) == null) continue;
                    tag = apiPlugin.getTag();
                    if (tag.contains("{") && tag.contains("}")) {
                        if (!element.has("properties")) continue;
                        propertyNotFound = false;
                        properties = element.getJSONObject("properties");
                        Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9_]+)\\}");
                        Matcher matcher = pattern.matcher(tag);
                        while (matcher.find()) {
                            key = matcher.group(1);
                            if (!properties.has(key)) {
                                propertyNotFound = true;
                                break;
                            }
                            value = properties.get(key).toString();
                            tag = tag.replaceAll(StringUtil.escapeRegex((String)matcher.group(0)), value);
                        }
                        if (propertyNotFound) continue;
                    }
                    if (!path.startsWith(tag + "/") && !path.equals(tag)) continue;
                    apiPlugin.setProperties(PropertyUtil.getProperties((JSONObject)element.getJSONObject("properties")));
                    plugin = apiPlugin;
                    path = path.replaceFirst(StringUtil.escapeRegex((String)tag), StringUtil.escapeRegex((String)""));
                    break;
                }
            }
            if (plugin != null) {
                Class<?> clazz = plugin.getClass();
                String oPath = null;
                int score = Integer.MAX_VALUE;
                for (Method m : plugin.getOperationMethods().values()) {
                    int temp;
                    Operation op;
                    if (!m.isAnnotationPresent(Operation.class) || !plugin.isAPIEnabled((op = m.getAnnotation(Operation.class)).type().toString(), op.path()).booleanValue()) continue;
                    int operationScore = Integer.MAX_VALUE;
                    if (method.equalsIgnoreCase(op.type().toString())) {
                        operationScore = 1000;
                    } else if (!method.equalsIgnoreCase(op.type().toString()) && op.type().toString().equalsIgnoreCase("get") && method.equalsIgnoreCase("post")) {
                        operationScore = 1001;
                    }
                    if (operationScore >= score) continue;
                    oPath = op.path();
                    if (oPath.contains("{") && oPath.contains("}")) {
                        oPath = oPath.replaceAll("\\{([a-zA-Z0-9_]+)\\}", StringUtil.escapeRegex((String)"([^/]+)"));
                    }
                    if (path.isEmpty() && "/".equals(oPath) || path.isEmpty() && oPath.isEmpty() || path.equals(oPath)) {
                        pathParams = ApiBuilder.getPathParams(path, op.path(), oPath);
                        operation = m;
                        if (operationScore == 1000) break;
                        score = operationScore;
                        continue;
                    }
                    if (!path.matches("(?i:^" + oPath + "$)") || (temp = StringUtils.countMatches((CharSequence)oPath, (CharSequence)"([^/]+)") + operationScore) >= score) continue;
                    pathParams = ApiBuilder.getPathParams(path, op.path(), oPath);
                    operation = m;
                    score = temp;
                }
            }
            if (operation != null) {
                return ApiBuilder.runOperation((ApiPlugin)plugin, operation, pathParams, request, response);
            }
            return ApiBuilder.writeBadRequest(response);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)path);
            return ApiBuilder.writeSystemError(response);
        }
    }

    protected static ApiResponse runOperation(ApiPlugin plugin, Method operation, Map<String, String> pathParam, HttpServletRequest request, HttpServletResponse response) {
        Operation op = operation.getAnnotation(Operation.class);
        Parameter[] parameters = operation.getParameters();
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        try {
            for (Parameter parameter : parameters) {
                Param pAnno = parameter.getAnnotation(Param.class);
                Class<Object> clazz = parameter.getType();
                if (pAnno != null) {
                    String name = pAnno.value();
                    if ("body".equalsIgnoreCase(name)) {
                        Gson gson;
                        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request) && "multipart/form-data".equals(op.bodyContentType())) {
                            HashMap<String, String[]> requestParameters = new HashMap<String, String[]>();
                            HashMap<String, MultipartFile[]> fileMap = new HashMap<String, MultipartFile[]>();
                            Map parameterMap = request.getParameterMap();
                            Iterator iterator = parameterMap.keySet().iterator();
                            while (iterator.hasNext()) {
                                String key;
                                String fieldName = key = (String)iterator.next();
                                String[] fieldValue = (String[])parameterMap.get(key);
                                String[] values = (String[])requestParameters.get(key);
                                if (values == null) {
                                    requestParameters.put(fieldName, new String[]{fieldValue[0]});
                                    continue;
                                }
                                int length = values.length;
                                String[] newValues = new String[length + 1];
                                System.arraycopy(values, 0, newValues, 0, length);
                                newValues[length] = fieldValue[0];
                                requestParameters.put(fieldName, newValues);
                            }
                            MultipartHttpServletRequest req = (MultipartHttpServletRequest)request;
                            MultiValueMap multiValueFileMap = req.getMultiFileMap();
                            for (String fieldName : multiValueFileMap.keySet()) {
                                fileMap.put(fieldName, ((List)multiValueFileMap.get((Object)fieldName)).toArray(new MultipartFile[0]));
                            }
                            FileStore.setFileMap(fileMap);
                            parameterValues.add(requestParameters);
                            continue;
                        }
                        if (BufferedReader.class.isAssignableFrom(clazz)) {
                            parameterValues.add(request.getReader());
                            continue;
                        }
                        String body = IOUtils.toString((Reader)request.getReader());
                        if (JSONObject.class.isAssignableFrom(clazz)) {
                            JSONObject jobj = null;
                            if (!body.isEmpty()) {
                                try {
                                    jobj = new JSONObject(body);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Not supported format for body");
                                }
                            }
                            if (jobj == null) {
                                jobj = new JSONObject();
                            }
                            parameterValues.add(jobj);
                            continue;
                        }
                        if (JSONArray.class.isAssignableFrom(clazz)) {
                            JSONArray arr = null;
                            if (!body.isEmpty()) {
                                try {
                                    arr = new JSONArray(body);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException("Not supported format for body");
                                }
                            }
                            if (arr == null) {
                                arr = new JSONArray();
                            }
                            parameterValues.add(arr);
                            continue;
                        }
                        if (String.class.isAssignableFrom(clazz)) {
                            parameterValues.add(body);
                            continue;
                        }
                        if (clazz.isAssignableFrom(byte[].class)) {
                            parameterValues.add(IOUtils.toByteArray((Reader)request.getReader()));
                            continue;
                        }
                        if (InputStream.class.isAssignableFrom(clazz)) {
                            parameterValues.add(request.getInputStream());
                            continue;
                        }
                        if (Map.class.isAssignableFrom(clazz)) {
                            gson = new Gson();
                            parameterValues.add(gson.fromJson(body, new TypeToken<Map<String, String>>(){}.getType()));
                            continue;
                        }
                        try {
                            gson = new Gson();
                            parameterValues.add(gson.fromJson(body, clazz));
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Not supported class (" + clazz.getName() + ") for body");
                        }
                    }
                    if (clazz.isAssignableFrom(byte[].class)) {
                        parameterValues.add(IOUtils.toByteArray((Reader)request.getReader()));
                        continue;
                    }
                    if (InputStream.class.isAssignableFrom(clazz)) {
                        parameterValues.add(request.getInputStream());
                        continue;
                    }
                    if (Map.class.isAssignableFrom(clazz)) {
                        HashMap<String, Object> temp = new HashMap<String, Object>();
                        if (clazz.isAssignableFrom(temp.getClass())) {
                            Enumeration e = request.getParameterNames();
                            while (e.hasMoreElements()) {
                                String paramName = (String)e.nextElement();
                                Object[] values = request.getParameterValues(paramName = StringEscapeUtils.escapeHtml4((String)paramName));
                                if (values.length > 1) {
                                    temp.put(paramName, StringUtils.join((Object[])values, (String)";"));
                                    continue;
                                }
                                if (values.length != 1) continue;
                                temp.put(paramName, values[0]);
                            }
                            parameterValues.add(temp);
                            continue;
                        }
                        parameterValues.add(request.getParameterMap());
                        continue;
                    }
                    String[] values = null;
                    values = pAnno.header() ? new String[]{request.getHeader(name)} : (pathParam.containsKey(name) ? new String[]{pathParam.get(name)} : request.getParameterValues(name));
                    if (values == null && pAnno.required()) {
                        throw new RuntimeException("Parameter (" + name + ") is required");
                    }
                    parameterValues.add(ApiBuilder.castValue(clazz, values));
                    continue;
                }
                if (HttpServletRequest.class.isAssignableFrom(clazz)) {
                    parameterValues.add(request);
                    continue;
                }
                if (HttpServletResponse.class.isAssignableFrom(clazz)) {
                    parameterValues.add(response);
                    continue;
                }
                if (PrintWriter.class.isAssignableFrom(clazz)) {
                    parameterValues.add(response.getWriter());
                    continue;
                }
                throw new RuntimeException("Not supported parameter : " + pAnno.value());
            }
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)operation.getName());
            return ApiBuilder.writeBadRequest(response);
        }
        try {
            Method aopOperation = plugin.getClass().getDeclaredMethod(operation.getName(), operation.getParameterTypes());
            Object returnObj = aopOperation.invoke((Object)plugin, parameterValues.toArray(new Object[0]));
            if (returnObj != null && returnObj instanceof ApiResponse) {
                ApiResponse obj = (ApiResponse)returnObj;
                if (parameters != null) {
                    obj.setParameter(parameters);
                }
                obj.setParameterValues(parameterValues);
                return obj;
            }
            return new ApiResponse(200, "");
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)operation.getName());
            return ApiBuilder.writeSystemError(response);
        }
    }

    protected static Object castValue(Class clazz, String[] values) throws Exception {
        if (values != null) {
            if (clazz.isArray()) {
                Class<?> arrayType = clazz.getComponentType();
                ArrayList<Object> objects = new ArrayList<Object>();
                for (String s : values) {
                    objects.add(ApiBuilder.castValue(arrayType, new String[]{s}));
                }
                return objects.toArray(new Object[0]);
            }
            String temp = "";
            if (values.length <= 0) {
                return null;
            }
            temp = values[0];
            if (String.class.isAssignableFrom(clazz)) {
                return temp;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return Integer.parseInt(temp);
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return Float.valueOf(Float.parseFloat(temp));
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return Long.parseLong(temp);
            }
            if (Double.class.isAssignableFrom(clazz)) {
                return Double.parseDouble(temp);
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return Boolean.parseBoolean(temp);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                return sdf.parse(temp);
            }
            if (JSONObject.class.isAssignableFrom(clazz)) {
                return new JSONObject(temp);
            }
            if (JSONArray.class.isAssignableFrom(clazz)) {
                return new JSONArray(temp);
            }
            throw new RuntimeException("Unsupported cast class (" + clazz.getName() + ")");
        }
        return null;
    }

    protected static Map<String, String> getPathParams(String urlPath, String methodPath, String pathRegex) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (methodPath.contains("{") && methodPath.contains("}")) {
            Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9_]+)\\}");
            Matcher matcher = pattern.matcher(methodPath);
            ArrayList<String> paramNames = new ArrayList<String>();
            while (matcher.find()) {
                paramNames.add(matcher.group(1));
            }
            pattern = Pattern.compile("^" + pathRegex + "$");
            matcher = pattern.matcher(urlPath);
            while (matcher.find()) {
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    params.put((String)paramNames.get(i), matcher.group(i + 1));
                }
            }
        }
        return params;
    }

    protected static String getPreviewCache(String key) {
        Cache cache = (Cache)AppUtil.getApplicationContext().getBean("fluCache");
        Element element = cache.get((Serializable)((Object)key));
        if (element != null) {
            return (String)element.getObjectValue();
        }
        return null;
    }

    protected static String addToPreviewCache(String appId, String json) {
        if (WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN")) {
            Cache cache = (Cache)AppUtil.getApplicationContext().getBean("fluCache");
            String cacheKey = DynamicDataSourceManager.getCurrentProfile() + "_" + appId + "_API_BUILDER_PREVIEW_" + UUID.randomUUID().toString();
            Element element = new Element((Serializable)((Object)cacheKey), (Serializable)((Object)json));
            element.setTimeToLive(1800);
            cache.put(element);
            return cacheKey;
        }
        return "";
    }

    protected static boolean validate(String method, String password, String token) {
        try {
            MessageDigest md = MessageDigest.getInstance(method);
            if (md != null) {
                byte[] bytes = md.digest(password.getBytes("UTF-8"));
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < bytes.length; ++i) {
                    sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
                }
                password = sb.toString();
            }
            return token.equals(password);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)"");
            return false;
        }
    }

    protected static String populateVariable(String str, JSONObject properties) {
        try {
            Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9_]+)\\}");
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                String key = matcher.group(1);
                if (!properties.has(key)) continue;
                String value = properties.get(key).toString();
                str = str.replaceAll(StringUtil.escapeRegex((String)matcher.group(0)), value);
            }
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)str);
        }
        return str;
    }

    protected static String populateTime(String str, Date time) {
        try {
            Pattern pattern = Pattern.compile("\\{(.+)\\}");
            Matcher matcher = pattern.matcher(str);
            while (matcher.find()) {
                String key = matcher.group(1);
                SimpleDateFormat sdf = new SimpleDateFormat(key);
                str = str.replaceAll(StringUtil.escapeRegex((String)matcher.group(0)), StringUtil.escapeRegex((String)sdf.format(time)));
            }
        }
        catch (Exception e) {
            LogUtil.error((String)ApiBuilder.class.getName(), (Throwable)e, (String)str);
        }
        return str;
    }

    protected static String[] extractAndDecodeHeader(String header) throws IOException {
        byte[] decoded;
        byte[] base64Token = header.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.getDecoder().decode(base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, "UTF-8");
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }
}

