/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.service;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joget.api.annotations.Operation;
import org.joget.api.model.ApiPlugin;
import org.joget.api.model.JSONOrderedObject;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.PluginManager;
import org.json.JSONException;
import org.json.JSONObject;
import org.springmodules.validation.bean.conf.loader.annotation.handler.NotBlank;

public class ApiService {
    public static void mergeObject(Object obj, Object update) {
        Method[] methods;
        if (!obj.getClass().isAssignableFrom(update.getClass())) {
            return;
        }
        for (Method fromMethod : methods = obj.getClass().getMethods()) {
            if (!fromMethod.getDeclaringClass().equals(obj.getClass()) || !fromMethod.getName().startsWith("get")) continue;
            String fromName = fromMethod.getName();
            String toName = fromName.replace("get", "set");
            try {
                Method toMetod = obj.getClass().getMethod(toName, fromMethod.getReturnType());
                Object value = fromMethod.invoke(update, (Object[])null);
                if (value == null) continue;
                toMetod.invoke(obj, value);
            }
            catch (Exception e) {
                LogUtil.debug((String)ApiService.class.getName(), (String)e.getMessage());
            }
        }
    }

    public static Map<String, String> getOperationOptions(ApiPlugin plugin) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Class<?> clazz = plugin.getClass();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Operation.class)) continue;
            Operation op = m.getAnnotation(Operation.class);
            options.put(op.type().toString() + ":" + op.path(), ApiService.getMessage(plugin, op.summary()));
        }
        return ApiService.sortByValue(options);
    }

    public static Map<String, Method> getOperationMethods(ApiPlugin plugin) {
        LinkedHashMap<String, Method> methods = new LinkedHashMap<String, Method>();
        Class<?> clazz = plugin.getClass();
        for (Method m : clazz.getDeclaredMethods()) {
            if (!m.isAnnotationPresent(Operation.class)) continue;
            Operation op = m.getAnnotation(Operation.class);
            methods.put(op.type().toString() + ":" + op.path(), m);
        }
        return methods;
    }

    public static String getMessage(ApiPlugin plugin, String message) {
        if (message.startsWith("@@") && message.endsWith("@@")) {
            PluginManager pluginManager = PluginManager.getInstance();
            message = pluginManager.getMessage(message.substring(2, message.length() - 2), plugin.getClassName(), plugin.getResourceBundlePath());
        }
        return message;
    }

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o1).getValue()).compareTo(((Map.Entry)o2).getValue());
            }
        });
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static JSONObject getSchema(Class clazz, String def) {
        try {
            JSONOrderedObject pObj = new JSONOrderedObject();
            if (def != null && !def.isEmpty()) {
                pObj.put("$ref", def);
            } else {
                pObj = ApiService.getSchema(clazz, null, false);
            }
            return pObj;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiService.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    public static JSONObject getSchema(Class clazz, String[] fields, boolean isExclude) {
        return ApiService.getSchema(clazz, fields, isExclude, null);
    }

    public static JSONObject getSchema(Class clazz, String[] fields, boolean isExclude, String description) {
        try {
            JSONOrderedObject jObj = new JSONOrderedObject();
            if (clazz.isArray()) {
                jObj.put("type", "array");
                jObj.put("items", ApiService.getSchema(clazz.getComponentType(), fields, isExclude));
            } else if (Map.class.isAssignableFrom(clazz)) {
                jObj.put("type", "object");
                jObj.put("additionalProperties", ApiService.getSchema(String.class, fields, isExclude));
            } else if (String.class.isAssignableFrom(clazz)) {
                jObj.put("type", "string");
            } else if (Integer.class.isAssignableFrom(clazz)) {
                jObj.put("type", "integer");
                jObj.put("format", "int32");
            } else if (Double.class.isAssignableFrom(clazz)) {
                jObj.put("type", "number");
                jObj.put("format", "double");
            } else if (Long.class.isAssignableFrom(clazz)) {
                jObj.put("type", "integer");
                jObj.put("format", "int64");
            } else if (Float.class.isAssignableFrom(clazz)) {
                jObj.put("type", "number");
                jObj.put("format", "float");
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                jObj.put("type", "boolean");
            } else if (Date.class.isAssignableFrom(clazz)) {
                jObj.put("type", "string");
                jObj.put("format", "date");
            } else if (Enum.class.isAssignableFrom(clazz)) {
                jObj.put("type", "string");
                T[] possibleValues = clazz.getEnumConstants();
                jObj.put("enum", possibleValues);
            } else if (File.class.isAssignableFrom(clazz)) {
                jObj.put("type", "string");
                jObj.put("format", "binary");
            } else {
                jObj.put("type", "object");
                JSONOrderedObject properties = new JSONOrderedObject();
                HashSet<String> required = new HashSet<String>();
                ApiService.populateFields(clazz, properties, required, fields, isExclude);
                if (!required.isEmpty()) {
                    jObj.put("required", required.toArray(new String[0]));
                }
                jObj.put("properties", (Object)properties);
                jObj.put("xml", new JSONOrderedObject().put("name", clazz.getSimpleName()));
            }
            if (description != null && !description.isEmpty()) {
                jObj.put("description", description);
            }
            return jObj;
        }
        catch (Exception e) {
            LogUtil.error((String)ApiService.class.getName(), (Throwable)e, (String)"");
            return null;
        }
    }

    private static void populateFields(Class clazz, JSONObject properties, Set<String> required, String[] fields, boolean isExclude) throws NoSuchMethodException, JSONException {
        List<Object> checkFields = new ArrayList();
        if (fields != null && fields.length > 0) {
            checkFields = Arrays.asList(fields);
        }
        if (clazz.getSuperclass() != null) {
            ApiService.populateFields(clazz.getSuperclass(), properties, required, fields, isExclude);
        }
        Field[] cFields = clazz.getDeclaredFields();
        for (int i = 0; i < cFields.length; ++i) {
            String fname = cFields[i].getName();
            boolean isExistField = false;
            if (checkFields.contains(clazz.getName())) {
                if (checkFields.contains(clazz.getName() + ":" + fname)) {
                    isExistField = true;
                }
            } else if (checkFields.contains(fname)) {
                isExistField = true;
            }
            if (isExclude && isExistField || !isExclude && !isExistField) continue;
            Class<?> fClazz = cFields[i].getType();
            try {
                Method m = clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)fname), new Class[0]);
                if (m == null && (m = clazz.getDeclaredMethod("is" + StringUtils.capitalize((String)fname), new Class[0])) == null) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            properties.put(fname, (Object)ApiService.getSchema(fClazz, fields, isExclude));
            if (!fClazz.isAnnotationPresent(NotBlank.class)) continue;
            required.add(fname);
        }
    }
}

