ApiBuilder = {
    
    initBuilder: function (callback) {
        $("#step-preview a .title").text(get_cbuilder_msg("apiBuilder.oas"));
        
        ApiBuilder.initPalette(function () {
            if (callback !== null && callback !== undefined) {
                callback();
                CustomBuilder.updatePasteIcons();
            }
        });
    },
    
    initPalette: function (callback) {
        $.ajax({
            url: CustomBuilder.contextPath + '/web/json/app/' + CustomBuilder.appId + '/' + CustomBuilder.appVersion + '/plugin/org.joget.api.service.ApiBuilder/service',
            dataType: "json",
            success: function (response) {
                if (response !== null && response !== "") {
                    for (var i in response) {
                        var p = response[i];
                        if (p.className !== "") {
                            var metaData = {
                                "tag" : p.tag,
                                "operations" : p.operations,
                                "isSimple" : p.isSimple
                            };
                            CustomBuilder.initPaletteElement("", p.className, p.label, p.icon, p.propertyOptions, p.defaultProperties, true, "", metaData);
                        }
                    }

                    //elements drag
                    $('.builder-palette-element').draggable({
                        connectToSortable: ".elements",
                        opacity: 0.7,
                        helper: "clone",
                        zIndex: 200,
                        revert: "invalid",
                        cursor: "move"
                    }).disableSelection();
                }

                if (callback !== null && callback !== undefined) {
                    callback();
                }
            }
        });
    },
    
    load: function (data) {
        $("#builder_canvas").html('<div class="api-container"><div class="element-options"></div><div class="elements"></div></div>');

        var container = $("#builder_canvas .api-container");
        $(container).find("> .element-options").append('<button class="element-paste element" title="'+get_cbuilder_msg("cbuilder.paste")+'"><i class="fas fa-paste"></i><span>'+get_cbuilder_msg("cbuilder.paste")+'</span></button>');

        $(container)[0].dom = data;
        
        $(container).find('> .element-options .element-paste').on("click", function(){
            ApiBuilder.paste(container);
        });
        
        if (data["elements"] === undefined) {
            data["elements"] = [];
        }
        
        $(container).find("> .elements").sortable({
            items: ".builder-element",
            opacity: 0.8,
            dropOnEmpty: true,
            activeClass: "element-highlight",
            handle: ".plugin-label",
            stop: function (event, ui) {
                var element = $(ui.item[0]);
                var container = $(element).closest(".api-container");
                var containerObj = $(container)[0].dom;
                
                if ($(element).hasClass("builder-palette-element")) {
                    ApiBuilder.addElement(container, element);
                } else {
                    var elementObj = $(element)[0].dom;
                    var oldIndex = $.inArray(elementObj, containerObj.elements);
                    containerObj.elements.splice(oldIndex, 1);

                    var newIndex = 0;
                    var prev = $(element).prev();
                    if ($(prev).length > 0) {
                        var prevObj = $(prev)[0].dom;
                        newIndex = $.inArray(prevObj, containerObj.elements) + 1;
                    }

                    containerObj.elements.splice(newIndex, 0, elementObj);
                    //update row sortable
                    CustomBuilder.update();
                }
            },
            tolerance: "pointer",
            revertDuration: 100,
            revert: "invalid"
        }).disableSelection();
        
        //render Elements
        if (data['elements'] !== undefined) {
            $.each(data['elements'], function (i, el) {
                ApiBuilder.renderElement(container, el);
            });
        }

        CustomBuilder.update(false);
    },
    
    addElement: function (container, tempElement) {
        var classname = $(tempElement).attr("element-class");
        var properties = {};
        if (CustomBuilder.paletteElements[classname].properties !== undefined) {
            properties = $.extend(true, properties, CustomBuilder.paletteElements[classname].properties);
        }
        var elementObj = {
            className: classname,
            properties: properties
        };
        properties["id"] = ApiBuilder.uuid();
        ApiBuilder.renderElement(container, elementObj, tempElement);
        CustomBuilder.update();
    },
    
    renderElement: function (container, elementObj, tempElement) {
        var containerObj = $(container)[0].dom;
        if (elementObj === undefined
                || CustomBuilder.paletteElements[elementObj['className']] === undefined) {
            return;
        }
        if (tempElement !== undefined) {
            var index = 0;
            if ($(container).find("> .elements").length > 0) {
                index = $(container).find("> .elements > div").index($(tempElement));
            } else {
                index = $(container).find("> .container-elements > div").index($(tempElement));
            }
            containerObj.elements.splice(index, 0, elementObj);
        }
        var html = '<div class="builder-element"><div class="plugin-label"></div><div class="checker"><a class="checker_btn checkall"><i class="far fa-square"></i> '+get_cbuilder_msg("apiBuilder.checkAll")+'</a></div><div class="element-options"></div><div class="element-operations"></div></div>';
        var element = $(html);
        $(element)[0].dom = elementObj;

        $(element).find('.plugin-label').text(CustomBuilder.paletteElements[elementObj['className']].label);

        $(element).attr("id", elementObj["properties"]["id"]);
        
        if (CustomBuilder.paletteElements[elementObj['className']].isSimple) {
            ApiBuilder.populateSimpleConfig(element);
        } else {
            if (CustomBuilder.paletteElements[elementObj['className']].propertyOptions !== undefined 
                    && !(typeof CustomBuilder.paletteElements[elementObj['className']].propertyOptions === "null")) {
                $(element).find('> .element-options').append('<button class="element-edit" title="' + get_cbuilder_msg("apiBuilder.edit") + '"><i class="far fa-edit"></i><span>' + get_cbuilder_msg("apiBuilder.edit") + '</span></button>');
            }
        }
        $(element).find('> .element-options').append('<button class="element-copy element" title="' + get_cbuilder_msg("apiBuilder.copy") + '"><i class="far fa-copy"></i><span>' + get_cbuilder_msg("apiBuilder.copy") + '</span></button>');
        $(element).find('> .element-options').append('<button class="element-delete" title="' + get_cbuilder_msg('apiBuilder.delete') + '"><i class="fas fa-times"></i><span>' + get_cbuilder_msg('apiBuilder.delete') + '</span></button>');

        $(element).find('> .element-options .element-edit').on("click", function () {
            ApiBuilder.showProperties(element);
        });

        $(element).find('> .element-options .element-copy').on("click", function () {
            CustomBuilder.copy(elementObj, "element");
        });

        $(element).find('> .element-options .element-delete').on("click", function () {
            ApiBuilder.deleteElement(element);
        });
        
        $(element).find('> .checker .checker_btn').on("click", function () {
            if ($(this).hasClass("checkall")) {
                var values = [];
                $(element).find("> .element-operations .operation").each(function(){
                    $(this).find("i").removeClass("fa-square").addClass("fa-check-square");
                    var value = $(this).data("value");
                    values.push(value);
                });
                elementObj["properties"]["ENABLED_PATHS"] = values.join(";");
                
                $(this).removeClass("checkall");
                $(this).addClass("uncheckall");
                $(this).html('<i class="far fa-check-square"></i> ' + get_cbuilder_msg("apiBuilder.uncheckAll"));
            } else {
                $(element).find("> .element-operations .operation").each(function(){
                    $(this).find("i").removeClass("fa-check-square").addClass("fa-square");
                });
                elementObj["properties"]["ENABLED_PATHS"] = "";
                
                $(this).removeClass("uncheckall");
                $(this).addClass("checkall");
                $(this).html('<i class="far fa-square"></i> ' + get_cbuilder_msg("apiBuilder.checkAll"));
            }
            CustomBuilder.update();
        });
        
        ApiBuilder.populateOperations(element, CustomBuilder.paletteElements[elementObj['className']].operations);

        if (tempElement !== undefined) {
            $(tempElement).replaceWith(element);
        } else {
            $(container).find("> .elements").append(element);
        }
        
        ApiBuilder.reloadElement(element);
    },
    
    populateOperations : function(element, operations) {
        var elementObj = $(element)[0].dom;
        var container = $(element).find("> .element-operations");
        
        if (operations !== null && operations !== undefined) {
            for (var i in operations) {
                $(container).append('<label class="operation" data-value="'+operations[i].value+'"><i class="far fa-square"></i> '+operations[i].label+'</label>');
            }
        }
        
        var enabled = elementObj["properties"]["ENABLED_PATHS"];
        if (enabled !== undefined) {
            var values = enabled.split(";");
            for (var i in values) {
                $(container).find(".operation[data-value='"+values[i]+"'] i").removeClass("fa-square").addClass("fa-check-square");
            }
            if (values.length > (operations.length / 2)) {
                $(element).find('> .checker .checker_btn').removeClass("checkall");
                $(element).find('> .checker .checker_btn').addClass("uncheckall");
                $(element).find('> .checker .checker_btn').html('<i class="far fa-check-square"></i> ' + get_cbuilder_msg("apiBuilder.uncheckAll"));
            }
        }
        
        $(container).find(".operation").on("click", function() {
            var op = $(this);
            var value = $(op).data("value");
            var enabled = elementObj["properties"]["ENABLED_PATHS"];
            var values = [];
            if (enabled !== undefined) {
                values = enabled.split(";");
            }
            
            if ($(op).find("i").hasClass("fa-check-square")) {
                //remove
                var index = values.indexOf(value);
                if (index > -1) {
                    values.splice(index, 1);
                }
                $(op).find("i").removeClass("fa-check-square").addClass("fa-square");
            } else {
                //add
                 values.push(value);
                 
                $(op).find("i").removeClass("fa-square").addClass("fa-check-square");
            }
            
            elementObj["properties"]["ENABLED_PATHS"] = values.join(";");
            
            if (values.length > (operations.length / 2)) {
                $(element).find('> .checker .checker_btn').removeClass("checkall");
                $(element).find('> .checker .checker_btn').addClass("uncheckall");
                $(element).find('> .checker .checker_btn').html('<i class="far fa-check-square"></i> ' + get_cbuilder_msg("apiBuilder.uncheckAll"));
            } else {
                $(element).find('> .checker .checker_btn').removeClass("uncheckall");
                $(element).find('> .checker .checker_btn').addClass("checkall");
                $(element).find('> .checker .checker_btn').html('<i class="far fa-square"></i> ' + get_cbuilder_msg("apiBuilder.checkAll"));
                
            }
            
            CustomBuilder.update();
        });
    },
    
    reloadElement: function (element) {
        var elementObj = $(element)[0].dom;
        var elementClass = elementObj.className;
        var elementProperty = elementObj.properties;
        
        var orgTag = $(element).attr("data-tag");
        if (orgTag !== null && orgTag !== undefined) {
            $("[data-tag='"+orgTag+"']").removeClass("duplicateError");
            $("[data-tag='"+orgTag+"']").find(".errorMsg").remove();
        }
        
        var tag = CustomBuilder.paletteElements[elementClass].tag;
        if (tag.indexOf("{") !== -1 && tag.indexOf("}")) {
            var res = tag.match(/{([a-zA-Z0-9_]+)}/g);
            for (var i in res) {
                var value = elementProperty[res[i].substring(1, res[i].length - 1)];
                if (value !== undefined && value !== null && value !== "") {
                    tag = tag.replace(res[i], value);
                }
            }
        }
        $(element).attr("data-tag", tag);
        
        //validate
        if (tag.indexOf("{") !== -1 && tag.indexOf("}")) {
            $("[data-tag='"+tag+"']").addClass("mandatoryError");
        } else if ($("[data-tag='"+tag+"']").length > 1) {
            $("[data-tag='"+tag+"']").addClass("duplicateError");
            $("[data-tag='"+tag+"']").find(".plugin-label").append('<span class="errorMsg">'+get_cbuilder_msg('apiBuilder.duplicateError')+'</span>');
        } else {
            $("[data-tag='"+tag+"']").removeClass("mandatoryError");
        }
    },
    
    deleteElement: function (element) {
        var container = $(element).closest(".api-container");
        var containerObj = $(container)[0].dom;

        var orgTag = $(element).attr("data-tag");
        
        var elementObj = $(element)[0].dom;
        var index = $.inArray(elementObj, containerObj.elements);
        if (index !== -1) {
            containerObj.elements.splice(index, 1);
        }
        $(element).remove();
        
        if (orgTag !== null && orgTag !== undefined) {
            if ($("[data-tag='"+orgTag+"']").length === 1) {
                $("[data-tag='"+orgTag+"']").removeClass("duplicateError");
                $("[data-tag='"+orgTag+"']").find(".errorMsg").remove();
            }
        }

        CustomBuilder.update();
    },
    
    populateSimpleConfig: function(element) {
        var dom = $(element)[0].dom;
        var elementClass = dom.className;
        var elementProperty = dom.properties;
        
        if (CustomBuilder.paletteElements[elementClass] === undefined
                || CustomBuilder.paletteElements[elementClass].propertyOptions === undefined
                || typeof CustomBuilder.paletteElements[elementClass].propertyOptions === "null") {
            return;
        }
        var elementOptions = CustomBuilder.paletteElements[elementClass].propertyOptions;

        // render properties
        var options = {
            appPath: "/" + CustomBuilder.appId + "/" + CustomBuilder.appVersion,
            contextPath: CustomBuilder.contextPath,
            propertiesDefinition : elementOptions,
            propertyValues : elementProperty,
            changeCheckIgnoreUndefined: true,
            saveCallback: function(container, properties) {
                elementProperty = $.extend(elementProperty, properties);
                CustomBuilder.callback(CustomBuilder.config.builder.callbacks["saveEditProperties"], [container, elementProperty]);
                CustomBuilder.update();
            }
        };
        $(element).find("> .element-operations").before('<div class="element-properties"></div>');
        
        PropertyEditor.SimpleMode.render($(element).find("> .element-properties"), options);
    },
    
    showProperties: function (element) {
        var dom = $(element)[0].dom;
        var elementClass = dom.className;
        var elementProperty = dom.properties;
        CustomBuilder.editProperties(elementClass, elementProperty);
    },
    
    saveEditProperties: function (container, properties) {
        var element = $("#" + properties["id"]);

        ApiBuilder.reloadElement($(element));
    },
    
    paste: function (container) {
        var copied = CustomBuilder.getCopiedElement();
        var copiedObj = copied['object'];
        ApiBuilder.updatePasteId(copiedObj);
        var temp = $('<div></div>');
        $(container).find("> .elements").append(temp);
        ApiBuilder.renderElement(container, copiedObj, temp);
        CustomBuilder.update();
    },

    updatePasteId: function (elementObj) {
        elementObj.properties["id"] = ApiBuilder.uuid();
    },
    
    uuid: function () {
        return 'xxxxxxxx-xxxx-4xxx-xxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {  //xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx
            var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        }).toUpperCase();
    },
    
    advanceToolTabs: function() {
        
    }
};
