<!-- HTML for static distribution bundle build -->
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Swagger UI</title>
        <link rel="stylesheet" type="text/css" href="${request.contextPath}/plugin/org.joget.api.service.ApiBuilder/swagger-ui/swagger-ui.css" >
        <link rel="shortcut icon" href="${request.contextPath}/images/favicon.ico"/>
        <style>
            html
            {
                box-sizing: border-box;
                overflow: -moz-scrollbars-vertical;
                overflow-y: scroll;
            }

            *,
            *:before,
            *:after
            {
                box-sizing: inherit;
            }

            body
            {
                margin:0;
                background: #fafafa;
            }
            .toolbar {
                padding: 20px;
                text-align: right;
            }
            .topbar {
                display:none;
            }
            a.download_yaml {
                background: #000;
                color: #fff;
                font-size: 24px;
                padding: 10px 25px;
                text-decoration: none;
                border-radius: 25px;
            }
        </style>
    </head>

    <body>
        <div class="toolbar">
            <a class="download_yaml" target="_blank" href="" download="openapi.yaml">@@apiBuilder.download@@</a>
        </div>
        <div id="swagger-ui"></div>
        <div style="display:none;"><textarea id="spec_json">${spec!}</textarea></div>
        <script src="${request.contextPath}/wro/common.js?build=@@build.number@@"> </script>
        <script src="${request.contextPath}/wro/common.preload.js?build=@@build.number@@"> </script>
        <script src="${request.contextPath}/plugin/org.joget.api.service.ApiBuilder/swagger-ui/swagger-ui-bundle.js"> </script>
        <script src="${request.contextPath}/plugin/org.joget.api.service.ApiBuilder/swagger-ui/swagger-ui-standalone-preset.js"> </script>
        <script src="${request.contextPath}/plugin/org.joget.api.service.ApiBuilder/json2yaml/json2yaml.js"> </script>
        <script>
            window.onload = function() {
                // Begin Swagger UI call region
                const ui = SwaggerUIBundle({
                    spec : ${spec!},
                    dom_id: '#swagger-ui',
                    deepLinking: true,
                    presets: [
                        SwaggerUIBundle.presets.apis,
                        SwaggerUIStandalonePreset
                    ],
                    plugins: [
                        SwaggerUIBundle.plugins.DownloadUrl
                    ],
                    layout: "StandaloneLayout",
                    onComplete: function() {
                        ui.preauthorizeApiKey("api_id", "${api_id!}");

                        <#if api_key?? >
                            ui.preauthorizeApiKey("api_key", "${api_key!}");
                            ui.preauthorizeApiKey("api_secret", "${api_secret!}");
                        </#if>
                    }
                })
                // End Swagger UI call region

                window.ui = ui
            }

            $(document).ready(function(){
                $(".download_yaml").on("click", function(){
                    if ($(this).attr("href") === "") {
                        var yaml = json2yaml($("#spec_json").text());
                        $(this).attr("href", 'data:text/plain;base64,' + b64EncodeUnicode(yaml));
                    }
                    return true;
                });
            });

            function b64EncodeUnicode(str) {
                return btoa(encodeURIComponent(str).replace(/%([0-9A-F]{2})/g, function(match, p1) {
                    return String.fromCharCode(parseInt(p1, 16))
                }))
            }
        </script>
    </body>
</html>
