/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.mcp;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joget.ai.agent.mcp.ToolSpecification;

public class McpSchemaCache {
    private static final Map<String, ToolSpecification> toolCache = new HashMap<String, ToolSpecification>();

    public static void cacheTools(List<ToolSpecification> tools) {
        for (ToolSpecification tool : tools) {
            toolCache.put(tool.getName(), tool);
        }
    }

    public static ToolSpecification getTool(String toolName) {
        return toolCache.get(toolName);
    }

    public static List<String> getEnumValues(String toolName, String paramName) {
        ToolSpecification spec = McpSchemaCache.getTool(toolName);
        if (spec == null) {
            return Collections.emptyList();
        }
        ToolSpecification.ParameterSpec param = spec.getParameters().get(paramName);
        if (param == null) {
            return Collections.emptyList();
        }
        return param.getEnumValues();
    }
}

