/*
 * Decompiled with CFR 0.152.
 */
package org.joget.ai.agent.model;

import org.joget.ai.agent.model.AgentLLM;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonSchemaBuilder {
    private String name;
    private String rootType = "object";
    private String description;
    private boolean strict = true;
    private boolean additionalProperties = false;
    private AgentLLM.Type targetProvider = AgentLLM.Type.DEFAULT;
    private JSONArray required = new JSONArray();
    private final JSONObject properties = new JSONObject();

    public JsonSchemaBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public JsonSchemaBuilder setRootType(String rootType) {
        this.rootType = rootType;
        return this;
    }

    public JsonSchemaBuilder setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public JsonSchemaBuilder setTargetProvider(AgentLLM.Type targetProvider) {
        this.targetProvider = targetProvider;
        return this;
    }

    public JsonSchemaBuilder setAdditionalProperties(boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonSchemaBuilder setRequired(JSONArray required) {
        this.required = required;
        return this;
    }

    public JsonSchemaBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonSchemaBuilder addProperty(String key, JSONObject definition, boolean isRequired) {
        this.getProperties().put(key, (Object)definition);
        if (isRequired && !this.hasInArray(this.required, key)) {
            this.required.put((Object)key);
        }
        return this;
    }

    private boolean hasInArray(JSONArray array, String value) {
        for (int i = 0; i < array.length(); ++i) {
            if (!value.equals(array.getString(i))) continue;
            return true;
        }
        return false;
    }

    public JsonSchemaBuilder addPropertiesFromSample(JSONObject sample, boolean allRequired) {
        for (String key : sample.keySet()) {
            Object value = sample.get(key);
            JSONObject propDef = new JSONObject();
            if (value instanceof Integer) {
                propDef.put("type", (Object)"integer");
            } else if (value instanceof Number) {
                propDef.put("type", (Object)"number");
            } else if (value instanceof Boolean) {
                propDef.put("type", (Object)"boolean");
            } else if (value instanceof JSONArray) {
                propDef.put("type", (Object)"array");
            } else if (value instanceof JSONObject) {
                propDef.put("type", (Object)"object");
            } else {
                propDef.put("type", (Object)"string");
            }
            this.addProperty(key, propDef, allRequired);
        }
        return this;
    }

    public JsonSchemaBuilder asArray(String arrayPropertyName, boolean required) {
        JSONObject itemSchema = this.buildPropertySchema();
        this.getProperties().clear();
        this.required = new JSONArray();
        this.rootType = "object";
        this.additionalProperties = false;
        JSONObject arrayDef = new JSONObject().put("type", (Object)"array").put("items", (Object)itemSchema);
        this.addProperty(arrayPropertyName, arrayDef, required);
        return this;
    }

    public JsonSchemaBuilder addArrayProperty(String propName, JsonSchemaBuilder itemSchema, boolean isRequired) {
        JSONObject arrayDef = new JSONObject().put("type", (Object)"array").put("items", (Object)itemSchema.buildPropertySchema());
        this.addProperty(propName, arrayDef, isRequired);
        return this;
    }

    public JSONObject build() {
        JSONObject schema = this.buildPropertySchema();
        JSONObject responseFormat = new JSONObject();
        if (AgentLLM.Type.OPENAI.equals((Object)this.targetProvider)) {
            JSONObject js = new JSONObject();
            js.put("name", (Object)(this.name != null ? this.name : "response"));
            js.put("schema", (Object)schema);
            js.put("strict", this.strict);
            responseFormat.put("type", (Object)"json_schema");
            responseFormat.put("json_schema", (Object)js);
        } else {
            String contentText = this.description != null ? this.description : "Generate a response based on the provided schema: " + schema.toString(2) + " Only respond with a valid JSON. No other text.";
            JSONArray messages = new JSONArray();
            JSONObject message = new JSONObject();
            message.put("role", (Object)"user");
            message.put("content", (Object)contentText);
            messages.put((Object)message);
            responseFormat.put("messages", (Object)messages);
        }
        return responseFormat;
    }

    public JSONObject buildPropertySchema() {
        JSONObject schema = new JSONObject();
        schema.put("type", (Object)this.rootType);
        if ("object".equals(this.rootType)) {
            schema.put("properties", (Object)this.getProperties());
            schema.put("required", (Object)this.required);
            schema.put("additionalProperties", this.additionalProperties);
        } else if ("array".equals(this.rootType)) {
            throw new UnsupportedOperationException("Root array schemas not allowed by OpenAI; wrap in object.");
        }
        return schema;
    }

    public JSONObject getProperties() {
        return this.properties;
    }

    public static JSONObject stringProperty() {
        return new JSONObject().put("type", (Object)"string");
    }

    public static JSONObject integerProperty() {
        return new JSONObject().put("type", (Object)"integer");
    }

    public static JSONObject numberProperty() {
        return new JSONObject().put("type", (Object)"number");
    }

    public static JSONObject booleanProperty() {
        return new JSONObject().put("type", (Object)"boolean");
    }
}

