/*
 * Decompiled with CFR 0.152.
 */
package org.joget.api.model;

import java.util.Map;
import org.joget.api.model.JSONOrderedObject;
import org.joget.api.service.ApiService;
import org.joget.commons.util.LogUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiDefinition {
    protected JSONObject jsonObj;

    public ApiDefinition(String json) {
        try {
            this.jsonObj = new JSONObject(json);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiDefinition.class.getName(), (Throwable)e, (String)"");
        }
    }

    public ApiDefinition(JSONObject json) {
        this.jsonObj = json;
    }

    public ApiDefinition(Object obj) {
        this(obj, null, true);
    }

    public ApiDefinition(Object obj, String[] fields) {
        this(obj, fields, false);
    }

    public ApiDefinition(Object obj, String[] fields, boolean isExclude) {
        this.jsonObj = ApiService.getSchema(obj.getClass(), fields, isExclude);
    }

    public ApiDefinition(Map<String, Class> fields) {
        try {
            this.jsonObj = new JSONOrderedObject();
            this.jsonObj.put("type", (Object)"object");
            JSONOrderedObject properties = new JSONOrderedObject();
            for (String id : fields.keySet()) {
                properties.put(id, ApiService.getSchema(fields.get(id), null, false));
            }
            this.jsonObj.put("properties", (Object)properties);
        }
        catch (Exception e) {
            LogUtil.error((String)ApiDefinition.class.getName(), (Throwable)e, (String)"");
        }
    }

    public JSONObject getDefinition() {
        return this.jsonObj;
    }

    public void removePropertyKey(String key) throws JSONException {
        this.jsonObj.getJSONObject("properties").remove(key);
    }

    public void removeNestedPropertyKey(String obj, String key) throws JSONException {
        this.jsonObj.getJSONObject("properties").getJSONObject(obj).getJSONObject("properties").remove(key);
    }
}

