/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.support.ICUBidiReorderer;
import com.openhtmltopdf.bidi.support.ICUBidiSplitter;
import com.openhtmltopdf.outputdevice.helper.BaseRendererBuilder;
import com.openhtmltopdf.pdfboxout.PdfRendererBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.CustomBuilder;
import org.joget.apps.app.model.CustomBuilderAbstract;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.apps.form.service.FormPdfUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;
import org.joget.directory.model.User;
import org.joget.plugin.base.HiddenPlugin;
import org.joget.plugin.base.Plugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.plugin.property.service.PropertyUtil;
import org.joget.rbuilder.api.ReportContainer;
import org.joget.rbuilder.api.ReportElement;
import org.joget.workflow.model.service.WorkflowUserManager;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.xhtmlrenderer.resource.FSEntityResolver;
import org.xhtmlrenderer.swing.Java2DRenderer;
import org.xml.sax.EntityResolver;

public class ReportBuilder
extends CustomBuilderAbstract
implements CustomBuilder,
PluginWebSupport {
    public static final String BUILDER_MESSAGE_PATH = "messages/ReportBuilder";
    public static final String MESSAGE_PATH = "messages/ReportElements";
    public static final String IS_PREVIEW = "IS_PREVIEW";
    public static final String REPORT_PARAMS = "REPORT_PARAMS";
    public static final String REPORT_OUTPUT = "REPORT_OUTPUT";
    public static final String REPORT_OUTPUT_HTML = "HTML";
    public static final String REPORT_OUTPUT_HTML_FULL = "HTML_WITH_HEADER_FOOTER";
    protected static ThreadLocal reportParameters = new ThreadLocal();

    public String getName() {
        return "reportBuilder";
    }

    public String getObjectName() {
        return "report";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)"reportBuilder.description", (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getIcon() {
        return "fas fa-file-contract";
    }

    public String getColor() {
        return "#dd2c00";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)"reportBuilder.label", (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getObjectLabel() {
        return AppPluginUtil.getMessage((String)"reportBuilder.report", (String)this.getClassName(), (String)this.getResourceBundlePath());
    }

    public String getIdPrefix() {
        return "rp_";
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/setting.json", null, (boolean)true, (String)this.getResourceBundlePath());
    }

    public String getBuilderConfig() {
        return AppUtil.readPluginResource((String)this.getClassName(), (String)"/properties/report_builder.json", null, (boolean)false, (String)this.getResourceBundlePath());
    }

    public String getResourceBundlePath() {
        return BUILDER_MESSAGE_PATH;
    }

    public String getBuilderJS(String contextPath, String buildNumber) {
        return "<script type=\"text/javascript\" src=\"" + contextPath + "/plugin/org.joget.rbuilder.ReportBuilder/reportbuilder.js?build=" + this.getVersion() + buildNumber + "\"></script>";
    }

    public String getBuilderCSS(String contextPath, String buildNumber) {
        String css = "<link href=\"" + contextPath + "/plugin/org.joget.rbuilder.ReportBuilder/reportbuilder.css?build=" + this.getVersion() + buildNumber + "\" rel=\"stylesheet\" type=\"text/css\" />";
        return css;
    }

    public String getBuilderHTML(BuilderDefinition def, String json, HttpServletRequest request, HttpServletResponse response) {
        return "";
    }

    public void builderPreview(String json, HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(IS_PREVIEW, true);
        HashMap<String, String> rparams = new HashMap<String, String>();
        try {
            JSONArray reportParams;
            JSONObject obj = new JSONObject(json);
            JSONObject prop = obj.getJSONObject("properties");
            if (prop.has("reportParams") && (reportParams = prop.getJSONArray("reportParams")) != null && reportParams.length() > 0) {
                for (int n = 0; n < reportParams.length(); ++n) {
                    JSONObject object = reportParams.getJSONObject(n);
                    rparams.put(object.get("param").toString(), object.get("value").toString());
                }
            }
        }
        catch (JSONException ex) {
            LogUtil.error((String)this.getClassName(), (Throwable)ex, null);
        }
        if ("pdf".equalsIgnoreCase(request.getParameter("outputtype"))) {
            config.put(REPORT_PARAMS, rparams);
            byte[] pdf = (byte[])this.getBuilderResult(json, config);
            try {
                response.setHeader("Content-Type", "application/pdf");
                response.setHeader("Content-Disposition", "inline; filename=preview.pdf; filename*=UTF-8''preview.pdf");
                response.getOutputStream().write(pdf);
            }
            catch (IOException ex) {
                LogUtil.error((String)this.getClassName(), (Throwable)ex, null);
            }
        } else {
            config.put(REPORT_PARAMS, rparams);
            config.put(REPORT_OUTPUT, REPORT_OUTPUT_HTML_FULL);
            String html = (String)this.getBuilderResult(json, config);
            try {
                response.setContentType("text/html; charset=utf-8");
                response.getWriter().write(html);
            }
            catch (IOException ex) {
                LogUtil.error((String)this.getClassName(), (Throwable)ex, null);
            }
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        String action = request.getParameter("_action");
        if ("previewElement".equals(action)) {
            BuilderDefinitionDao dao;
            BuilderDefinition def;
            String json = request.getParameter("_json");
            String id = request.getParameter("_id");
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            String tempJson = json;
            if ((tempJson.contains("%%%%") || tempJson.contains("****SECURE_VALUE****-")) && (def = (dao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao")).loadById(id, appDef)) != null) {
                tempJson = PropertyUtil.propertiesJsonStoreProcessing((String)def.getJson(), (String)tempJson);
            }
            tempJson = AppUtil.processHashVariable((String)json, null, (String)"json", null);
            String html = "";
            try {
                PluginManager pluginManager;
                Plugin plugin;
                JSONObject obj = new JSONObject(tempJson);
                if (obj.has("className") && (plugin = (pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager")).getPlugin(obj.getString("className"))) != null && plugin instanceof ReportElement && plugin instanceof PropertyEditable) {
                    ((PropertyEditable)plugin).setProperties(PropertyUtil.getPropertiesValueFromJson((String)obj.getJSONObject("properties").toString()));
                    ((PropertyEditable)plugin).setProperty(IS_PREVIEW, (Object)true);
                    html = ((ReportElement)plugin).preview();
                }
            }
            catch (Exception ex) {
                LogUtil.error((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex, (String)"preview element error!");
            }
            response.getWriter().write(html);
        } else {
            try {
                JSONArray jsonArray = new JSONArray();
                for (ReportElement e : ReportBuilder.getAvailableElements()) {
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("className", e.getClassName());
                    option.put("icon", e.getIcon());
                    option.put("label", e.getLabel());
                    option.put("propertyOptions", e.getPropertyOptions());
                    if (e.getPropertyOptions() != null && !e.getPropertyOptions().isEmpty()) {
                        option.put("defaultProperties", PropertyUtil.getDefaultPropertyValues((String)((String)option.get("propertyOptions"))));
                    } else {
                        option.put("defaultProperties", "{}");
                    }
                    option.put("isContainer", Boolean.toString(e instanceof ReportContainer));
                    if (e instanceof ReportContainer) {
                        option.put("builderScript", ((ReportContainer)((Object)e)).builderScript());
                    }
                    option.put("isHidden", Boolean.toString(e instanceof HiddenPlugin));
                    option.put("supportContainer", Boolean.toString(e.supportReportContainer()));
                    jsonArray.put(option);
                }
                jsonArray.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LogUtil.error((String)((Object)((Object)this)).getClass().getName(), (Throwable)ex, (String)"Get available report element plugin error!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBuilderResult(String json, Map<String, Object> config) {
        ReportBuilder.setReportParameters((Map)config.get(REPORT_PARAMS));
        HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
        boolean isPreview = false;
        if (config.containsKey(IS_PREVIEW)) {
            isPreview = (Boolean)config.get(IS_PREVIEW);
        }
        json = AppUtil.processHashVariable((String)json, null, (String)"json", null);
        json = AppUtil.replaceAppMessages((String)json, (String)"json");
        WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
        User currentUser = workflowUserManager.getCurrentUser();
        Map requestParameterMap = new HashMap();
        if (request != null) {
            requestParameterMap = request.getParameterMap();
        }
        try {
            JSONObject obj = new JSONObject(json);
            String permissionKey = "default";
            boolean hasPermission = false;
            String pageWidth = null;
            String pageHeight = null;
            String top = null;
            String bottom = null;
            String left = null;
            String right = null;
            JSONObject prop = obj.getJSONObject("properties");
            String paperSize = "";
            String margins = "";
            if (prop.has("paperSize")) {
                paperSize = prop.getString("paperSize");
                if ("letter".equalsIgnoreCase(paperSize)) {
                    pageWidth = "215.9";
                    pageHeight = "279.4";
                } else if ("tabloid".equalsIgnoreCase(paperSize)) {
                    pageWidth = "432";
                    pageHeight = "279";
                } else if ("legal".equalsIgnoreCase(paperSize)) {
                    pageWidth = "215.9";
                    pageHeight = "355.6";
                } else if ("statement".equalsIgnoreCase(paperSize)) {
                    pageWidth = "139.7";
                    pageHeight = "215.9";
                } else if ("executive".equalsIgnoreCase(paperSize)) {
                    pageWidth = "184.2";
                    pageHeight = "266.7";
                } else if ("a3".equalsIgnoreCase(paperSize)) {
                    pageWidth = "297";
                    pageHeight = "420";
                } else if ("a4".equalsIgnoreCase(paperSize)) {
                    pageWidth = "210";
                    pageHeight = "297";
                } else if ("a5".equalsIgnoreCase(paperSize)) {
                    pageWidth = "148";
                    pageHeight = "210";
                } else if ("b4".equalsIgnoreCase(paperSize)) {
                    pageWidth = "257";
                    pageHeight = "364";
                } else if ("b5".equalsIgnoreCase(paperSize)) {
                    pageWidth = "182";
                    pageHeight = "257";
                } else if ("16kai".equalsIgnoreCase(paperSize)) {
                    pageWidth = "184";
                    pageHeight = "260";
                } else if ("32kai".equalsIgnoreCase(paperSize)) {
                    pageWidth = "130";
                    pageHeight = "184";
                } else if ("big32kai".equalsIgnoreCase(paperSize)) {
                    pageWidth = "140";
                    pageHeight = "203";
                }
            }
            if (paperSize.isEmpty()) {
                pageWidth = prop.getString("pageWidth");
                pageHeight = prop.getString("pageHeight");
            }
            if (prop.has("margins")) {
                margins = prop.getString("margins");
                if ("normal".equalsIgnoreCase(margins)) {
                    top = "25.4";
                    bottom = "25.4";
                    left = "31.8";
                    right = "31.8";
                } else if ("narrow".equalsIgnoreCase(margins)) {
                    top = "12.7";
                    bottom = "12.7";
                    left = "12.7";
                    right = "12.7";
                } else if ("moderate".equalsIgnoreCase(margins)) {
                    top = "25.4";
                    bottom = "25.4";
                    left = "19.1";
                    right = "19.1";
                } else if ("wide".equalsIgnoreCase(margins)) {
                    top = "25.4";
                    bottom = "25.4";
                    left = "50.8";
                    right = "50.8";
                }
            }
            if (margins.isEmpty()) {
                top = prop.getString("topMargin");
                bottom = prop.getString("bottomMargin");
                left = prop.getString("leftMargin");
                right = prop.getString("rightMargin");
            }
            String bgImg = "";
            if (prop.has("background_image")) {
                bgImg = prop.getString("background_image");
            }
            String bgColor = "";
            if (prop.has("background_color")) {
                bgColor = prop.getString("background_color");
            }
            String bgType = "";
            if (prop.has("background_color")) {
                bgType = prop.getString("background_type");
            }
            String body = "";
            String header = "";
            String footer = "";
            String backgroundCss = "";
            backgroundCss = !bgColor.isEmpty() ? backgroundCss + "background-color:" + bgColor + ";" : backgroundCss + "background-color:#fff;";
            if (!bgImg.isEmpty()) {
                if (bgImg.startsWith("/") && request != null) {
                    bgImg = this.getURL(request, bgImg);
                }
                backgroundCss = backgroundCss + "background-image:url('" + bgImg + "');";
            }
            if ("cover".equals(bgType)) {
                backgroundCss = backgroundCss + "background-size:cover;background-position:center;";
            } else if ("contain".equals(bgType)) {
                backgroundCss = backgroundCss + "background-size:contain;background-position:center;background-repeat:no-repeat;";
            } else if ("repeat".equals(bgType)) {
                backgroundCss = backgroundCss + "background-repeat:repeat;";
            }
            String orientation = prop.getString("orientation");
            String css = !"portrait".equals(orientation) ? "@page {" + backgroundCss + "  size: " + this.getPixel(pageHeight) + "px " + this.getPixel(pageWidth) + "px; margin: " + this.getPixel(top) + "px  " + this.getPixel(right) + "px  " + this.getPixel(bottom) + "px  " + this.getPixel(left) + "px;}" : "@page {" + backgroundCss + "  size: " + this.getPixel(pageWidth) + "px " + this.getPixel(pageHeight) + "px; margin: " + this.getPixel(top) + "px  " + this.getPixel(right) + "px  " + this.getPixel(bottom) + "px  " + this.getPixel(left) + "px;}";
            css = css + ".border-table, .border-table td, .border-table th, .border-table tr {border: 1px solid #000;}";
            css = css + "thead {display: table-header-group;}";
            css = css + "tr {page-break-inside: avoid;}";
            css = css + ".currentpage:before {content: counter(page);}";
            css = css + ".pagenumber:before {content: counter(pages);}";
            css = css + ".LANG_CJK_UNIFIED_IDEOGRAPHS {font-family:\"STSong-Light\", \"MSung-Light\";}";
            css = css + ".LANG_HEBREW {font-family:Arial; word-wrap: break-word; direction: rtl;}";
            css = css + ".LANG_ARABIC {font-family:\"Noto Naskh Arabic\"; word-wrap: break-word; direction: rtl;}";
            css = css + ".LANG_THAI {font-family:\"THSarabun\"; word-wrap: break-word;}";
            css = css + ".LANG_HIRAGANA, .LANG_KATAKANA {font-family:\"HeiseiMin-W3\";}";
            css = css + ".LANG_HANGUL_SYLLABLES {font-family:\"HYGoThic-Medium\";}";
            css = css + ".LANG_CYRILLIC {font-family:\"STSong-Light\";}";
            config.put("elementCss", "");
            if (!isPreview) {
                JSONArray permissionRules;
                if (prop.has("permission_rules") && (permissionRules = prop.getJSONArray("permission_rules")) != null && permissionRules.length() > 0) {
                    for (int i = 0; i < permissionRules.length(); ++i) {
                        JSONObject permissionObj;
                        JSONObject rule = permissionRules.getJSONObject(i);
                        if (!rule.has("permission") || !(hasPermission = CustomBuilderUtil.getPermisionResult((String)(permissionObj = rule.optJSONObject("permission")).toString(), requestParameterMap, (User)currentUser))) continue;
                        permissionKey = rule.getString("permission_key");
                        break;
                    }
                }
                if (!hasPermission) {
                    if (prop.has("permission")) {
                        JSONObject permissionObj = prop.getJSONObject("permission");
                        hasPermission = CustomBuilderUtil.getPermisionResult((String)permissionObj.toString(), requestParameterMap, (User)currentUser);
                    } else {
                        hasPermission = true;
                    }
                }
            } else {
                hasPermission = true;
            }
            if (hasPermission) {
                if (REPORT_OUTPUT_HTML.equalsIgnoreCase((String)config.get(REPORT_OUTPUT))) {
                    if (obj.has("body")) {
                        body = this.renderPart(obj.getJSONObject("body"), permissionKey, requestParameterMap, currentUser, isPreview, config);
                    }
                } else if (REPORT_OUTPUT_HTML_FULL.equalsIgnoreCase((String)config.get(REPORT_OUTPUT))) {
                    String pageCss = "";
                    if (obj.has("header")) {
                        body = body + this.renderPart(obj.getJSONObject("header"), permissionKey, requestParameterMap, currentUser, isPreview, config);
                    }
                    if (obj.has("body")) {
                        body = body + "<div class=\"report_body\">" + this.renderPart(obj.getJSONObject("body"), permissionKey, requestParameterMap, currentUser, isPreview, config) + "</div>";
                        pageCss = pageCss + ".report_body{min-height: 900px;}";
                    }
                    if (obj.has("footer")) {
                        body = body + this.renderPart(obj.getJSONObject("footer"), permissionKey, requestParameterMap, currentUser, isPreview, config);
                    }
                    pageCss = pageCss + ".border-table, .border-table td, .border-table th, .border-table tr {border: 1px solid #000;}";
                    pageCss = pageCss + ".report_page_body{" + backgroundCss + "padding: " + this.getPixel(top) + "px  " + this.getPixel(right) + "px  " + this.getPixel(bottom) + "px  " + this.getPixel(left) + "px; min-height:" + this.getPixel(pageHeight) + "px;}";
                    config.put("elementCss", pageCss + config.get("elementCss"));
                    body = "<div class=\"report_page_body\">" + body + "</div>";
                } else {
                    boolean hasHeader = obj.has("header");
                    boolean hasFooter = obj.has("footer");
                    if (hasHeader && (header = this.renderPart(obj.getJSONObject("header"), permissionKey, requestParameterMap, currentUser, isPreview, config)) != null && !header.isEmpty()) {
                        int height = this.getRenderPartHeight(header, config.get("elementCss").toString(), pageWidth);
                        css = css + "@page {padding-top: " + height + "px;}";
                        css = css + "div.header {padding-top: " + this.getPixel(top) + "px; padding-left:9px; padding-right:9px;}";
                    }
                    if (obj.has("body")) {
                        body = this.renderPart(obj.getJSONObject("body"), permissionKey, requestParameterMap, currentUser, isPreview, config);
                    }
                    if (hasFooter && (footer = this.renderPart(obj.getJSONObject("footer"), permissionKey, requestParameterMap, currentUser, isPreview, config)) != null && !footer.isEmpty()) {
                        int height = this.getRenderPartHeight(footer, config.get("elementCss").toString(), pageWidth);
                        css = css + "@page {padding-bottom: " + height + "px;}";
                        css = css + "div.footer {padding-bottom: " + this.getPixel(bottom) + "px; padding-left:9px; padding-right:9px;}";
                    }
                    if (hasHeader || hasFooter) {
                        css = css + "body{margin-top:0;margin-bottom:0;padding-top:0;padding-bottom:0;}";
                    }
                }
            }
            if (REPORT_OUTPUT_HTML.equalsIgnoreCase((String)config.get(REPORT_OUTPUT)) || REPORT_OUTPUT_HTML_FULL.equalsIgnoreCase((String)config.get(REPORT_OUTPUT))) {
                String string = "<style>" + config.get("elementCss") + "</style>" + body;
                return string;
            }
            if (prop.has("pdfCss")) {
                config.put("elementCss", prop.getString("pdfCss") + config.get("elementCss"));
            }
            header = header.replaceAll("(?s)<script[^>]*>.*?</script>", "");
            footer = footer.replaceAll("(?s)<script[^>]*>.*?</script>", "");
            header = header.replaceAll("(?s)<style[^>]*>.*?</style>", "");
            footer = footer.replaceAll("(?s)<style[^>]*>.*?</style>", "");
            header = header.replaceAll("&([a-zA-Z]+;)", "&amp;$1");
            body = body.replaceAll("&([a-zA-Z]+;)", "&amp;$1");
            footer = footer.replaceAll("&([a-zA-Z]+;)", "&amp;$1");
            header = ReportBuilder.wrapWords(FormPdfUtil.cleanFormHtml((String)header, (Boolean)false));
            body = ReportBuilder.wrapWords(FormPdfUtil.cleanFormHtml((String)body, (Boolean)false));
            footer = ReportBuilder.wrapWords(FormPdfUtil.cleanFormHtml((String)footer, (Boolean)false));
            header = header.replaceAll("&amp;([a-zA-Z]+;)", "&$1");
            if (this.checkIsRTL(body = body.replaceAll("&amp;([a-zA-Z]+;)", "&$1"), header, footer = footer.replaceAll("&amp;([a-zA-Z]+;)", "&$1"), config.get("elementCss").toString())) {
                byte[] byArray = this.createPdf(body, header, footer, css + config.get("elementCss"), false, true, true, false);
                return byArray;
            }
            byte[] byArray = FormPdfUtil.createPdf((String)body, (String)header, (String)footer, (String)(css + config.get("elementCss")), (Boolean)false, (Boolean)true, (Boolean)true, (Boolean)false);
            return byArray;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        finally {
            ReportBuilder.cleanReportParameters();
        }
        return null;
    }

    protected boolean checkIsRTL(String body, String header, String footer, String css) {
        String check = body + header + footer + css;
        return (check = check.toLowerCase()).contains("dir=\"rtl\"") || check.contains("direction: rtl;") || check.contains("direction:rtl;");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] createPdf(String body, String header, String footer, String css, Boolean showAllSelectOptions, Boolean repeatHeader, Boolean repeatFooter, Boolean cleanForm) {
        block12: {
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            boolean imageIoCache = ImageIO.getUseCache();
            try {
                byte[] byArray;
                ImageIO.setUseCache(false);
                String fontCss = "@font-face {font-family: \"Noto Naskh Arabic\";src: url(classpath:resources/fonts/NotoNaskhArabic-Regular.ttf); -fs-pdf-font-embed: embed; -fs-pdf-font-encoding: Identity-H;}";
                String html = FormPdfUtil.formatHtml((String)body, (String)header, (String)footer, (String)(fontCss + css), (Boolean)showAllSelectOptions, (Boolean)repeatHeader, (Boolean)repeatFooter, (Boolean)cleanForm);
                String pattern = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
                String legalHtml = html.replaceAll(pattern, "");
                legalHtml = FormPdfUtil.toXHTML((String)legalHtml);
                legalHtml = legalHtml.replaceAll(StringUtil.escapeRegex((String)"&nbsp;"), StringUtil.escapeRegex((String)"&#160;"));
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    byte[] output;
                    PdfRendererBuilder builder = new PdfRendererBuilder();
                    builder.useFastMode();
                    String uri = "http://localhost:8080";
                    HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
                    if (request != null) {
                        uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
                    }
                    builder.withHtmlContent(legalHtml, uri);
                    builder.useUnicodeBidiSplitter((BidiSplitterFactory)new ICUBidiSplitter.ICUBidiSplitterFactory());
                    builder.useUnicodeBidiReorderer((BidiReorderer)new ICUBidiReorderer());
                    builder.defaultTextDirection(BaseRendererBuilder.TextDirection.LTR);
                    builder.toStream((OutputStream)os);
                    builder.run();
                    byArray = output = os.toByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
                        Thread.currentThread().setContextClassLoader(originalClassLoader);
                        ImageIO.setUseCache(imageIoCache);
                        break block12;
                    }
                }
                os.close();
                return byArray;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
                ImageIO.setUseCache(imageIoCache);
            }
        }
        return null;
    }

    protected String renderPart(JSONObject element, String permissionKey, Map requestParams, User currentUser, boolean isPreview, Map<String, Object> config) throws JSONException {
        String result = "";
        JSONArray elementsArray = element.getJSONArray("elements");
        for (int i = 0; i < elementsArray.length(); ++i) {
            JSONObject elementObj = (JSONObject)elementsArray.get(i);
            ReportElement reportElement = this.getReportElement(elementObj, permissionKey, requestParams, currentUser, isPreview);
            if (reportElement == null) continue;
            result = result + reportElement.render();
            String css = reportElement.getCSS();
            if (css == null || css.isEmpty()) continue;
            config.put("elementCss", config.get("elementCss") + css);
        }
        return result;
    }

    protected ReportElement getReportElement(JSONObject element, String permissionKey, Map requestParams, User currentUser, boolean isPreview) {
        if (element.has("className")) {
            try {
                PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
                Plugin plugin = pluginManager.getPlugin(element.getString("className"));
                if (plugin != null && plugin instanceof ReportElement && plugin instanceof PropertyEditable) {
                    boolean visible = true;
                    if (!isPreview) {
                        JSONObject permissionRules;
                        JSONObject ruleObj = null;
                        if ("default".equals(permissionKey)) {
                            ruleObj = element.getJSONObject("properties");
                        } else if (element.getJSONObject("properties").has("permission_rules") && (permissionRules = element.getJSONObject("properties").getJSONObject("permission_rules")) != null && permissionRules.has(permissionKey)) {
                            ruleObj = permissionRules.getJSONObject(permissionKey);
                        }
                        if (ruleObj != null && ruleObj.has("hidden") && "true".equalsIgnoreCase(ruleObj.get("hidden").toString())) {
                            visible = false;
                        }
                    }
                    if (visible) {
                        ((PropertyEditable)plugin).setProperties(PropertyUtil.getPropertiesValueFromJson((String)element.getJSONObject("properties").toString()));
                        ((PropertyEditable)plugin).setProperty(IS_PREVIEW, (Object)isPreview);
                        if (plugin instanceof ReportContainer && element.has("elements")) {
                            ArrayList<ReportElement> childs = new ArrayList<ReportElement>();
                            JSONArray childsArr = element.getJSONArray("elements");
                            for (int i = 0; i < childsArr.length(); ++i) {
                                JSONObject childObj = (JSONObject)childsArr.get(i);
                                ReportElement c = this.getReportElement(childObj, permissionKey, requestParams, currentUser, isPreview);
                                if (c == null) continue;
                                childs.add(c);
                            }
                            ((ReportContainer)plugin).setChildren(childs);
                        }
                        return (ReportElement)plugin;
                    }
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            }
        }
        return null;
    }

    public static void setReportParameters(Map<String, String> params) {
        LinkedList<Map<String, String>> stack = (LinkedList<Map<String, String>>)reportParameters.get();
        if (stack == null) {
            stack = new LinkedList<Map<String, String>>();
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        stack.push(params);
        reportParameters.set(stack);
    }

    public static Map<String, String> getReportParameters() {
        LinkedList stack = (LinkedList)reportParameters.get();
        if (stack != null && !stack.isEmpty()) {
            return (Map)stack.getFirst();
        }
        return null;
    }

    public static void cleanReportParameters() {
        LinkedList stack = (LinkedList)reportParameters.get();
        if (stack != null) {
            stack.pop();
        }
        if (stack == null || stack.isEmpty()) {
            reportParameters.remove();
        } else {
            reportParameters.set(stack);
        }
    }

    public static Collection<ReportElement> getAvailableElements() {
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        ArrayList<ReportElement> list = new ArrayList<ReportElement>();
        Collection pluginList = pluginManager.list(ReportElement.class);
        for (Plugin plugin : pluginList) {
            if (!(plugin instanceof ReportElement)) continue;
            list.add((ReportElement)plugin);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRenderPartHeight(String html, String css, String width) {
        int px = this.getPixel(width);
        boolean imageIoCache = ImageIO.getUseCache();
        try {
            html = html.replaceAll("(?s)<script[^>]*>.*?</script>", "");
            html = html.replaceAll("(?s)<style[^>]*>.*?</style>", "");
            html = FormPdfUtil.cleanFormHtml((String)html, (Boolean)false);
            ImageIO.setUseCache(false);
            String htmlMeta = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
            htmlMeta = htmlMeta + "<!DOCTYPE html>";
            htmlMeta = htmlMeta + "<html>";
            htmlMeta = htmlMeta + "<head>";
            htmlMeta = htmlMeta + "<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=UTF-8\" />";
            htmlMeta = htmlMeta + "<style>" + css + "</style>";
            htmlMeta = htmlMeta + "</head><body>";
            htmlMeta = htmlMeta + html;
            htmlMeta = htmlMeta + "</body></html>";
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setEntityResolver((EntityResolver)FSEntityResolver.instance());
            Document xmlDoc = builder.parse(new ByteArrayInputStream(htmlMeta.getBytes("UTF-8")));
            Java2DRenderer renderer = new Java2DRenderer(xmlDoc, px);
            int n = renderer.getImage().getHeight() - 20;
            return n;
        }
        catch (Exception e) {
            LogUtil.error((String)ReportBuilder.class.getName(), (Throwable)e, (String)"");
        }
        finally {
            ImageIO.setUseCache(imageIoCache);
        }
        return 0;
    }

    protected int getPixel(String number) {
        int px = 0;
        try {
            px = (int)Math.round(Double.parseDouble(number) * 3.7795275590551185);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return px;
    }

    protected String getURL(HttpServletRequest req, String link) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        if (link != null) {
            url.append(link);
        }
        return url.toString();
    }

    public static String wrapWords(String html) {
        String[] tags;
        for (String t : tags = new String[]{"span", "label", "th", "td", "p", "a", "li", "div"}) {
            Pattern pattern = Pattern.compile("<" + t + "[^>]*>((?:(?!<" + t + "[^>]*>).)+?)<\\/" + t + ">", 32);
            Matcher matcher = pattern.matcher(html);
            while (matcher.find()) {
                String text;
                String tagHtml = matcher.group(0);
                String temp = text = matcher.group(1);
                StringBuilder replace = new StringBuilder();
                Boolean languageChanged = false;
                String prevLang = null;
                if (temp.trim().isEmpty() || tagHtml.contains("<span class=\"LANG_")) continue;
                boolean hasInnerTags = false;
                for (String ct : tags) {
                    if (!temp.contains("</" + ct + ">")) continue;
                    hasInnerTags = true;
                }
                if (hasInnerTags) {
                    replace = new StringBuilder(ReportBuilder.wrapWords(text));
                } else {
                    String[] chunks;
                    if (temp.contains("<br")) {
                        temp = temp.replaceAll(StringUtil.escapeRegex((String)"<br"), StringUtil.escapeRegex((String)" <br"));
                    }
                    if (temp.contains("/>")) {
                        temp = temp.replaceAll(StringUtil.escapeRegex((String)"/>"), StringUtil.escapeRegex((String)"/> "));
                    }
                    for (String c : chunks = temp.split("\\b")) {
                        if (!c.trim().isEmpty()) {
                            String lang = ReportBuilder.getLangauge(c);
                            if (!"BASIC_LATIN".equals(lang)) {
                                if (prevLang != null && !lang.equals(prevLang) && !prevLang.equals("BASIC_LATIN")) {
                                    replace.append("</span>");
                                }
                                if (!lang.equals(prevLang)) {
                                    languageChanged = true;
                                    replace.append("<span class=\"LANG_").append(lang).append("\">");
                                }
                            } else if (languageChanged.booleanValue()) {
                                languageChanged = false;
                                replace.append("</span>");
                            }
                            prevLang = lang;
                        }
                        replace.append(c);
                    }
                    if (languageChanged.booleanValue()) {
                        replace.append("</span>");
                    }
                }
                if (replace.indexOf("<span class=\"LANG_") == -1) continue;
                String replaceString = tagHtml.replaceAll(StringUtil.escapeRegex((String)text), StringUtil.escapeRegex((String)replace.toString()));
                html = html.replaceAll(StringUtil.escapeRegex((String)tagHtml), StringUtil.escapeRegex((String)replaceString));
            }
        }
        return html;
    }

    protected static String getLangauge(String word) {
        word = StringUtil.unescapeString((String)word, (String)"html", null);
        String lang = Character.UnicodeBlock.of(word.charAt(0)).toString();
        return lang;
    }
}

