/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.BarcodeFactory;
import net.sourceforge.barbecue.BarcodeImageHandler;
import net.sourceforge.barbecue.linear.code39.Code39Barcode;
import net.sourceforge.barbecue.linear.ean.UCCEAN128Barcode;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;

public class BarcodeReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    public String getName() {
        return "BarcodeReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/BarcodeReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-barcode\"></i>";
    }

    @Override
    public String render() {
        String value = this.getPropertyString("value" + this.getPropertyString("type"));
        if (value.isEmpty()) {
            return "";
        }
        String image = this.getBarcodeBase64Image(value);
        if (image != null) {
            String style = "";
            String margin = "";
            if (!this.getPropertyString("width").isEmpty()) {
                style = style + "width:" + this.getPropertyString("width") + ";";
            }
            if (!this.getPropertyString("height").isEmpty()) {
                style = style + "height:" + this.getPropertyString("height") + ";";
            }
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                margin = margin + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\" style=\"text-align:" + this.getPropertyString("halign") + ";" + margin + "\"><img style=\"" + style + "\" src=\"data:image/jpeg;base64," + image + "\" /></div>";
        }
        return "";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        return this.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getBarcodeBase64Image(String text) {
        try {
            Barcode bc = null;
            boolean showText = "true".equalsIgnoreCase(this.getPropertyString("showText"));
            boolean checkSum = "true".equalsIgnoreCase(this.getPropertyString("checkSum"));
            switch (this.getPropertyString("type")) {
                case "0": {
                    bc = BarcodeFactory.create2of7((String)text);
                    break;
                }
                case "1": {
                    bc = BarcodeFactory.create3of9((String)text, (boolean)checkSum);
                    break;
                }
                case "2": {
                    bc = BarcodeFactory.createBookland((String)text);
                    break;
                }
                case "3": {
                    bc = BarcodeFactory.createCodabar((String)text);
                    break;
                }
                case "4": {
                    bc = BarcodeFactory.createCode128((String)text);
                    break;
                }
                case "5": {
                    bc = BarcodeFactory.createCode128A((String)text);
                    break;
                }
                case "6": {
                    bc = BarcodeFactory.createCode128B((String)text);
                    break;
                }
                case "7": {
                    bc = BarcodeFactory.createCode128B((String)text);
                    break;
                }
                case "8": {
                    bc = BarcodeFactory.createCode39((String)text, (boolean)checkSum);
                    break;
                }
                case "9": {
                    bc = BarcodeFactory.createEAN128((String)text);
                    break;
                }
                case "10": {
                    bc = BarcodeFactory.createEAN13((String)text);
                    break;
                }
                case "11": {
                    bc = BarcodeFactory.createGlobalTradeItemNumber((String)text);
                    break;
                }
                case "12": {
                    bc = BarcodeFactory.createInt2of5((String)text, (boolean)checkSum);
                    break;
                }
                case "13": {
                    bc = BarcodeFactory.createMonarch((String)text);
                    break;
                }
                case "14": {
                    bc = BarcodeFactory.createNW7((String)text);
                    break;
                }
                case "15": {
                    bc = BarcodeFactory.createPDF417((String)text);
                    break;
                }
                case "16": {
                    bc = BarcodeFactory.createSCC14ShippingCode((String)text);
                    break;
                }
                case "17": {
                    bc = BarcodeFactory.createShipmentIdentificationNumber((String)text);
                    break;
                }
                case "18": {
                    bc = new UCCEAN128Barcode("00", text, checkSum);
                    break;
                }
                case "19": {
                    bc = BarcodeFactory.createStd2of5((String)text, (boolean)checkSum);
                    break;
                }
                case "20": {
                    bc = new UCCEAN128Barcode(this.getPropertyString("applicationIdentifier"), text, checkSum);
                    break;
                }
                case "21": {
                    bc = BarcodeFactory.createUPCA((String)text);
                    break;
                }
                case "22": {
                    bc = BarcodeFactory.createUSD3((String)text, (boolean)checkSum);
                    break;
                }
                case "23": {
                    bc = BarcodeFactory.createUSD4((String)text);
                    break;
                }
                case "24": {
                    bc = BarcodeFactory.createUSPS((String)text);
                    break;
                }
                case "25": {
                    bc = new Code39Barcode(text, checkSum, true);
                    break;
                }
            }
            bc.setDrawingText(showText);
            BufferedImage image = BarcodeImageHandler.getImage((Barcode)bc);
            String imageString = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            boolean imageIoCache = ImageIO.getUseCache();
            try {
                ImageIO.setUseCache(false);
                ImageIO.write((RenderedImage)image, "jpeg", bos);
                byte[] imageBytes = bos.toByteArray();
                byte[] encodedBytes = Base64.getEncoder().encode(imageBytes);
                imageString = new String(encodedBytes, "UTF-8");
            }
            finally {
                ImageIO.setUseCache(imageIoCache);
                bos.close();
            }
            return imageString;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)text);
            return null;
        }
    }

    @Override
    public String getCSS() {
        return "";
    }
}

