/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataListBinder;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.model.DataListFilterQueryObject;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.BubbleChart;
import org.knowm.xchart.BubbleChartBuilder;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.CategorySeries;
import org.knowm.xchart.OHLCChart;
import org.knowm.xchart.OHLCChartBuilder;
import org.knowm.xchart.OHLCSeries;
import org.knowm.xchart.PieChart;
import org.knowm.xchart.PieChartBuilder;
import org.knowm.xchart.PieSeries;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.BubbleStyler;
import org.knowm.xchart.style.CategoryStyler;
import org.knowm.xchart.style.OHLCStyler;
import org.knowm.xchart.style.PieStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class ChartReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    protected DataListCollection binderdata = null;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public String getName() {
        return "ChartReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/ChartReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-chart-bar\"></i>";
    }

    protected String validateChar(boolean print) {
        String image = this.getChartBase64Image();
        if (image != null) {
            if (image.startsWith("<div") && image.endsWith("</div>")) {
                if (print) {
                    if (this.getProperty("binder") == null) {
                        return "<div style=\"color:red;\">Chart configuration error!</div>";
                    }
                    return image;
                }
                return "";
            }
            String style = "";
            String margin = "";
            String width = this.getPropertyString("chartWidth");
            String height = this.getPropertyString("chartHeight");
            if (!width.isEmpty()) {
                if (!width.endsWith("px")) {
                    width = width + "px";
                }
                style = style + "width:" + width + ";";
            }
            if (!height.isEmpty()) {
                if (!height.endsWith("px")) {
                    height = height + "px";
                }
                style = style + "height:" + height + ";";
            }
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                margin = margin + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\" style=\"text-align:" + this.getPropertyString("halign") + ";" + margin + "\"><img style=\"" + style + "\" src=\"data:image/jpeg;base64," + image + "\" /></div>";
        }
        return "";
    }

    @Override
    public String render() {
        String validateChar = this.validateChar(false);
        return validateChar;
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        String validateChar = this.validateChar(true);
        return validateChar;
    }

    @Override
    public String getCSS() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getChartBase64Image() {
        block23: {
            int width = this.getWidth();
            int height = this.getHeight();
            try {
                String type;
                if (!this.getPropertyString("mapping_dateformat").isEmpty()) {
                    this.sdf = new SimpleDateFormat(this.getPropertyString("mapping_dateformat"));
                }
                Chart chart = null;
                switch (type = this.getPropertyString("chartType")) {
                    case "xy": 
                    case "line": 
                    case "area": 
                    case "bar": {
                        chart = this.xyChart(width, height);
                        break;
                    }
                    case "bubble": {
                        chart = this.bubbleChart(width, height);
                        break;
                    }
                    case "candlestick": 
                    case "ohlc": {
                        chart = this.ohlcChart(width, height);
                        break;
                    }
                    case "donut": 
                    case "pie": {
                        chart = this.pieChart(width, height);
                        break;
                    }
                }
                if (chart == null) break block23;
                chart.setTitle(this.getPropertyString("title"));
                chart.getStyler().setChartBackgroundColor(Color.WHITE);
                chart.getStyler().setPlotContentSize(0.8);
                BufferedImage image = BitmapEncoder.getBufferedImage((Chart)chart);
                String imageString = null;
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                boolean imageIoCache = ImageIO.getUseCache();
                try {
                    ImageIO.setUseCache(false);
                    ImageIO.write((RenderedImage)image, "jpeg", bos);
                    byte[] imageBytes = bos.toByteArray();
                    byte[] encodedBytes = Base64.getEncoder().encode(imageBytes);
                    imageString = new String(encodedBytes, "UTF-8");
                }
                finally {
                    ImageIO.setUseCache(imageIoCache);
                    bos.close();
                }
                return imageString;
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)e.getMessage());
                return "<div style=\"color:red;\">" + e.getLocalizedMessage() + "</div>";
            }
        }
        return null;
    }

    protected DataListCollection getData() {
        PluginManager pluginManager;
        DataListBinder binder;
        Map bdMap;
        Object binderData;
        if (this.binderdata == null && (binderData = this.getProperty("binder")) != null && binderData instanceof Map && (bdMap = (Map)binderData) != null && bdMap.containsKey("className") && !bdMap.get("className").toString().isEmpty() && (binder = (DataListBinder)(pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager")).getPlugin(bdMap.get("className").toString())) != null) {
            Map bdProps = (Map)bdMap.get("properties");
            binder.setProperties(bdProps);
            String sort = null;
            Boolean order = null;
            if (!this.getPropertyString("sortingOrderByColumn").isEmpty()) {
                sort = this.getPropertyString("sortingOrderByColumn");
                order = "DESC".equals(this.getPropertyString("sortingOrder"));
            }
            this.binderdata = binder.getData(null, bdProps, new DataListFilterQueryObject[0], sort, order, null, null);
        }
        return this.binderdata;
    }

    protected Chart xyChart(int width, int height) {
        HashMap mapping;
        ArrayList<Object> xData = new ArrayList<Object>();
        HashMap data = new HashMap();
        Object[] mapping_values = (Object[])this.getProperty("mapping_ys");
        for (Object mapping_value : mapping_values) {
            HashMap mapping2 = (HashMap)mapping_value;
            String name = mapping2.get("y").toString();
            data.put(name, new ArrayList());
        }
        for (Object r : this.getData()) {
            if (this.getPropertyString("xAxisDisplayAS").isEmpty()) {
                if (this.getValue(r, this.getPropertyString("mapping_x")).isEmpty()) {
                    xData.add(" ");
                } else {
                    xData.add(this.getValue(r, this.getPropertyString("mapping_x")));
                }
            } else if ("number".equals(this.getPropertyString("xAxisDisplayAS"))) {
                xData.add(this.getNumber(r, this.getPropertyString("mapping_x")));
            } else if ("date".equals(this.getPropertyString("xAxisDisplayAS"))) {
                xData.add(this.getDate(r, this.getPropertyString("mapping_x")));
            }
            for (String key : data.keySet()) {
                Collection y = (Collection)data.get(key);
                y.add(this.getNumber(r, key));
            }
        }
        CategoryChart chart = null;
        if (this.getPropertyString("xAxisDisplayAS").isEmpty() || "bar".equalsIgnoreCase(this.getPropertyString("chartType"))) {
            chart = ((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(width)).height(height)).xAxisTitle(this.getPropertyString("categoryAxisLabel")).yAxisTitle(this.getPropertyString("valueAxisLabel")).build();
            if ("area".equalsIgnoreCase(this.getPropertyString("chartType"))) {
                ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Area);
            } else if ("xy".equalsIgnoreCase(this.getPropertyString("chartType"))) {
                ((CategoryStyler)chart.getStyler()).setDefaultSeriesRenderStyle(CategorySeries.CategorySeriesRenderStyle.Line);
            }
            for (Object mapping_value : mapping_values) {
                mapping = (HashMap)mapping_value;
                String name = mapping.get("y").toString();
                chart.addSeries(mapping.get("legend").toString(), xData, (List)data.get(name));
            }
            if ("true".equalsIgnoreCase(this.getPropertyString("stack"))) {
                ((CategoryStyler)chart.getStyler()).setStacked(true);
            }
            if ("true".equalsIgnoreCase(this.getPropertyString("showValueLabel"))) {
                chart.getStyler().setHasAnnotations(true);
            }
            if (!this.getPropertyString("dateFormat").isEmpty()) {
                ((CategoryStyler)chart.getStyler()).setDatePattern(this.getPropertyString("dateFormat"));
            }
        } else {
            chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(width)).height(height)).xAxisTitle(this.getPropertyString("categoryAxisLabel")).yAxisTitle(this.getPropertyString("valueAxisLabel")).build();
            if ("area".equalsIgnoreCase(this.getPropertyString("chartType"))) {
                ((XYStyler)((XYChart)chart).getStyler()).setDefaultSeriesRenderStyle(XYSeries.XYSeriesRenderStyle.Area);
            }
            for (Object mapping_value : mapping_values) {
                mapping = (HashMap)mapping_value;
                String name = mapping.get("y").toString();
                ((XYChart)chart).addSeries(mapping.get("legend").toString(), xData, (List)data.get(name));
            }
            if ("true".equalsIgnoreCase(this.getPropertyString("showValueLabel"))) {
                ((XYStyler)((XYChart)chart).getStyler()).setToolTipType(Styler.ToolTipType.yLabels);
            }
            if (!this.getPropertyString("dateFormat").isEmpty()) {
                ((XYStyler)((XYChart)chart).getStyler()).setDatePattern(this.getPropertyString("dateFormat"));
            }
        }
        chart.getStyler().setLegendPosition(Styler.LegendPosition.OutsideE);
        Color[] colors = this.getColors();
        if (colors != null) {
            chart.getStyler().setSeriesColors(colors);
        }
        if (!"true".equalsIgnoreCase(this.getPropertyString("showLegend"))) {
            chart.getStyler().setLegendVisible(false);
        }
        return chart;
    }

    protected Chart bubbleChart(int width, int height) {
        BubbleChart chart = ((BubbleChartBuilder)((BubbleChartBuilder)new BubbleChartBuilder().width(width)).height(height)).xAxisTitle(this.getPropertyString("categoryAxisLabel")).yAxisTitle(this.getPropertyString("valueAxisLabel")).build();
        for (Object r : this.getData()) {
            ArrayList<Number> x = new ArrayList<Number>();
            x.add(this.getNumber(r, this.getPropertyString("mapping_x")));
            ArrayList<Number> y = new ArrayList<Number>();
            y.add(this.getNumber(r, this.getPropertyString("mapping_y")));
            ArrayList<Number> ra = new ArrayList<Number>();
            ra.add(this.getNumber(r, this.getPropertyString("mapping_r")));
            chart.addSeries(this.getValue(r, this.getPropertyString("mapping_label")), x, y, ra);
        }
        Color[] colors = this.getColors();
        if (colors != null) {
            ((BubbleStyler)chart.getStyler()).setSeriesColors(colors);
        }
        if (!"true".equalsIgnoreCase(this.getPropertyString("showLegend"))) {
            ((BubbleStyler)chart.getStyler()).setLegendVisible(false);
        }
        return chart;
    }

    protected Chart ohlcChart(int width, int height) {
        OHLCChart chart = ((OHLCChartBuilder)((OHLCChartBuilder)new OHLCChartBuilder().width(width)).height(height)).build();
        ((OHLCStyler)chart.getStyler()).setLegendVisible(false);
        ((OHLCStyler)chart.getStyler()).setToolTipsEnabled(true);
        ArrayList<Date> date = new ArrayList<Date>();
        ArrayList<Number> open = new ArrayList<Number>();
        ArrayList<Number> high = new ArrayList<Number>();
        ArrayList<Number> low = new ArrayList<Number>();
        ArrayList<Number> close = new ArrayList<Number>();
        for (Object r : this.getData()) {
            date.add(this.getDate(r, this.getPropertyString("mapping_date")));
            open.add(this.getNumber(r, this.getPropertyString("mapping_open")));
            high.add(this.getNumber(r, this.getPropertyString("mapping_high")));
            low.add(this.getNumber(r, this.getPropertyString("mapping_low")));
            close.add(this.getNumber(r, this.getPropertyString("mapping_close")));
        }
        if ("candlestick".equalsIgnoreCase(this.getPropertyString("chartType"))) {
            chart.addSeries("data", date, open, high, low, close).setUpColor(Color.RED).setDownColor(Color.GREEN);
        } else {
            chart.addSeries("data", date, open, high, low, close).setOhlcSeriesRenderStyle(OHLCSeries.OHLCSeriesRenderStyle.HiLo);
        }
        if (!this.getPropertyString("dateFormat").isEmpty()) {
            ((OHLCStyler)chart.getStyler()).setDatePattern(this.getPropertyString("dateFormat"));
        }
        return chart;
    }

    protected Chart pieChart(int width, int height) {
        PieChart chart = ((PieChartBuilder)((PieChartBuilder)new PieChartBuilder().width(width)).height(height)).build();
        for (Object r : this.getData()) {
            chart.addSeries(this.getValue(r, this.getPropertyString("mapping_legend")), this.getNumber(r, this.getPropertyString("mapping_value")));
        }
        if ("donut".equalsIgnoreCase(this.getPropertyString("chartType"))) {
            ((PieStyler)chart.getStyler()).setDefaultSeriesRenderStyle(PieSeries.PieSeriesRenderStyle.Donut);
        }
        if (!"true".equalsIgnoreCase(this.getPropertyString("showLegend"))) {
            ((PieStyler)chart.getStyler()).setLegendVisible(false);
        }
        if ("true".equalsIgnoreCase(this.getPropertyString("showValue"))) {
            ((PieStyler)chart.getStyler()).setAnnotationType(PieStyler.AnnotationType.Value);
        }
        ((PieStyler)chart.getStyler()).setPlotBorderVisible(false);
        Color[] colors = this.getColors();
        if (colors != null) {
            ((PieStyler)chart.getStyler()).setSeriesColors(colors);
        }
        return chart;
    }

    protected String getValue(Object o, String name) {
        String value = "";
        try {
            Object v = DataListService.evaluateColumnValueFromRow((Object)o, (String)name);
            if (v != null) {
                return v.toString();
            }
        }
        catch (Exception e) {
            return "<div style=\"color:red;\">" + e.getLocalizedMessage() + "</div>";
        }
        return value;
    }

    protected Number getNumber(Object o, String name) {
        double value = 0.0;
        try {
            Object v = DataListService.evaluateColumnValueFromRow((Object)o, (String)name);
            if (v instanceof Number) {
                return (Number)v;
            }
            value = Double.parseDouble(v.toString());
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)name);
        }
        return value;
    }

    protected Date getDate(Object o, String name) {
        try {
            Object v = DataListService.evaluateColumnValueFromRow((Object)o, (String)name);
            if (v instanceof Date) {
                return (Date)v;
            }
            return this.sdf.parse(v.toString());
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)name);
            return null;
        }
    }

    public int getWidth() {
        int width = 640;
        try {
            if (!this.getPropertyString("chartWidth").isEmpty()) {
                width = Integer.parseInt(this.getPropertyString("chartWidth"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return width;
    }

    public int getHeight() {
        int height = 480;
        try {
            if (!this.getPropertyString("chartHeight").isEmpty()) {
                height = Integer.parseInt(this.getPropertyString("chartHeight"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return height;
    }

    protected boolean check(String value, String[] list) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(Arrays.asList(list));
        return valueList.contains(value);
    }

    protected String convertDateFormat(String format) {
        format = format.replaceAll("yyyy", "%Y");
        format = format.replaceAll("yy", "%y");
        format = format.replaceAll("MMMMM", "%B");
        format = format.replaceAll("MMM", "%b");
        format = format.replaceAll("MM", "%m");
        format = format.replaceAll("M", "%#m");
        format = format.replaceAll("dd", "%d");
        format = format.replaceAll("HH", "%H");
        format = format.replaceAll("kk", "%H");
        format = format.replaceAll("KK", "%I");
        format = format.replaceAll("hh", "%I");
        format = format.replaceAll("a", "%p");
        format = format.replaceAll("mm", "%M");
        format = format.replaceAll("ss", "%S");
        return format;
    }

    protected Color[] getColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        if (!this.getPropertyString("colors").isEmpty()) {
            String[] colorCodes;
            for (String c : colorCodes = this.getPropertyString("colors").split(",")) {
                try {
                    colors.add(Color.decode(c.trim()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!colors.isEmpty()) {
            return colors.toArray(new Color[0]);
        }
        return null;
    }
}

