/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.util.Collection;
import java.util.Map;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.userview.model.Permission;
import org.joget.directory.model.User;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportContainer;
import org.joget.rbuilder.api.ReportElement;
import org.joget.workflow.model.service.WorkflowUserManager;

public class ColumnsReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement,
ReportContainer {
    Collection<ReportElement> child = null;
    protected String css = "";

    public String getName() {
        return "ColumnsReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/ColumnsReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-columns\"></i>";
    }

    @Override
    public String render() {
        if (this.isAuthorize().booleanValue()) {
            String html = "";
            Collection<ReportElement> columns = this.getChildren();
            String marginBottom = "";
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                marginBottom = marginBottom + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            String width = "50%";
            String type = this.getPropertyString("type");
            if (null != type) {
                switch (type) {
                    case "0": {
                        width = "100%";
                        break;
                    }
                    case "2": {
                        width = "30%";
                        break;
                    }
                    case "3": {
                        width = "70%";
                        break;
                    }
                    case "4": {
                        width = "33.3333%";
                        break;
                    }
                    case "5": {
                        width = "25%";
                        break;
                    }
                    case "6": {
                        width = "20%";
                        break;
                    }
                    case "7": {
                        width = "80%";
                        break;
                    }
                }
            }
            String borderStyle = "";
            String borderPadding = "";
            if ("true".equalsIgnoreCase(this.getPropertyString("display_border"))) {
                if (!this.getPropertyString("borderSize").isEmpty()) {
                    borderStyle = borderStyle + "border:" + this.getPropertyString("borderSize") + " " + this.getPropertyString("borderStyle") + " " + this.getPropertyString("borderColor") + ";";
                }
                if (!this.getPropertyString("padding_top").isEmpty()) {
                    borderPadding = borderPadding + "padding-top:" + this.getPropertyString("padding_top") + ";";
                }
                if (!this.getPropertyString("padding_bottom").isEmpty()) {
                    borderPadding = borderPadding + "padding-bottom:" + this.getPropertyString("padding_bottom") + ";";
                }
                if (!this.getPropertyString("padding_left").isEmpty()) {
                    borderPadding = borderPadding + "padding-left:" + this.getPropertyString("padding_top") + ";";
                }
                if (!this.getPropertyString("padding_right").isEmpty()) {
                    borderPadding = borderPadding + "padding-right:" + this.getPropertyString("padding_right") + ";";
                }
            }
            if (columns != null && !columns.isEmpty()) {
                html = html + "<table class=\"columns\" style=\"width:100%;border-collapse: collapse;border-spacing: 0;" + marginBottom + "\"><tr style=\"vertical-align:top;\">";
                boolean isFirst = true;
                for (ReportElement column : columns) {
                    if (!"true".equalsIgnoreCase(this.getPropertyString("display_border")) && !this.getPropertyString("gap").isEmpty()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            html = html + "<td class=\"gap\" style=\"width:" + this.getPropertyString("gap") + ";\"></td>";
                        }
                    }
                    html = html + "<td class=\"column\" style=\"width:" + width + ";" + borderStyle + "\"><div style=\"" + borderPadding + "\">" + column.render() + "</div></td>";
                    String ecss = column.getCSS();
                    if (ecss != null && !ecss.isEmpty()) {
                        this.css = this.css + ecss;
                    }
                    if ("30%".equals(width)) {
                        width = "70%";
                        continue;
                    }
                    if ("70%".equals(width)) {
                        width = "30%";
                        continue;
                    }
                    if ("20%".equals(width)) {
                        width = "80%";
                        continue;
                    }
                    if (!"80%".equals(width)) continue;
                    width = "20%";
                }
                html = html + "</tr></table>";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\">" + html + "</div>";
        }
        return "";
    }

    @Override
    public boolean supportReportContainer() {
        return false;
    }

    @Override
    public String preview() {
        return this.render();
    }

    @Override
    public String getCSS() {
        return this.css;
    }

    @Override
    public String builderScript() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/scripts/columns.js", null, (boolean)false, (String)"messages/ReportElements");
    }

    @Override
    public void setChildren(Collection<ReportElement> child) {
        this.child = child;
    }

    @Override
    public Collection<ReportElement> getChildren() {
        return this.child;
    }

    public Boolean isAuthorize() {
        Boolean isAuthorize = null;
        Map permission = (Map)this.getProperty("permission");
        isAuthorize = permission != null ? ColumnsReportElement.getPermissionResult(permission) : Boolean.valueOf(true);
        return isAuthorize;
    }

    public static Boolean getPermissionResult(Map permissionObj) {
        PluginManager pluginManager;
        Permission permission;
        Boolean isAuthorize = true;
        if (permissionObj != null && permissionObj.get("className") != null && (permission = (Permission)(pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager")).getPlugin(permissionObj.get("className").toString())) != null) {
            permission.setProperties((Map)permissionObj.get("properties"));
            WorkflowUserManager workflowUserManager = (WorkflowUserManager)AppUtil.getApplicationContext().getBean("workflowUserManager");
            User user = workflowUserManager.getCurrentUser();
            permission.setCurrentUser(user);
            isAuthorize = permission.isAuthorize();
        }
        return isAuthorize;
    }
}

