/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListActionDefault;
import org.joget.apps.datalist.model.DataListActionResult;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.LogUtil;
import org.joget.rbuilder.ReportBuilder;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.util.WorkflowUtil;

public class DownloadReportDatalistAction
extends DataListActionDefault {
    protected ReportBuilder builder = null;

    public String getName() {
        return "DownloadReportDatalistAction";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/properties/report/DownloadReportDatalistAction.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)"DownloadReportDatalistAction.desc", (String)this.getClassName(), (String)"messages/ReportElements");
    }

    public String getLinkLabel() {
        return this.getPropertyString("label");
    }

    public String getHref() {
        return this.getPropertyString("href");
    }

    public String getTarget() {
        return "post";
    }

    public String getHrefParam() {
        return this.getPropertyString("hrefParam");
    }

    public String getHrefColumn() {
        return this.getPropertyString("hrefColumn");
    }

    public String getConfirmation() {
        return this.getPropertyString("confirmation");
    }

    public String getCustomFilename() {
        return this.getPropertyString("fileName");
    }

    public DataListActionResult executeAction(DataList dataList, String[] rowKeys) {
        HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
        String customFilename = this.getCustomFilename();
        if (rowKeys != null && rowKeys.length > 0) {
            try {
                HttpServletResponse response = WorkflowUtil.getHttpServletResponse();
                if (rowKeys.length == 1) {
                    if (customFilename != null && !customFilename.isEmpty()) {
                        rowKeys = new String[]{customFilename};
                    }
                    this.singlePdf(request, response, rowKeys[0], dataList);
                } else {
                    this.multiplePdfs(request, response, rowKeys, dataList);
                }
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)("Fail to generate PDF for " + ArrayUtils.toString((Object)rowKeys)));
            }
        }
        return null;
    }

    protected void singlePdf(HttpServletRequest request, HttpServletResponse response, String rowKey, DataList dataList) throws IOException, ServletException {
        byte[] pdf = this.generetaPDF(rowKey, dataList);
        this.writeResponse(request, response, pdf, rowKey + ".pdf", "application/pdf");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void multiplePdfs(HttpServletRequest request, HttpServletResponse response, String[] rowKeys, DataList dataList) throws IOException, ServletException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zip = new ZipOutputStream(baos);
        String foldername = this.getLinkLabel();
        String customFilename = this.getCustomFilename();
        try {
            for (String id : rowKeys) {
                byte[] pdf = this.generetaPDF(id, dataList);
                String filename = "";
                if (customFilename != null && !customFilename.isEmpty()) {
                    foldername = customFilename;
                    filename = customFilename + "_" + id;
                } else {
                    filename = id;
                }
                zip.putNextEntry(new ZipEntry(filename + ".pdf"));
                zip.write(pdf);
                zip.closeEntry();
            }
            zip.finish();
            this.writeResponse(request, response, baos.toByteArray(), foldername + ".zip", "application/zip");
        }
        finally {
            baos.close();
            zip.flush();
        }
    }

    protected byte[] generetaPDF(String id, DataList dataList) {
        String reportId = this.getPropertyString("reportId");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(reportId, appDef);
        WorkflowAssignment ass = new WorkflowAssignment();
        ass.setProcessId(id);
        String json = "";
        HashMap<String, String> rparams = new HashMap<String, String>();
        rparams.put("id", id);
        if (builderDefinition != null) {
            json = builderDefinition.getJson();
            json = AppUtil.processHashVariable((String)json, (WorkflowAssignment)ass, (String)"json", null);
            DataListCollection rows = dataList.getRows();
            Object finalValue = null;
            Object reportParams = this.getProperty("reportParams");
            if (reportParams != null && reportParams instanceof Object[] && ((Object[])reportParams).length > 0) {
                for (Object param : (Object[])reportParams) {
                    Map paramMap = (Map)param;
                    String value = paramMap.get("value").toString();
                    for (Object r : rows) {
                        Object idValue = DataListService.evaluateColumnValueFromRow(r, (String)"id");
                        if (!idValue.toString().equals(id)) continue;
                        finalValue = DataListService.evaluateColumnValueFromRow(r, (String)value);
                    }
                    rparams.put(paramMap.get("param").toString(), finalValue.toString());
                }
            }
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("REPORT_PARAMS", rparams);
        return (byte[])this.getBuilder().getBuilderResult(json, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, byte[] bytes, String filename, String contentType) throws IOException, ServletException {
        ServletOutputStream out = response.getOutputStream();
        try {
            response.setHeader("Content-Type", contentType);
            response.setHeader("Content-Disposition", "attachment; filename=" + filename + "; filename*=UTF-8''" + filename);
            response.setContentLength(bytes.length);
            out.write(bytes);
        }
        catch (IOException ex) {
            LogUtil.error((String)this.getClassName(), (Throwable)ex, null);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected ReportBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = (ReportBuilder)CustomBuilderUtil.getBuilder((String)"report");
        }
        return this.builder;
    }
}

