/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.service.FormPdfUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;

public class FormReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    private String formCss = "";

    public String getName() {
        return "FormReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/FormReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-file-alt\"></i>";
    }

    @Override
    public String render() {
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        String formDefId = this.getPropertyString("formDefId");
        if (formDefId.isEmpty()) {
            return "";
        }
        Boolean hideEmptyValueField = "true".equalsIgnoreCase(this.getPropertyString("hideEmptyValueField"));
        Boolean showNotSelectedOptions = "true".equalsIgnoreCase(this.getPropertyString("showNotSelectedOptions"));
        String html = FormPdfUtil.getSelectedFormHtml((String)formDefId, (String)this.getPropertyString("recordId"), (AppDefinition)appDef, null, (Boolean)hideEmptyValueField);
        Pattern stylePattern = Pattern.compile("(?s)<style[^>]*>(.*?)</style>");
        Matcher styleMatcher = stylePattern.matcher(html);
        StringBuilder cssBuilder = new StringBuilder();
        while (styleMatcher.find()) {
            String cssContent = styleMatcher.group(1);
            cssBuilder.append(cssContent);
            Pattern builderPattern = Pattern.compile("(\\.builder-style-([\\d_]+)\\s*\\{([^}]*)\\})");
            Matcher builderMatcher = builderPattern.matcher(cssContent);
            if (builderMatcher.find()) {
                String fullClassName = ".builder-style-" + builderMatcher.group(2);
                String properties = builderMatcher.group(3);
                boolean hasFontSize = Pattern.compile("font-size\\s*:\\s*[^;]+;?").matcher(properties).find();
                boolean hasColor = Pattern.compile("(?<!-)\\bcolor\\s*:\\s*[^;]+;?").matcher(properties).find();
                boolean hasTextAlign = Pattern.compile("text-align\\s*:\\s*[^;]+;?").matcher(properties).find();
                if (hasFontSize && hasColor && hasTextAlign) continue;
                cssBuilder.append("\n").append(fullClassName).append("::after {clear: both; content: ''; display: block;}").append("\n").append(fullClassName).append(" > .label {");
                if (!hasFontSize) {
                    cssBuilder.append(" font-size: 13px;");
                }
                if (!hasColor) {
                    cssBuilder.append(" color: #000;");
                }
                if (!hasTextAlign) {
                    cssBuilder.append(" text-align: left;");
                }
                cssBuilder.append(" }");
                continue;
            }
            Pattern classPattern = Pattern.compile("\\.builder-style-(\\d+)");
            Matcher classMatcher = classPattern.matcher(cssContent);
            if (!classMatcher.find()) continue;
            String builderClassName = classMatcher.group(1);
            cssBuilder.append("\n").append(".builder-style-").append(builderClassName + "::after {clear: both; content: ''; display: block}").append("\n").append(".builder-style-").append(builderClassName + " > .label").append(" { font-size: 13px; color: #000; text-align: left;}");
        }
        this.formCss = cssBuilder.toString().replaceAll("\\bform(?=\\.)", "div");
        html = FormPdfUtil.cleanFormHtml((String)html, (Boolean)showNotSelectedOptions);
        return "<div class='form-container' id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\">" + html + "</div>";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        return "<style>" + FormPdfUtil.formPdfCss() + ".form-cell:not([class*=\"builder-style-\"]) > .label, .subform-cell:not([class*=\"builder-style-\"]) > .label {color:#000; text-align:left; font-size:13px} </style> " + this.render() + "<style> " + this.formCss + "</style>";
    }

    @Override
    public String getCSS() {
        return FormPdfUtil.formPdfCss() + ".form-cell:not([class*=\"builder-style-\"]) > .label, .subform-cell:not([class*=\"builder-style-\"]) > .label {color:#000; text-align:left; font-size:13px}" + this.formCss;
    }
}

