/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppService;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.apps.form.model.FormRow;
import org.joget.apps.form.model.FormRowSet;
import org.joget.apps.form.service.FileUtil;
import org.joget.plugin.base.DefaultApplicationPlugin;
import org.joget.rbuilder.ReportBuilder;
import org.joget.workflow.model.WorkflowAssignment;
import org.joget.workflow.model.WorkflowProcessLink;
import org.joget.workflow.model.service.WorkflowManager;
import org.springframework.context.ApplicationContext;

public class GenerateReportProcessTool
extends DefaultApplicationPlugin {
    protected ReportBuilder builder = null;

    public String getName() {
        return "GenerateReportProcessTool";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public Object execute(Map properties) {
        WorkflowManager workflowManager;
        WorkflowProcessLink link;
        ApplicationContext ac = AppUtil.getApplicationContext();
        AppService appService = (AppService)ac.getBean("appService");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        String formDefId = properties.get("formDefId").toString();
        String formUploadField = properties.get("formUploadField").toString();
        String fileName = properties.get("fileName").toString();
        String id = properties.get("recordId").toString();
        WorkflowAssignment ass = (WorkflowAssignment)properties.get("workflowAssignment");
        if (id.isEmpty() && ass != null && (link = (workflowManager = (WorkflowManager)AppUtil.getApplicationContext().getBean("workflowManager")).getWorkflowProcessLink(ass.getProcessId())) != null) {
            id = link.getOriginProcessId();
        }
        byte[] pdfFile = this.generetaPDF(properties);
        String tableName = appService.getFormTableName(appDef, formDefId);
        FormRowSet set = appService.loadFormData(appDef.getAppId(), appDef.getVersion().toString(), formDefId, id);
        FormRow row = (FormRow)set.get(0);
        if (!fileName.endsWith(".pdf")) {
            fileName = fileName + ".pdf";
        }
        String path = FileUtil.getUploadPath((String)tableName, (String)id);
        File file = new File(path + fileName);
        try {
            FileUtil.storeFile((File)file, (String)tableName, (String)tableName);
            FileUtils.writeByteArrayToFile((File)file, (byte[])pdfFile);
            row.put((Object)formUploadField, (Object)fileName);
            set.remove(0);
            set.add(0, (Object)row);
            appService.storeFormData(appDef.getAppId(), appDef.getVersion().toString(), formDefId, set, id);
        }
        catch (IOException ex) {
            Logger.getLogger(GenerateReportProcessTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    protected byte[] generetaPDF(Map properties) {
        String reportId = this.getPropertyString("reportId");
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(reportId, appDef);
        String id = properties.get("recordId").toString();
        WorkflowAssignment ass = (WorkflowAssignment)properties.get("workflowAssignment");
        if (id.isEmpty() && ass != null) {
            id = ass.getProcessId();
        } else {
            ass = new WorkflowAssignment();
            ass.setProcessId(id);
        }
        String json = "";
        HashMap<String, String> rparams = new HashMap<String, String>();
        rparams.put("id", id);
        Object[] fields = null;
        if (properties.get("reportParams") instanceof Object[]) {
            for (Object o : fields = (Object[])properties.get("reportParams")) {
                HashMap mapping = (HashMap)o;
                String param = mapping.get("param").toString();
                String value = (String)mapping.get("value");
                rparams.put(param, value);
            }
        }
        if (builderDefinition != null) {
            json = builderDefinition.getJson();
            json = AppUtil.processHashVariable((String)json, (WorkflowAssignment)ass, (String)"json", null);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("REPORT_PARAMS", rparams);
        return (byte[])this.getBuilder().getBuilderResult(json, config);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/properties/report/GenerateReportProcessTool.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    protected ReportBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = (ReportBuilder)CustomBuilderUtil.getBuilder((String)"report");
        }
        return this.builder;
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }
}

