/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    public String getName() {
        return "HtmlReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/HtmlReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-code\"></i>";
    }

    @Override
    public String render() {
        String validateHTML = this.validateHTML(false);
        return validateHTML;
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    protected String validateHTML(boolean print) {
        if (this.getPropertyString("html").isEmpty()) {
            return "";
        }
        try {
            String src = "<!DOCTYPE html [<!ENTITY nbsp \"&#160;\">]><div>" + this.getPropertyString("html") + "</div>";
            src = src.replace("&", "&amp;");
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.parse(new InputSource(new StringReader(src)));
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\">" + this.getPropertyString("html") + "</div>";
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            if (print) {
                return "<div style=\"color:red;\">" + ex.getLocalizedMessage() + "</div>";
            }
            LogUtil.error((String)this.getClassName(), (Throwable)ex, (String)"");
            return "";
        }
    }

    @Override
    public String preview() {
        String validateHTML = this.validateHTML(true);
        return validateHTML;
    }

    @Override
    public String getCSS() {
        String css = "";
        Pattern pattern = Pattern.compile("<style[^>]*>(.*?)</style>", 32);
        Matcher matcher = pattern.matcher(this.getPropertyString("html"));
        while (matcher.find()) {
            css = css + matcher.group(1);
        }
        return css;
    }
}

