/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import javax.servlet.http.HttpServletRequest;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;
import org.joget.workflow.util.WorkflowUtil;

public class ImageReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    public String getName() {
        return "ImageReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/ImageReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"far fa-image\"></i>";
    }

    @Override
    public String render() {
        String path = this.getPropertyString("path");
        if (path.startsWith("/")) {
            HttpServletRequest request = WorkflowUtil.getHttpServletRequest();
            path = this.getURL(request, path);
        }
        if (!path.isEmpty()) {
            String style = "";
            String margin = "";
            if (!this.getPropertyString("width").isEmpty()) {
                style = style + "width:" + this.getPropertyString("width") + ";";
            }
            if (!this.getPropertyString("height").isEmpty()) {
                style = style + "height:" + this.getPropertyString("height") + ";";
            }
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                margin = margin + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\" style=\"text-align:" + this.getPropertyString("halign") + ";" + margin + "\"><img style=\"" + style + "\" src=\"" + StringUtil.escapeString((String)path, (String)"xml", null) + "\" /></div>";
        }
        return "";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        return this.render();
    }

    @Override
    public String getCSS() {
        return "";
    }

    protected String getURL(HttpServletRequest req, String link) {
        String scheme = req.getScheme();
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        if (link != null) {
            url.append(link);
        }
        return url.toString();
    }
}

