/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joget.apps.app.dao.DatalistDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.DatalistDefinition;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataList;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.model.DataListColumn;
import org.joget.apps.datalist.model.DataListColumnFormat;
import org.joget.apps.datalist.model.DataListFilter;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;
import org.joget.workflow.util.WorkflowUtil;
import org.json.JSONArray;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ListReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement,
PluginWebSupport {
    private DataList cachedDataList = null;
    private DataListCollection cachedDataListData = null;
    private int colSize = 0;
    private boolean hasFormulaColumns = false;
    private boolean hasAutomatedNumber = false;
    private boolean hasFooter = false;
    private boolean hasFormatter = false;
    private Collection<DataListColumnFormat> nestedListFormatter = new ArrayList<DataListColumnFormat>();
    private Map<String, Object> footers = new HashMap<String, Object>();

    public String getName() {
        return "ListReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/ListReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-table\"></i>";
    }

    @Override
    public String render() {
        if (this.getPropertyString("datalistId").isEmpty() || this.getDataList() == null) {
            return "";
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("element", this);
        model.put("dataList", this.getDataList());
        model.put("rows", this.getDataListData());
        model.put("repeatFooterRowEveryPage", this.getPropertyString("repeatFooterRowEveryPage"));
        PluginManager pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager");
        String content = pluginManager.getPluginFreeMarkerTemplate(model, this.getClass().getName(), "/templates/listReportElement.ftl", "messages/ReportElements");
        return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\">" + content + "</div>";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        this.setProperty("elementPreview", "true");
        return this.render();
    }

    @Override
    public String getCSS() {
        return "";
    }

    public boolean hasFooter() {
        return this.hasFooter;
    }

    protected DataList getDataList() {
        if (this.cachedDataList == null) {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            DataListService dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService");
            DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
            DatalistDefinition datalistDefinition = (DatalistDefinition)datalistDefinitionDao.loadById(this.getPropertyString("datalistId"), appDef);
            if (datalistDefinition != null) {
                ArrayList<DataListColumn> columns = new ArrayList<DataListColumn>();
                if ("true".equals(this.getPropertyString("automatedNum"))) {
                    this.hasAutomatedNumber = true;
                    DataListColumn[] props = new HashMap();
                    props.put("headerAlignment", "dataListAlignLeft");
                    props.put("alignment", "dataListAlignLeft");
                    DataListColumn NumberingColumn = new DataListColumn("numberingColumn", "No", false);
                    NumberingColumn.setProperties((Map)props);
                    NumberingColumn.setWidth("25px");
                    columns.add(NumberingColumn);
                    ++this.colSize;
                }
                this.cachedDataList = dataListService.fromJson(datalistDefinition.getJson());
                if (this.cachedDataList.getColumns().length > 0) {
                    for (DataListColumn dataListColumn : this.cachedDataList.getColumns()) {
                        if (!ListReportElement.isVisible(dataListColumn)) continue;
                        columns.add(dataListColumn);
                    }
                }
                this.cachedDataList.setColumns(columns.toArray(new DataListColumn[columns.size()]));
                Object footers = this.getProperty("footer");
                HashMap<String, Map> footerMap = new HashMap<String, Map>();
                if (footers != null && footers instanceof Object[] && ((Object[])footers).length > 0) {
                    Object[] objectArray = (Object[])footers;
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        Object footer = objectArray[i];
                        Map fMap = (Map)footer;
                        footerMap.put((String)fMap.get("fieldid"), fMap);
                    }
                }
                for (DataListColumn c : this.cachedDataList.getColumns()) {
                    DataListColumnFormat format;
                    if (!ListReportElement.isVisible(c)) continue;
                    if (footerMap.containsKey(c.getName())) {
                        this.hasFooter = true;
                        c.setProperty("footer", (Object)((Map)footerMap.get(c.getName())).get("operator").toString());
                        c.setProperty("numberFormat", (Object)((Map)footerMap.get(c.getName())).get("numberFormat").toString());
                        c.setProperty("footerlabel", (Object)((Map)footerMap.get(c.getName())).get("footerlabel").toString());
                    }
                    if (c.getFormats() != null && !c.getFormats().isEmpty() && (format = (DataListColumnFormat)c.getFormats().iterator().next()) != null) {
                        this.hasFormatter = true;
                        if ("org.joget.plugin.enterprise.NestedDatalistFormatter".equalsIgnoreCase(format.getClassName()) && format.getPropertyString("exportOptions").contains("pdf")) {
                            this.nestedListFormatter.add(format);
                        }
                    }
                    ++this.colSize;
                }
                Object formulaColumns = this.getProperty("formulaColumns");
                if (formulaColumns != null && formulaColumns instanceof Object[] && ((Object[])formulaColumns).length > 0) {
                    this.hasFormulaColumns = true;
                    ArrayList<DataListColumn> arrayList = new ArrayList<DataListColumn>();
                    arrayList.addAll(Arrays.asList(this.cachedDataList.getColumns()));
                    int c = 0;
                    for (Object fc : (Object[])formulaColumns) {
                        Map fcMap = (Map)fc;
                        DataListColumn formulaColumn = new DataListColumn("formulaColumn-" + c, fcMap.get("label").toString(), false);
                        formulaColumn.setProperties(fcMap);
                        formulaColumn.setWidth(fcMap.get("width").toString());
                        if (!fcMap.get("footer").toString().isEmpty()) {
                            this.hasFooter = true;
                        }
                        arrayList.add(formulaColumn);
                        ++c;
                        ++this.colSize;
                    }
                    this.cachedDataList.setColumns(arrayList.toArray(new DataListColumn[0]));
                }
            }
        }
        return this.cachedDataList;
    }

    protected DataListCollection getDataListData() {
        if (this.cachedDataListData == null) {
            boolean isPreview = false;
            if ("true".equals(this.getPropertyString("elementPreview"))) {
                this.cachedDataListData = this.getDataList().getRows(Integer.valueOf(3), null);
                isPreview = true;
            } else {
                Object filterParamsProperty = this.getProperty("filterParams");
                if (filterParamsProperty != null && filterParamsProperty instanceof Object[] && ((Object[])filterParamsProperty).length > 0) {
                    HashMap<String, String[]> params = this.getDataList().getRequestParamMap();
                    if (params == null) {
                        params = new HashMap<String, String[]>();
                    }
                    for (Object param : (Object[])filterParamsProperty) {
                        Map paramMap = (Map)param;
                        String key = paramMap.get("param").toString();
                        if (params.containsKey(key)) {
                            ArrayList<Object> temp = new ArrayList<Object>(Arrays.asList((Object[])params.get(key)));
                            temp.add(paramMap.get("value").toString());
                            params.put(key, temp.toArray(new String[0]));
                            continue;
                        }
                        params.put(key, new String[]{paramMap.get("value").toString()});
                    }
                    this.getDataList().setRequestParamMap(params);
                }
                this.cachedDataListData = this.getDataList().getRows(Integer.valueOf(this.getDataList().getTotal()), Integer.valueOf(0));
            }
            this.cachedDataListData = this.preparedataListCollection(this.getDataList(), this.cachedDataListData, isPreview);
        }
        return this.cachedDataListData;
    }

    public DataListCollection preparedataListCollection(DataList dataList, DataListCollection data, boolean isPreview) {
        if (dataList != null && !data.isEmpty()) {
            if (this.hasFormatter || this.hasFormulaColumns || this.hasFooter || this.hasAutomatedNumber) {
                DataListCollection newData = new DataListCollection();
                Object value = null;
                HashMap<String, Object> newRow = null;
                int rowCount = 0;
                for (Object row : data) {
                    newRow = new HashMap<String, Object>();
                    for (DataListColumn c : dataList.getColumns()) {
                        if (!ListReportElement.isVisible(c)) continue;
                        value = DataListService.evaluateColumnValueFromRow(row, (String)c.getName());
                        if (c.getFormats() != null && !c.getFormats().isEmpty()) {
                            for (DataListColumnFormat f : c.getFormats()) {
                                if (f == null) continue;
                                value = f.format(dataList, c, row, value);
                                Pattern patternInput = Pattern.compile("<span class=\"nesteddl_trigger\"[^>]*>(.*?)<\\/span>");
                                Matcher matcherInput = patternInput.matcher(value.toString());
                                if (!matcherInput.find()) continue;
                                value = matcherInput.group(1);
                            }
                        } else {
                            value = c.getName().equalsIgnoreCase("numberingColumn") ? Integer.valueOf(++rowCount) : this.getFormulaValue(value, c, row);
                        }
                        this.calculateFooter(c, value);
                        if (value != null && value instanceof String) {
                            value = StringUtil.stripHtmlRelaxed((String)value.toString());
                        }
                        newRow.put(c.getName(), value);
                        newRow.put(c.getPropertyString("id"), value);
                    }
                    newData.add(newRow);
                }
                data = newData;
            }
        } else if (dataList != null && data.isEmpty() && isPreview) {
            DataListCollection newData = new DataListCollection();
            HashMap<String, String> newRow = new HashMap<String, String>();
            for (DataListColumn c : dataList.getColumns()) {
                if (!ListReportElement.isVisible(c)) continue;
                newRow.put(c.getName(), "");
            }
            newData.add(newRow);
            newData.add(newRow);
            newData.add(newRow);
            data = newData;
        }
        return data;
    }

    public static boolean isVisible(DataListColumn c) {
        return c.isHidden() && "true".equalsIgnoreCase(c.getPropertyString("include_export")) || !c.isHidden() && !"true".equalsIgnoreCase(c.getPropertyString("exclude_export"));
    }

    public String getHeaderStyle() {
        String css = "";
        if (!this.getPropertyString("headerColor").isEmpty()) {
            css = css + "background:" + this.getPropertyString("headerColor") + ";";
        }
        if (!this.getPropertyString("headerTextColor").isEmpty()) {
            css = css + "color:" + this.getPropertyString("headerTextColor") + ";";
        }
        return css;
    }

    public String getRowExtra(Object row) {
        String html = "";
        if (!this.nestedListFormatter.isEmpty()) {
            for (DataListColumnFormat f : this.nestedListFormatter) {
                Object requestParamsProperty;
                ListReportElement nl = new ListReportElement();
                nl.setProperty("datalistId", f.getPropertyString("listId"));
                if ("true".equalsIgnoreCase(f.getPropertyString("customHeaderColor"))) {
                    nl.setProperty("headerColor", f.getPropertyString("headerColor"));
                    nl.setProperty("headerTextColor", f.getPropertyString("headerFontColor"));
                }
                if ((requestParamsProperty = f.getProperty("requestParams")) != null && requestParamsProperty instanceof Object[]) {
                    ArrayList<Map> filters = new ArrayList<Map>();
                    for (Object param : (Object[])requestParamsProperty) {
                        Map paramMap;
                        Object tempValue = DataListService.evaluateColumnValueFromRow((Object)row, (String)(paramMap = (Map)param).get("hrefColumn").toString());
                        paramMap.put("value", tempValue != null ? tempValue.toString() : paramMap.get("defaultValue").toString());
                        filters.add(paramMap);
                    }
                    nl.setProperty("filterParams", filters.toArray(new Object[0]));
                }
                nl.setProperty("IS_PREVIEW", false);
                html = html + "<tr style=\"padding:2px 0px 5px;\"><td colspan=\"" + this.colSize + "\">" + nl.render() + "</td></tr>";
            }
        }
        return html;
    }

    public String getFooter(DataListColumn c) {
        Object postfix;
        Object prefix;
        Object value = null;
        String footerlabel = null;
        String type = c.getPropertyString("footer");
        if (!type.isEmpty()) {
            switch (type) {
                case "DistinctCount": {
                    HashSet distinct = (HashSet)this.footers.get(c.getName() + ":distinct");
                    if (distinct != null) {
                        value = distinct.size();
                        break;
                    }
                    value = 0;
                    break;
                }
                case "First": {
                    value = this.footers.get(c.getName() + ":first");
                    break;
                }
                case "Highest": {
                    value = this.footers.get(c.getName() + ":max");
                    break;
                }
                case "Lowest": {
                    value = this.footers.get(c.getName() + ":min");
                    break;
                }
                case "Sum": {
                    value = this.footers.get(c.getName() + ":sum");
                    break;
                }
                case "Average": {
                    double count = (Double)this.footers.get(c.getName() + ":count");
                    if (count > 0.0) {
                        value = (Double)this.footers.get(c.getName() + ":sum") / count;
                        break;
                    }
                    value = 0;
                    break;
                }
                case "Count": {
                    value = this.footers.get(c.getName() + ":count");
                    break;
                }
                case "Variance": 
                case "StandardDeviation": {
                    double sum = (Double)this.footers.get(c.getName() + ":sum");
                    double count2 = (Double)this.footers.get(c.getName() + ":count");
                    double squares = (Double)this.footers.get(c.getName() + ":squares");
                    if (count2 > 1.0) {
                        value = (squares - sum * sum / count2) / (count2 - 1.0);
                        if (!"StandardDeviation".equals(type)) break;
                        value = Math.sqrt((Double)value);
                        break;
                    }
                    value = 0;
                }
            }
        }
        if (value != null && !c.getPropertyString("numberFormat").isEmpty()) {
            value = this.formatNumber(value.toString(), c.getPropertyString("numberFormat"));
        }
        if (value == null) {
            value = "";
        }
        if ((prefix = this.footers.get(c.getName() + ":prefix")) != null && !prefix.toString().isEmpty()) {
            String negativeBeforePrefix = (String)this.footers.get(c.getName() + ":negativeBeforePrefix");
            String strValue = value.toString();
            value = negativeBeforePrefix != null && strValue.startsWith("-") ? strValue.substring(0, 1) + prefix.toString() + strValue.substring(1) : prefix.toString() + strValue;
        }
        if ((postfix = this.footers.get(c.getName() + ":postfix")) != null && !postfix.toString().isEmpty()) {
            value = value + postfix.toString();
        }
        footerlabel = !c.getPropertyString("footerlabel").isEmpty() ? c.getPropertyString("footerlabel") + ":" : "";
        return StringUtil.escapeString((String)(footerlabel + value.toString()), (String)"html", null);
    }

    protected void calculateFooter(DataListColumn c, Object value) {
        String type = c.getPropertyString("footer");
        if (!type.isEmpty()) {
            value = this.removePrefixPostfix(c, value.toString());
            value = this.removeThousandSeparator(c, value.toString());
            double num = 0.0;
            if (!(value instanceof Number)) {
                try {
                    num = Double.parseDouble(value.toString());
                }
                catch (Exception exception) {}
            } else {
                num = (Double)value;
            }
            switch (type) {
                case "DistinctCount": {
                    HashSet distinct = null;
                    distinct = !this.footers.containsKey(c.getName() + ":distinct") ? new HashSet() : (HashSet)this.footers.get(c.getName() + ":distinct");
                    distinct.add(value);
                    this.footers.put(c.getName() + ":distinct", distinct);
                    break;
                }
                case "First": {
                    if (this.footers.containsKey(c.getName() + ":first")) break;
                    this.footers.put(c.getName() + ":first", value);
                    break;
                }
                case "Highest": {
                    double max = Double.MIN_VALUE;
                    if (this.footers.containsKey(c.getName() + ":max")) {
                        max = (Double)this.footers.get(c.getName() + ":max");
                    }
                    if (!(num > max)) break;
                    this.footers.put(c.getName() + ":max", num);
                    break;
                }
                case "Lowest": {
                    double min = Double.MAX_VALUE;
                    if (this.footers.containsKey(c.getName() + ":min")) {
                        min = (Double)this.footers.get(c.getName() + ":min");
                    }
                    if (!(num < min)) break;
                    this.footers.put(c.getName() + ":min", num);
                    break;
                }
                case "Sum": 
                case "Average": 
                case "Count": 
                case "StandardDeviation": 
                case "Variance": {
                    double sum = 0.0;
                    double count = 0.0;
                    double squares = 0.0;
                    if (this.footers.containsKey(c.getName() + ":sum")) {
                        sum = (Double)this.footers.get(c.getName() + ":sum");
                        count = (Double)this.footers.get(c.getName() + ":count");
                        squares = (Double)this.footers.get(c.getName() + ":squares");
                    }
                    this.footers.put(c.getName() + ":sum", sum += num);
                    this.footers.put(c.getName() + ":count", count += 1.0);
                    this.footers.put(c.getName() + ":squares", squares += num * num);
                }
            }
        }
    }

    protected Object getFormulaValue(Object value, DataListColumn c, Object row) {
        if (!c.getPropertyString("formula").isEmpty()) {
            value = this.formatValue(c.getPropertyString("formula"), row);
            if (!c.getPropertyString("numberFormat").isEmpty()) {
                value = this.formatNumber(value.toString(), c.getPropertyString("numberFormat"));
            }
        }
        return value;
    }

    protected String formatNumber(String value, String format) {
        if (value == null) {
            value = "0";
        }
        try {
            DecimalFormat decimalFormat;
            if (format.matches("([0#]\\.[0#]{2,})*0(,0+)$")) {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator(',');
                symbols.setGroupingSeparator('.');
                int decimalPlaces = format.length() - format.indexOf(44) - 1;
                String customFormat = "#,##0." + "0".repeat(decimalPlaces);
                decimalFormat = new DecimalFormat(customFormat, symbols);
            } else {
                decimalFormat = new DecimalFormat(format);
            }
            return decimalFormat.format(Double.parseDouble(value));
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
            return value;
        }
    }

    protected String formatValue(String format, Object row) {
        HashMap variables = new HashMap();
        Object result = this.evaluateExpression(format = this.prepareExpression(format, row, variables), variables);
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    protected String prepareExpression(String expr, Object row, Map variables) {
        Pattern pattern = Pattern.compile("\\{([a-zA-Z0-9_\\.]+)\\}");
        Matcher matcher = pattern.matcher(expr);
        while (matcher.find()) {
            String key = matcher.group(1);
            Object value = DataListService.evaluateColumnValueFromRow((Object)row, (String)key);
            if (value == null) continue;
            String newKey = key.replaceAll(StringUtil.escapeRegex((String)"."), "__");
            if (value instanceof String) {
                try {
                    value = Double.parseDouble(value.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            variables.put(newKey, value);
            expr = expr.replaceAll(StringUtil.escapeRegex((String)("{" + key + "}")), newKey);
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateExpression(String expr, Map variables) {
        Context cx = Context.enter();
        Scriptable scope = cx.initStandardObjects(null);
        try {
            Object eval;
            this.prepareContext(scope, variables);
            Object object = eval = cx.evaluateString(scope, expr, "", 1, null);
            return object;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)expr);
        }
        finally {
            Context.exit();
        }
        return null;
    }

    protected void prepareContext(Scriptable scope, Map variables) throws Exception {
        for (Map.Entry me : variables.entrySet()) {
            String key = me.getKey().toString();
            Object value = me.getValue();
            scope.put(key, scope, value);
        }
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isAdmin = WorkflowUtil.isCurrentUserInRole((String)"ROLE_ADMIN");
        if (!isAdmin) {
            response.sendError(401);
            return;
        }
        String action = request.getParameter("action");
        if ("events".equals(action)) {
            DataListService dataListService;
            DataList dataList;
            DataListFilter[] tempfilterList;
            JSONArray jsonArray = new JSONArray();
            String datalistId = request.getParameter("datalistId");
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            DatalistDefinitionDao datalistDefinitionDao = (DatalistDefinitionDao)AppUtil.getApplicationContext().getBean("datalistDefinitionDao");
            DatalistDefinition datalist = (DatalistDefinition)datalistDefinitionDao.loadById(datalistId, appDef);
            if (datalist != null && (tempfilterList = (dataList = (dataListService = (DataListService)AppUtil.getApplicationContext().getBean("dataListService")).fromJson(AppUtil.processHashVariable((String)datalist.getJson(), null, null, null))).getFilters()) != null) {
                for (DataListFilter filterList : tempfilterList) {
                    String value = filterList.getName();
                    String filterParam = dataList.getDataListEncodedParamName("fn_" + value);
                    HashMap<String, String> option = new HashMap<String, String>();
                    option.put("value", filterParam);
                    option.put("label", filterParam);
                    jsonArray.put(option);
                }
            }
            try {
                jsonArray.write((Writer)response.getWriter());
            }
            catch (Exception e) {
                LogUtil.error((String)this.getClassName(), (Throwable)e, (String)action);
                response.sendError(500);
            }
        }
    }

    public String removePrefixPostfix(DataListColumn column, String value) {
        String postfix;
        String negativeBeforePrefix;
        String prefix = (String)this.footers.get(column.getName() + ":prefix");
        if (prefix == null) {
            int prefixStart = 0;
            int prefixEnd = 0;
            boolean hasPrefix = false;
            while (prefixEnd < value.length() && !Character.isDigit(value.charAt(prefixEnd))) {
                char c = value.charAt(prefixEnd);
                if (c == '-' && prefixEnd == 0 && prefixEnd == 0) {
                    prefixEnd = ++prefixStart;
                    continue;
                }
                if (c == '-') break;
                hasPrefix = true;
                ++prefixEnd;
            }
            if (hasPrefix && prefixEnd > 0) {
                prefix = value.substring(prefixStart, prefixEnd);
                if (prefixStart > 0) {
                    this.footers.put(column.getName() + ":negativeBeforePrefix", "true");
                }
            } else {
                prefix = "";
            }
            this.footers.put(column.getName() + ":prefix", prefix);
        }
        if ((negativeBeforePrefix = (String)this.footers.get(column.getName() + ":negativeBeforePrefix")) == null && value.startsWith("-")) {
            this.footers.put(column.getName() + ":negativeBeforePrefix", "true");
        }
        if (!prefix.isEmpty()) {
            value = value.replaceAll(StringUtil.escapeRegex((String)prefix), "");
        }
        if ((postfix = (String)this.footers.get(column.getName() + ":postfix")) == null) {
            int postfixStart;
            boolean hasPostfix = false;
            for (postfixStart = value.length() - 1; postfixStart > 0 && !Character.isDigit(value.charAt(postfixStart)); --postfixStart) {
                hasPostfix = true;
            }
            postfix = hasPostfix ? value.substring(postfixStart + 1) : "";
            this.footers.put(column.getName() + ":postfix", postfix);
        }
        if (!postfix.isEmpty()) {
            value = value.replaceAll(StringUtil.escapeRegex((String)postfix), "");
        }
        return value;
    }

    public String removeThousandSeparator(DataListColumn column, String value) {
        String usPattern = ".*,(?=[\\d,]*\\.\\d{2}\\b).*";
        String euPattern = ".*\\.(?=[\\d.]*\\,\\d{2}\\b).*";
        String format = null;
        if (value.matches(usPattern)) {
            format = "US";
        } else if (value.matches(euPattern)) {
            format = "EURO";
        }
        if (format != null) {
            String decimalSeperator = ".";
            String thousandSeparator = ",";
            if ("EURO".equalsIgnoreCase(format)) {
                decimalSeperator = ",";
                thousandSeparator = ".";
            }
            value = value.replaceAll(StringUtil.escapeRegex((String)thousandSeparator), "");
            value = value.replaceAll(StringUtil.escapeRegex((String)decimalSeperator), ".");
        }
        return value;
    }
}

