/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.util.HashMap;
import java.util.Map;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.datalist.model.DataListBinder;
import org.joget.apps.datalist.model.DataListCollection;
import org.joget.apps.datalist.model.DataListFilterQueryObject;
import org.joget.apps.datalist.service.DataListService;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.base.PluginManager;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;

public class MapReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    private DataListCollection cachedData = null;

    public String getName() {
        return "MapReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/MapReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-map-marked-alt\"></i>";
    }

    @Override
    public String render() {
        if (this.getPropertyString("latitude").isEmpty() || this.getPropertyString("longitude").isEmpty() || this.getPropertyString("apikey").isEmpty()) {
            return "";
        }
        int width = 640;
        int height = 480;
        try {
            if (!this.getPropertyString("width").isEmpty()) {
                width = Integer.parseInt(this.getPropertyString("width"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!this.getPropertyString("height").isEmpty()) {
                height = Integer.parseInt(this.getPropertyString("height"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String url = "https://maps.googleapis.com/maps/api/staticmap";
        url = url + "?center=" + this.getPropertyString("latitude") + "," + this.getPropertyString("longitude") + "&size=" + width + "x" + height;
        if (!this.getPropertyString("type").isEmpty()) {
            url = url + "&maptype=" + this.getPropertyString("type");
        }
        if (!this.getPropertyString("zoom").isEmpty()) {
            url = url + "&zoom=" + this.getPropertyString("zoom");
        }
        if (!this.getPropertyString("apikey").isEmpty()) {
            url = url + "&key=" + this.getPropertyString("apikey");
        }
        if ("static".equalsIgnoreCase(this.getPropertyString("markersType"))) {
            Object[] markers = (Object[])this.getProperty("markers");
            if (markers != null && markers.length > 0) {
                HashMap marker = null;
                String color = null;
                String label = null;
                for (Object o : markers) {
                    marker = (HashMap)o;
                    color = "red";
                    label = "";
                    if (!marker.get("color").toString().isEmpty()) {
                        color = marker.get("color").toString();
                    }
                    if (!marker.get("label").toString().isEmpty() && marker.get("label").toString() != null) {
                        label = marker.get("label").toString();
                        label = label.substring(0, 1).toUpperCase();
                    } else {
                        label = "";
                    }
                    url = url + "&markers=color:" + color + "%7Clabel:" + StringUtil.escapeString((String)label, (String)"url", null) + "%7C" + marker.get("latitude").toString() + "," + marker.get("longitude").toString();
                }
            }
        } else if ("binder".equalsIgnoreCase(this.getPropertyString("markersType"))) {
            DataListCollection data = this.getData();
            String color = null;
            String label = null;
            String latitude = null;
            String longitude = null;
            for (Object row : data) {
                color = "red";
                label = "";
                latitude = "";
                longitude = "";
                if (!this.getPropertyString("mapping_color").isEmpty()) {
                    color = DataListService.evaluateColumnValueFromRow(row, (String)this.getPropertyString("mapping_color")).toString();
                    color = color != null ? color.toLowerCase() : "red";
                }
                if (!this.getPropertyString("mapping_label").isEmpty()) {
                    label = DataListService.evaluateColumnValueFromRow(row, (String)this.getPropertyString("mapping_label")).toString();
                    label = label != null && !label.isEmpty() ? label.substring(0, 1).toUpperCase() : "";
                }
                if (!this.getPropertyString("mapping_latitude").isEmpty() && (latitude = DataListService.evaluateColumnValueFromRow(row, (String)this.getPropertyString("mapping_latitude")).toString()) == null) {
                    latitude = "";
                }
                if (!this.getPropertyString("mapping_longitude").isEmpty() && (longitude = DataListService.evaluateColumnValueFromRow(row, (String)this.getPropertyString("mapping_longitude")).toString()) == null) {
                    longitude = "";
                }
                if (latitude.isEmpty() || longitude.isEmpty()) continue;
                url = url + "&markers=color:" + color + "%7Clabel:" + StringUtil.escapeString((String)label, (String)"url", null) + "%7C" + latitude + "," + longitude;
            }
        }
        if (url != null) {
            String style = "";
            String margin = "";
            if (!this.getPropertyString("width").isEmpty()) {
                style = style + "width:" + this.getPropertyString("width") + ";";
            }
            if (!this.getPropertyString("height").isEmpty()) {
                style = style + "height:" + this.getPropertyString("height") + ";";
            }
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                margin = margin + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\" style=\"text-align:" + this.getPropertyString("halign") + ";" + margin + "\"><img style=\"" + style + "\" src=\"" + StringUtil.escapeString((String)url, (String)"xml", null) + "\" /></div>";
        }
        return "";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        return this.render();
    }

    @Override
    public String getCSS() {
        return "";
    }

    protected DataListCollection getData() {
        PluginManager pluginManager;
        DataListBinder binder;
        Map bdMap;
        Object binderData;
        if (this.cachedData == null && (binderData = this.getProperty("binder")) != null && binderData instanceof Map && (bdMap = (Map)binderData) != null && bdMap.containsKey("className") && !bdMap.get("className").toString().isEmpty() && (binder = (DataListBinder)(pluginManager = (PluginManager)AppUtil.getApplicationContext().getBean("pluginManager")).getPlugin(bdMap.get("className").toString())) != null) {
            Map bdProps = (Map)bdMap.get("properties");
            binder.setProperties(bdProps);
            this.cachedData = binder.getData(null, bdProps, new DataListFilterQueryObject[0], null, null, null, null);
        }
        return this.cachedData;
    }
}

