/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import javax.imageio.ImageIO;
import net.glxn.qrgen.core.scheme.Bookmark;
import net.glxn.qrgen.core.scheme.EMail;
import net.glxn.qrgen.core.scheme.GeoInfo;
import net.glxn.qrgen.core.scheme.Girocode;
import net.glxn.qrgen.core.scheme.GooglePlay;
import net.glxn.qrgen.core.scheme.KddiAu;
import net.glxn.qrgen.core.scheme.MMS;
import net.glxn.qrgen.core.scheme.MeCard;
import net.glxn.qrgen.core.scheme.Schema;
import net.glxn.qrgen.core.scheme.Telephone;
import net.glxn.qrgen.core.scheme.Url;
import net.glxn.qrgen.core.scheme.VCard;
import net.glxn.qrgen.core.scheme.Wifi;
import net.glxn.qrgen.core.scheme.YouTube;
import net.glxn.qrgen.javase.QRCode;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.commons.util.LogUtil;
import org.joget.plugin.base.ExtDefaultPlugin;
import org.joget.plugin.property.model.PropertyEditable;
import org.joget.rbuilder.api.ReportElement;

public class QRcodeReportElement
extends ExtDefaultPlugin
implements PropertyEditable,
ReportElement {
    public String getName() {
        return "QRcodeReportElement";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    @Override
    public String getClassName() {
        return this.getClass().getName();
    }

    @Override
    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)this.getClass().getName(), (String)"/properties/report/QRcodeReportElement.json", null, (boolean)true, (String)"messages/ReportElements");
    }

    @Override
    public String getIcon() {
        return "<i class=\"fas fa-qrcode\"></i>";
    }

    @Override
    public String render() {
        if (this.getPropertyString("url").isEmpty()) {
            return "";
        }
        int height = 150;
        this.setProperty("heightInt", height);
        String image = this.getBase64QRCode();
        if (image != null) {
            String style = "";
            String margin = "";
            if (!this.getPropertyString("height").isEmpty()) {
                style = style + "width:" + this.getPropertyString("height") + ";height:" + this.getPropertyString("height") + ";";
            }
            if (!this.getPropertyString("marginBottom").isEmpty()) {
                margin = margin + "margin-bottom:" + this.getPropertyString("marginBottom") + ";";
            }
            return "<div id=\"e_" + this.getPropertyString("id") + "\" class=\"" + this.getPropertyString("selectorClass") + "\" style=\"text-align:" + this.getPropertyString("halign") + ";" + margin + "\"><img style=\"" + style + "\" src=\"data:image/jpeg;base64," + image + "\" /></div>";
        }
        return "";
    }

    @Override
    public boolean supportReportContainer() {
        return true;
    }

    @Override
    public String preview() {
        return this.render();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBase64QRCode() {
        boolean imageIoCache = ImageIO.getUseCache();
        try {
            ImageIO.setUseCache(false);
            BufferedImage image = ImageIO.read(this.getQRCodeStream());
            String imageString = null;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                ImageIO.write((RenderedImage)image, "jpeg", bos);
                byte[] imageBytes = bos.toByteArray();
                byte[] encodedBytes = Base64.getEncoder().encode(imageBytes);
                imageString = new String(encodedBytes, "UTF-8");
            }
            String string = imageString;
            return string;
        }
        catch (Exception e) {
            LogUtil.error((String)this.getClassName(), (Throwable)e, (String)"");
        }
        finally {
            ImageIO.setUseCache(imageIoCache);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getQRCodeStream() {
        ByteArrayInputStream input = null;
        QRCode qrCode = null;
        ByteArrayOutputStream output = null;
        EMail schema = null;
        boolean imageIoCache = ImageIO.getUseCache();
        try {
            ImageIO.setUseCache(false);
            String rawSchema = null;
            if ("Bookmark".equalsIgnoreCase(this.getPropertyString("type"))) {
                Bookmark bookmark = new Bookmark();
                bookmark.setUrl(this.getPropertyString("url"));
                bookmark.setTitel(this.getPropertyString("title").isEmpty() ? null : this.getPropertyString("title"));
                schema = bookmark;
            } else if ("Email".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new EMail(this.getPropertyString("email"));
            } else if ("GeoInfo".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new GeoInfo();
                ArrayList<String> points = new ArrayList<String>();
                points.add(this.getPropertyString("latitude"));
                points.add(this.getPropertyString("longitude"));
                ((GeoInfo)schema).setPoints(points);
            } else if ("Girocode".equalsIgnoreCase(this.getPropertyString("type"))) {
                Girocode girocode = new Girocode();
                girocode.setEncoding(Girocode.Encoding.UTF_8);
                girocode.setBic(this.getPropertyString("bic"));
                girocode.setName(this.getPropertyString("name"));
                girocode.setIban(this.getPropertyString("iban"));
                girocode.setAmount(this.getPropertyString("amount"));
                girocode.setPurposeCode(this.getPropertyString("purposeCode"));
                girocode.setReference(this.getPropertyString("reference"));
                girocode.setHint(this.getPropertyString("hint"));
                schema = girocode;
            } else if ("GooglePlay".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new GooglePlay();
                ((GooglePlay)schema).setAppPackage(this.getPropertyString("value"));
            } else if ("KddiAu".equalsIgnoreCase(this.getPropertyString("type"))) {
                KddiAu kddiAu = new KddiAu();
                kddiAu.setName1(this.getPropertyString("name"));
                kddiAu.setName2(this.getPropertyString("name2").isEmpty() ? null : this.getPropertyString("name2"));
                kddiAu.setAddress(this.getPropertyString("address").isEmpty() ? null : this.getPropertyString("address"));
                kddiAu.setEmail1(this.getPropertyString("email1").isEmpty() ? null : this.getPropertyString("email1"));
                kddiAu.setEmail2(this.getPropertyString("email2").isEmpty() ? null : this.getPropertyString("email2"));
                kddiAu.setEmail3(this.getPropertyString("email3").isEmpty() ? null : this.getPropertyString("email3"));
                kddiAu.setTelephone1(this.getPropertyString("telephone1").isEmpty() ? null : this.getPropertyString("telephone1"));
                kddiAu.setTelephone2(this.getPropertyString("telephone2").isEmpty() ? null : this.getPropertyString("telephone2"));
                kddiAu.setTelephone3(this.getPropertyString("telephone3").isEmpty() ? null : this.getPropertyString("telephone3"));
                schema = kddiAu;
            } else if ("MMS".equalsIgnoreCase(this.getPropertyString("type"))) {
                MMS mms = new MMS();
                mms.setNumber(this.getPropertyString("number"));
                mms.setSubject(this.getPropertyString("subject").isEmpty() ? null : this.getPropertyString("subject"));
                schema = mms;
            } else if ("MeCard".equalsIgnoreCase(this.getPropertyString("type"))) {
                MeCard meCard = new MeCard();
                meCard.setName(this.getPropertyString("name"));
                meCard.setAddress(this.getPropertyString("address").isEmpty() ? null : this.getPropertyString("address"));
                meCard.setTelephone(this.getPropertyString("telephone1").isEmpty() ? null : this.getPropertyString("telephone1"));
                meCard.setEmail(this.getPropertyString("email1").isEmpty() ? null : this.getPropertyString("email1"));
                schema = meCard;
            } else if ("SMS".equalsIgnoreCase(this.getPropertyString("type"))) {
                rawSchema = "SMSTO:" + this.getPropertyString("number") + ":" + this.getPropertyString("subject");
            } else if ("Telephone".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new Telephone();
                ((Telephone)schema).setTelephone(this.getPropertyString("telephone"));
            } else if ("Url".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new Url();
                ((Url)schema).setUrl(this.getPropertyString("url"));
            } else if ("VCard".equalsIgnoreCase(this.getPropertyString("type"))) {
                VCard vcard = new VCard();
                vcard.setName(this.getPropertyString("name"));
                vcard.setAddress(this.getPropertyString("address").isEmpty() ? null : this.getPropertyString("address"));
                vcard.setCompany(this.getPropertyString("company").isEmpty() ? null : this.getPropertyString("company"));
                vcard.setEmail(this.getPropertyString("email1").isEmpty() ? null : this.getPropertyString("email1"));
                vcard.setTitle(this.getPropertyString("title").isEmpty() ? null : this.getPropertyString("title"));
                vcard.setWebsite(this.getPropertyString("website").isEmpty() ? null : this.getPropertyString("website"));
                vcard.setPhoneNumber(this.getPropertyString("telephone1").isEmpty() ? null : this.getPropertyString("telephone1"));
                vcard.setNote(this.getPropertyString("note").isEmpty() ? null : this.getPropertyString("note"));
                schema = vcard;
            } else if ("Wifi".equalsIgnoreCase(this.getPropertyString("type"))) {
                Wifi wifi = new Wifi();
                wifi.setSsid(this.getPropertyString("ssid"));
                wifi.setAuthentication(Wifi.Authentication.valueOf((String)this.getPropertyString("authentication")));
                wifi.setPsk(this.getPropertyString("password").isEmpty() ? null : this.getPropertyString("password"));
                wifi.setHidden("true".equalsIgnoreCase(this.getPropertyString("hidden")));
                schema = wifi;
            } else if ("YouTube".equalsIgnoreCase(this.getPropertyString("type"))) {
                schema = new YouTube(this.getPropertyString("value"));
            } else if (!this.getPropertyString("value").isEmpty()) {
                qrCode = QRCode.from((String)this.getPropertyString("value"));
            }
            if (schema != null) {
                qrCode = QRCode.from((Schema)schema);
            } else if (rawSchema != null) {
                qrCode = QRCode.from(rawSchema);
            }
            if (qrCode != null) {
                output = qrCode.withSize(((Integer)this.getProperty("heightInt")).intValue(), ((Integer)this.getProperty("heightInt")).intValue()).stream();
                byte[] bytes = output.toByteArray();
                input = new ByteArrayInputStream(bytes);
            }
        }
        finally {
            ImageIO.setUseCache(imageIoCache);
        }
        return input;
    }

    @Override
    public String getCSS() {
        return "";
    }
}

