/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.joget.apps.app.dao.BuilderDefinitionDao;
import org.joget.apps.app.model.AppDefinition;
import org.joget.apps.app.model.BuilderDefinition;
import org.joget.apps.app.model.DefaultHashVariablePlugin;
import org.joget.apps.app.service.AppPluginUtil;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.app.service.CustomBuilderUtil;
import org.joget.commons.util.LogUtil;
import org.joget.commons.util.SecurityUtil;
import org.joget.commons.util.StringUtil;
import org.joget.plugin.base.PluginWebSupport;
import org.joget.rbuilder.ReportBuilder;
import org.joget.workflow.util.WorkflowUtil;

public class ReportLinkHashVariable
extends DefaultHashVariablePlugin
implements PluginWebSupport {
    protected ReportBuilder builder = null;

    public String getName() {
        return "ReportLinkHashVariable";
    }

    public String getPrefix() {
        return "reportLink";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".desc"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    public String getLabel() {
        return AppPluginUtil.getMessage((String)(this.getName() + ".label"), (String)this.getClassName(), (String)"messages/ReportElements");
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return "";
    }

    public String processHashVariable(String variableKey) {
        String params = null;
        String filename = null;
        if (variableKey.contains("[") && variableKey.contains("]") && variableKey.contains("{") && variableKey.contains("}")) {
            params = variableKey.substring(variableKey.indexOf("[") + 1, variableKey.indexOf("]"));
            filename = variableKey.substring(variableKey.indexOf("{") + 1, variableKey.indexOf("}"));
            variableKey = variableKey.substring(0, variableKey.indexOf("["));
        } else if (variableKey.contains("[") && variableKey.contains("]")) {
            params = variableKey.substring(variableKey.indexOf("[") + 1, variableKey.indexOf("]"));
            variableKey = variableKey.substring(0, variableKey.indexOf("["));
        } else if (variableKey.contains("{") && variableKey.contains("}")) {
            filename = variableKey.substring(variableKey.indexOf("{") + 1, variableKey.indexOf("}"));
            variableKey = variableKey.substring(0, variableKey.indexOf("{"));
        }
        return this.getUrl(variableKey, params, filename);
    }

    protected String getUrl(String id, String params, String filename) {
        HttpServletRequest request;
        if (params == null) {
            params = "";
        }
        if (filename == null) {
            filename = "";
        }
        if (!id.startsWith("rp_")) {
            id = "rp_" + id;
        }
        AppDefinition appDef = AppUtil.getCurrentAppDefinition();
        BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
        BuilderDefinition builderDefinition = builderDefinitionDao.loadById(id, appDef);
        if (builderDefinition != null && (request = WorkflowUtil.getHttpServletRequest()) != null) {
            HttpServletRequest req = WorkflowUtil.getHttpServletRequest();
            String scheme = req.getScheme();
            String serverName = req.getServerName();
            int serverPort = req.getServerPort();
            StringBuilder url = new StringBuilder();
            url.append(scheme).append("://").append(serverName);
            if (serverPort != 80 && serverPort != 443) {
                url.append(":").append(serverPort);
            }
            url.append(req.getContextPath()).append("/web/json/app/").append(appDef.getAppId()).append("/").append(appDef.getVersion()).append("/plugin/").append(this.getClassName()).append("/service?_rid=" + StringUtil.escapeString((String)id, (String)"url", null));
            if (!params.isEmpty()) {
                url.append("&_params=" + StringUtil.escapeString((String)SecurityUtil.encrypt((String)params), (String)"url", null));
            }
            if (!filename.isEmpty()) {
                url.append("&_filename=" + StringUtil.escapeString((String)SecurityUtil.encrypt((String)filename), (String)"url", null));
            }
            String nonce = SecurityUtil.generateNonce((String[])new String[]{id, params}, (int)8);
            url.append("&_nonce=" + StringUtil.escapeString((String)nonce, (String)"url", null));
            return url.toString();
        }
        return "";
    }

    public Collection<String> availableSyntax() {
        ArrayList<String> syntax = new ArrayList<String>();
        syntax.add("reportLink.ID");
        syntax.add("reportLink.ID[PARAM_NAME1=PARAM_VALUE1&PARAM_NAME2=PARAM_VALUE2]");
        syntax.add("reportLink.ID{FILE_NAME}");
        syntax.add("reportLink.ID[PARAM_NAME1=PARAM_VALUE1&PARAM_NAME2=PARAM_VALUE2]{FILE_NAME}");
        return syntax;
    }

    public void webService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String params = "";
        String customFilename = "";
        if (request.getParameter("_params") != null) {
            try {
                params = SecurityUtil.decrypt((String)request.getParameter("_params"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (request.getParameter("_filename") != null) {
            try {
                customFilename = SecurityUtil.decrypt((String)request.getParameter("_filename"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String reportId = request.getParameter("_rid");
        String nonce = request.getParameter("_nonce");
        if (SecurityUtil.verifyNonce((String)nonce, (String[])new String[]{reportId, params})) {
            AppDefinition appDef = AppUtil.getCurrentAppDefinition();
            BuilderDefinitionDao builderDefinitionDao = (BuilderDefinitionDao)AppUtil.getApplicationContext().getBean("builderDefinitionDao");
            BuilderDefinition builderDefinition = builderDefinitionDao.loadById(reportId, appDef);
            if (builderDefinition != null) {
                String json = builderDefinition.getJson();
                String fileName = "";
                fileName = !customFilename.isEmpty() ? customFilename : builderDefinition.getName();
                if (fileName.contains("#")) {
                    String reportName = builderDefinition.getName();
                    fileName = AppUtil.processHashVariable((String)reportName, null, null, null);
                }
                HashMap<String, String> rparams = new HashMap<String, String>();
                Map parameters = null;
                if (params != null && !params.isEmpty()) {
                    parameters = StringUtil.getUrlParams((String)params);
                    for (String key : parameters.keySet()) {
                        rparams.put(key, StringUtils.join((Object[])((Object[])parameters.get(key)), (String)";"));
                    }
                }
                try {
                    response.setHeader("Content-Type", "application/pdf");
                    response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ".pdf; filename*=UTF-8''" + fileName + ".pdf");
                    response.getOutputStream().write(this.getReport(json, rparams));
                }
                catch (IOException ex) {
                    LogUtil.error((String)this.getClassName(), (Throwable)ex, null);
                }
            }
        } else {
            response.setStatus(400);
        }
    }

    protected byte[] getReport(String json, Map<String, String> params) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("REPORT_PARAMS", params);
        return (byte[])this.getBuilder().getBuilderResult(json, config);
    }

    protected ReportBuilder getBuilder() {
        if (this.builder == null) {
            this.builder = (ReportBuilder)CustomBuilderUtil.getBuilder((String)"report");
        }
        return this.builder;
    }
}

