/*
 * Decompiled with CFR 0.152.
 */
package org.joget.rbuilder.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.joget.apps.app.service.AppUtil;
import org.joget.apps.form.model.Section;
import org.joget.apps.userview.model.UserviewPermission;
import org.joget.commons.util.LogUtil;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class RulePermission
extends UserviewPermission {
    private Collection<Map<String, String>> rules = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthorize() {
        if (!this.getRules().isEmpty()) {
            boolean match = false;
            Context cx = Context.enter();
            Scriptable scope = cx.initStandardObjects(null);
            try {
                String rule = "";
                for (Map<String, String> r : this.getRules()) {
                    String field = r.get("field");
                    String join = r.get("join");
                    String value = r.get("value");
                    String regex = r.get("regex");
                    String reverse = r.get("reverse");
                    if (!(rule.isEmpty() || rule.endsWith("(") || ")".equals(field))) {
                        rule = "or".equals(join) ? rule + " || " : rule + " && ";
                    }
                    if (!")".equals(field)) {
                        rule = rule + " ";
                    }
                    if (!reverse.isEmpty() && !")".equals(field)) {
                        rule = rule + "!";
                    }
                    if ("(".equals(field) || ")".equals(field)) {
                        rule = rule + field;
                        continue;
                    }
                    rule = rule + this.checkValue(field, value, "true".equalsIgnoreCase(regex));
                }
                boolean bl = (Boolean)cx.evaluateString(scope, rule, "", 1, null);
                return bl;
            }
            catch (Exception e) {
                LogUtil.error((String)Section.class.getName(), (Throwable)e, (String)"rules are not valid");
            }
            finally {
                Context.exit();
            }
            return match;
        }
        return true;
    }

    protected Collection<Map<String, String>> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<Map<String, String>>();
            String[] fields = this.getPropertyString("ruleControl").split(";", -1);
            String[] values = this.getPropertyString("visibilityValue").split(";", -1);
            String[] regex = this.getPropertyString("regex").split(";", -1);
            String[] joins = this.getPropertyString("join").split(";", -1);
            String[] reverses = this.getPropertyString("reverse").split(";", -1);
            if (fields.length > 0) {
                for (int i = 0; i < fields.length; ++i) {
                    if (fields[i].isEmpty()) continue;
                    HashMap<String, String> rule = new HashMap<String, String>();
                    rule.put("join", joins[i]);
                    rule.put("reverse", reverses[i]);
                    rule.put("value", values[i]);
                    rule.put("regex", regex[i]);
                    rule.put("field", fields[i]);
                    if (rule.get("field") == null) continue;
                    this.rules.add(rule);
                }
            }
        }
        return this.rules;
    }

    protected boolean checkValue(String field, String value, boolean isRegex) {
        if (field != null) {
            ArrayList<String> paramValue = new ArrayList<String>();
            paramValue.add(field);
            for (String v : paramValue) {
                if (isRegex) {
                    try {
                        if (!v.matches(value)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                if (!v.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return "Rule";
    }

    public String getVersion() {
        return "7.0-SNAPSHOT";
    }

    public String getDescription() {
        return "";
    }

    public String getLabel() {
        return "Rule";
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPropertyOptions() {
        return AppUtil.readPluginResource((String)((Object)((Object)this)).getClass().getName(), (String)"/properties/report/RuleControlPermission.json", null, (boolean)true, null);
    }
}

