$(document).ready(function () {
    CustomBuilder.internalUpdate = CustomBuilder.update;
    CustomBuilder.update = function (addToUndo) {
        CustomBuilder.internalUpdate(addToUndo);
        ReportBuilder.pdfPreview();
    };
});

ReportBuilder = {
    currentContainer: null,

    initBuilder: function (callback) {
        $("#builder_canvas").append('<a class="pdfviewer-toggle"><i class="fas fa-caret-left fa-lg"></i> <i class="far fa-file-pdf fa-lg"></i> <i class="fas fa-caret-right fa-lg" style="display:none"></i></a><div class="canvas-body"></div><div class="elements-preview"><iframe width="100%" height="100%" frameborder="0" allowtransparency="yes" name="previewframe" id="previewframe" src=""></iframe></div>');
        
        $('#cbuilder-preview').append('<input id="preview-type" type="hidden" value="html" name="outputtype"/>');
        
        $("#previewframe").on("load", function () {
            setTimeout(function(){
                $("#builder_canvas").trigger("click"); //make focus back to canvas
            }, 100);
        });

        ReportBuilder.initPalette(function () {
            if (callback !== null && callback !== undefined) {
                callback();
                CustomBuilder.updatePasteIcons();
            }
        });
        
        $(".pdfviewer-toggle").on("click", function(){
            $("#builder_canvas").toggleClass("pdfPreviewEnabled");
            ReportBuilder.pdfPreview();
        });
    },

    load: function (data) {
        $("#builder_canvas .canvas-body").html("");

        ReportBuilder.addReportPart('header', data.header);
        ReportBuilder.addReportPart('body', data.body);
        ReportBuilder.addReportPart('footer', data.footer);

        CustomBuilder.update(false);
    },

    addReportPart: function (key, partObj) {
        if (partObj === null || partObj === undefined) {
            partObj = {
                'elements': []
            };

            if (CustomBuilder.data[key] === undefined) {
                CustomBuilder.data[key] = partObj;
            }
        }

        $(".canvas-body").append('<div class="report-' + key + ' report-part"><div class="element-options"></div><div class="report-part-label">'+get_cbuilder_msg("reportBuilder."+key)+'</div><div class="report-part-hint">'+get_cbuilder_msg("reportBuilder."+key+".hint")+'</div><div class="elements"></div></div>');

        var part = $(".canvas-body").find('.report-' + key);
        
        $(part).find("> .element-options").append('<button class="element-paste element container-element" title="'+get_cbuilder_msg("cbuilder.paste")+'"><i class="fas fa-paste"></i><span>'+get_cbuilder_msg("cbuilder.paste")+'</span></button>');

        $(part)[0].dom = partObj;
        
        $(part).find('> .element-options .element-paste').on("click", function(){
            ReportBuilder.paste(part);
        });

        // make rows sortable
        ReportBuilder.sortable($(".report-" + key + " .elements"));

        //render Elements
        if (partObj !== undefined && partObj['elements'] !== undefined) {
            $.each(partObj['elements'], function (i, el) {
                ReportBuilder.renderElement(part, el);
            });
        }
    },

    addElement: function (container, tempElement) {
        var classname = $(tempElement).attr("element-class");
        var properties = {};
        if (CustomBuilder.paletteElements[classname].properties !== undefined) {
            properties = $.extend(true, properties, CustomBuilder.paletteElements[classname].properties);
        }
        var elementObj = {
            className: classname,
            properties: properties
        };
        properties["id"] = ReportBuilder.uuid();
        ReportBuilder.renderElement(container, elementObj, tempElement);
        CustomBuilder.update();
    },

    renderElement: function (container, elementObj, tempElement) {
        var containerObj = $(container)[0].dom;
        if (elementObj === undefined) {
            return;
        }
        if (tempElement !== undefined) {
            var index = 0;
            if ($(container).find("> .elements").length > 0) {
                index = $(container).find("> .elements > div").index($(tempElement));
            } else {
                index = $(container).find("> .container-elements > div").index($(tempElement));
            }
            containerObj.elements.splice(index, 0, elementObj);
        }
        var html = '<div class="builder-element"><div class="plugin-label"></div><div class="builder-element-handle"></div><div class="element-options middle"></div><div class="element-template"></div></div>';
        var element = $(html);
        $(element)[0].dom = elementObj;

        $(element).find('.plugin-label').text(CustomBuilder.paletteElements[elementObj['className']].label);

        if (CustomBuilder.paletteElements[elementObj['className']].container !== undefined) {
            $(element).addClass("is_container");
        }

        $(element).attr("id", elementObj["properties"]["id"]);
        
        if (CustomBuilder.paletteElements[elementObj['className']].supportContainer) {
            $(element).addClass("supportContainer");
        } else {
            $(element).addClass("notSupportContainer");
        }

        if (CustomBuilder.paletteElements[elementObj['className']].propertyOptions !== undefined) {
            $(element).find('> .element-options').append('<button class="element-edit" title="' + get_cbuilder_msg("reportBuilder.edit") + '"><i class="far fa-edit"></i><span>' + get_cbuilder_msg("reportBuilder.edit") + '</span></button>');
        }
        $(element).find('> .element-options').append('<button class="element-copy element" title="' + get_cbuilder_msg("reportBuilder.copy") + '"><i class="far fa-copy"></i><span>' + get_cbuilder_msg("reportBuilder.copy") + '</span></button>');
        $(element).find('> .element-options').append('<button class="element-delete" title="' + get_cbuilder_msg('reportBuilder.delete') + '"><i class="fas fa-times"></i><span>' + get_cbuilder_msg('reportBuilder.delete') + '</span></button>');

        $(element).find('> .element-options .element-edit').on("click", function () {
            ReportBuilder.showProperties(element);
        });

        $(element).find('> .element-options .element-copy').on("click", function () {
            if ($(element).hasClass("supportContainer")) {
                CustomBuilder.copy(elementObj, "container-element");
            } else {
                CustomBuilder.copy(elementObj, "element");
            }
        });

        $(element).find('> .element-options .element-delete').on("click", function () {
            ReportBuilder.deleteElement(element);
        });

        if (tempElement !== undefined) {
            $(tempElement).replaceWith(element);
        } else {
            if ($(container).find("> .elements").length > 0) {
                $(container).find("> .elements").append(element);
            } else {
                $(container).find("> .container-elements").append(element);
            }
        }
        
        ReportBuilder.reloadElement(element);
    },

    reloadElement: function (element) {
        var elementObj = $(element)[0].dom;

        if ($(element).hasClass("is_container")) {
            try {
                CustomBuilder.paletteElements[elementObj['className']].container.reloadElement(element);
            } catch (err) {
                console.log(err);
            }
        } else {
            $(element).find('.element-template').html('<i class="fas fa-spinner fa-spin"></i>');
            $.post({
                url: CustomBuilder.contextPath + '/web/json/app/' + CustomBuilder.appId + '/' + CustomBuilder.appVersion + '/plugin/org.joget.rbuilder.ReportBuilder/service',
                data: {
                    _id: CustomBuilder.data.properties.id,
                    _json: JSON.encode(elementObj),
                    _action: 'previewElement'
                },
                dataType: "text",
                success: function (response) {
                    if (response !== null) {
                        $(element).find('.element-template').html(response);
                        if ($(element).closest(".report-container").length > 0) {
                            var container = $(element).closest(".report-container");
                            ReportBuilder.equalHeight(container);
                            if ($(element).find('.element-template img').length > 0) {
                                $(element).find('.element-template img').on("load", function() {
                                    var container = $(this).closest(".report-container");
                                    ReportBuilder.equalHeight(container);
                                });
                            }
                        }
                    }
                }
            });
        }
    },

    deleteElement: function (element) {
        var container = null;
        if ($(element).closest(".report-container").length > 0) {
            container = $(element).closest(".report-container");
        } else {
            container = $(element).closest(".report-part");
        }
        var containerObj = $(container)[0].dom;

        var elementObj = $(element)[0].dom;
        var index = $.inArray(elementObj, containerObj.elements);
        if (index !== -1) {
            containerObj.elements.splice(index, 1);
        }
        $(element).remove();

        CustomBuilder.update();
    },

    showProperties: function (element) {
        var dom = $(element)[0].dom;
        var elementClass = dom.className;
        var elementProperty = dom.properties;
        CustomBuilder.editProperties(elementClass, elementProperty);
    },

    saveEditProperties: function (container, properties) {
        var element = $("#" + properties["id"]);

        ReportBuilder.reloadElement($(element));
    },

    paste: function (container) {
        var copied = CustomBuilder.getCopiedElement();
        var copiedObj = copied['object'];
        ReportBuilder.updatePasteId(copiedObj);
        var temp = $('<div></div>');
        $(container).find("> .container-elements, > .elements").append(temp);
        ReportBuilder.renderElement(container, copiedObj, temp);
        CustomBuilder.update();
    },

    updatePasteId: function (elementObj) {
        if (elementObj.elements !== null && elementObj.elements !== undefined && elementObj.elements.length > 0) {
            $.each(elementObj.elements, function (column) {
                if (elementObj.elements[column] !== null & elementObj.elements[column] !== undefined) {
                    ReportBuilder.updatePasteId(elementObj.elements[column]);
                }
            });
        }
        elementObj.properties["id"] = ReportBuilder.uuid();
    },
    
    equalHeight : function(container) {
        var height = 0;
        var parent = $(container).parent();
        
        $(parent).find("> .report-container > .container-elements").css("height", "auto");
        $(parent).find("> .report-container > .container-elements").each(function(){
            var cHeight = $(this).outerHeight();
            if (cHeight > height) {
                height = cHeight;
            }
        });
        $(parent).find("> .report-container > .container-elements").css("height", height + "px");
    },

    initPalette: function (callback) {
        $.ajax({
            url: CustomBuilder.contextPath + '/web/json/app/' + CustomBuilder.appId + '/' + CustomBuilder.appVersion + '/plugin/org.joget.rbuilder.ReportBuilder/service',
            dataType: "json",
            success: function (response) {
                if (response !== null && response !== "") {
                    for (var i in response) {
                        var p = response[i];
                        if (p.className !== "") {
                            var render = true;
                            var css = "";
                            var metaData = {
                                "supportContainer" : (p.supportContainer === "true")
                            };
                            if (p.supportContainer === "true") {
                                css = "supportContainer";
                            } else {
                                css = "notSupportContainer";
                            }
                            if (p.isContainer === "true") {
                                try {
                                    metaData.container = eval("[" + p.builderScript + "]")[0];
                                } catch (err) {
                                    console.log(err);
                                }
                            }
                            if (p.isHidden === "true") {
                                render = false;
                            }
                            CustomBuilder.initPaletteElement("", p.className, p.label, p.icon, p.propertyOptions, p.defaultProperties, render, css, metaData);
                        }
                    }

                    //elements drag
                    $('.builder-palette-element').draggable({
                        connectToSortable: ".elements",
                        opacity: 0.7,
                        helper: "clone",
                        zIndex: 200,
                        revert: "invalid",
                        cursor: "move",
                        start: function( event, ui ){
                            var element = $(this);
                            if ($(element).hasClass("notSupportContainer")) {
                                $(".canvas-body").addClass("notSupportContainer");
                            }
                        },
                        stop: function( event, ui ){
                            $(".canvas-body").removeClass("notSupportContainer");
                        }
                    }).disableSelection();
                }

                if (callback !== null && callback !== undefined) {
                    callback();
                }
            }
        });
    },

    sortable: function (container) {
        $(container).sortable({
            items: ".builder-element",
            opacity: 0.8,
            dropOnEmpty: true,
            activeClass: "element-highlight",
            connectWith: ".elements, .container-elements",
            start: function (event, ui) {
                var element = $(ui.item[0]);
                if ($(element).hasClass("notSupportContainer")) {
                    $(".canvas-body").addClass("notSupportContainer");
                }
                if (!$(element).hasClass("builder-palette-element")) {
                    if ($(element).closest(".report-container").length > 0) {
                        ReportBuilder.currentContainer = $(element).closest(".report-container");
                    } else {
                        ReportBuilder.currentContainer = $(element).closest(".report-part");
                    }
                } else {
                    ReportBuilder.currentContainer = null;
                }
            },
            stop: function (event, ui) {
                $(".canvas-body").removeClass("notSupportContainer");
                
                var element = $(ui.item[0]);
                var container = null;
                if ($(element).closest(".report-container").length > 0) {
                    container = $(element).closest(".report-container");
                } else {
                    container = $(element).closest(".report-part");
                }
                
                var containerObj = $(container)[0].dom;
                
                if ($(element).hasClass("notSupportContainer") && $(container).hasClass("report-container")) {
                    if ($(element).hasClass("builder-palette-element")) {
                        $(element).remove();
                    } else {
                        var elementObj = $(element)[0].dom;
                        
                        //restore
                        var prevContainerObj = $(ReportBuilder.currentContainer)[0].dom;
                        var index = $.inArray(elementObj, prevContainerObj.elements);
                        var indexObj = $(ReportBuilder.currentContainer).find("> .elements > .builder-element:eq("+index+")");
                        
                        if ($(indexObj).length > 0) {
                            $(indexObj).before($(element));
                        } else {
                            $(ReportBuilder.currentContainer).find("> .elements").append($(element));
                        }
                    }
                    return;
                }

                if ($(element).hasClass("builder-palette-element")) {
                    ReportBuilder.addElement(container, element);
                } else {
                    var elementObj = $(element)[0].dom;
                    if (ReportBuilder.currentContainer[0] === container[0]) {
                        var oldIndex = $.inArray(elementObj, containerObj.elements);
                        var moveElementObj = containerObj.elements.splice(oldIndex, 1);

                        var newIndex = 0;
                        var prev = $(element).prev();
                        if ($(prev).length > 0) {
                            var prevObj = $(prev)[0].dom;
                            newIndex = $.inArray(prevObj, containerObj.elements) + 1;
                        }

                        containerObj.elements.splice(newIndex, 0, elementObj);
                        
                        if ($(container).hasClass("report-container")) {
                            ReportBuilder.equalHeight(container);
                        }
                    } else {
                        var prevContainerObj = $(ReportBuilder.currentContainer)[0].dom;
                        var index = $.inArray(elementObj, prevContainerObj.elements);
                        if (index !== -1) {
                            prevContainerObj.elements.splice(index, 1);
                        }
                        var newIndex = 0;
                        var prev = $(element).prev();
                        if ($(prev).length > 0) {
                            var prevObj = $(prev)[0].dom;
                            newIndex = $.inArray(prevObj, prevContainerObj.elements) + 1;
                        }

                        containerObj.elements.splice(newIndex, 0, elementObj);
                        
                        if ($(ReportBuilder.currentContainer).hasClass("report-container")) {
                            ReportBuilder.equalHeight(ReportBuilder.currentContainer);
                        }
                        if ($(container).hasClass("report-container")) {
                            ReportBuilder.equalHeight(container);
                        }
                    }
                }

                //update row sortable
                CustomBuilder.update();
            },
            over: function (event, ui) {
                if ($(this).closest(".report-container").length > 0) {
                    var container = $(this).closest(".report-container");
                    ReportBuilder.equalHeight(container);
                }
            },
            tolerance: "pointer",
            revertDuration: 100,
            revert: "invalid"
        }).disableSelection();
    },

    uuid: function () {
        return 'xxxxxxxx-xxxx-4xxx-xxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {  //xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx
            var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        }).toUpperCase();
    },
    
    renderPermissionElements: function (tbody) {
        if (CustomBuilder.data.header.elements !== undefined && CustomBuilder.data.header.elements.length > 0) {
            $(tbody).append('<tr class="header"><td>'+get_cbuilder_msg("reportBuilder.header")+'</td><td class="authorized"></td></tr>');
            
            var childs = CustomBuilder.data.header.elements;
            if (childs !== null && childs !== undefined && childs.length > 0) {
                $.each(childs, function(i, child){
                    PermissionManager.renderElement(child, tbody);
                });
            }
        }
        if (CustomBuilder.data.body.elements !== undefined && CustomBuilder.data.body.elements.length > 0) {
            $(tbody).append('<tr class="header"><td>'+get_cbuilder_msg("reportBuilder.body")+'</td><td class="authorized"></td></tr>');
            
            var childs = CustomBuilder.data.body.elements;
            if (childs !== null && childs !== undefined && childs.length > 0) {
                $.each(childs, function(i, child){
                    PermissionManager.renderElement(child, tbody);
                });
            }
        }
        if (CustomBuilder.data.footer.elements !== undefined && CustomBuilder.data.footer.elements.length > 0) {
            $(tbody).append('<tr class="header"><td>'+get_cbuilder_msg("reportBuilder.footer")+'</td><td class="authorized"></td></tr>');
            
            var childs = CustomBuilder.data.footer.elements;
            if (childs !== null && childs !== undefined && childs.length > 0) {
                $.each(childs, function(i, child){
                    PermissionManager.renderElement(child, tbody);
                });
            }
        }
    },
    
    pdfPreview : function() {
        if ($("#builder_canvas").hasClass("pdfPreviewEnabled")) {
            $('#cbuilder-preview').attr("target", "previewframe");
            $('#cbuilder-preview #preview-type').val("pdf");
            CustomBuilder.preview();
            $('#cbuilder-preview #preview-type').val("html");
            $('#cbuilder-preview').attr("target", "_blank");
        }
    }
};
