/*
 * Decompiled with CFR 0.152.
 */
package org.joget.cluster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Agent {
    public static final String SYSTEM_PROPERTY_NODE_NAME = "wflow.name";
    public static final String SYSTEM_PROPERTY_WFLOW_HOME = "wflow.home";

    public static void premain(String args, Instrumentation instrumentation) {
        System.setProperty("wflow.cluster", "true");
        String agentId = System.getProperty(SYSTEM_PROPERTY_NODE_NAME);
        if (agentId == null || agentId.isEmpty()) {
            try {
                agentId = InetAddress.getLocalHost().getHostName();
                System.setProperty(SYSTEM_PROPERTY_NODE_NAME, agentId);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (agentId != null && !agentId.isEmpty()) {
            System.setProperty("glowroot.multi.dir", "true");
            System.setProperty("glowroot.agent.id", agentId);
            System.setProperty("glowroot.agent.dir", Agent.getGlowrootDirectory(agentId));
        }
        Agent.checkGlowrootOnServerStartup();
    }

    public static void checkGlowrootOnServerStartup() {
        String currentServer = Agent.getServerName();
        List<String> serverList = Agent.getServerList();
        if (!serverList.contains(currentServer)) {
            serverList.add(currentServer);
        }
        Agent.changeGlowrootFile(currentServer, null, null);
        Agent.writeServersIPFile(currentServer);
        if (serverList.size() > 1) {
            ArrayList<String> glowrootList = new ArrayList<String>();
            for (String server : serverList) {
                String glowrootURL = Agent.getGlowrootURLAndPort(server);
                if (!server.equalsIgnoreCase(currentServer)) {
                    glowrootList.add(glowrootURL);
                }
                System.out.println("Running Glowroot Server: " + server + ", on URL: " + glowrootURL);
            }
            String currentGlowrootURL = Agent.getGlowrootURLAndPort(currentServer);
            String[] parts = currentGlowrootURL.split(":");
            int oriPortNumber = Integer.parseInt(parts[2]);
            int newPortNumber = 0;
            boolean portChanged = false;
            while (glowrootList.contains(currentGlowrootURL)) {
                portChanged = true;
                parts = currentGlowrootURL.split(":");
                newPortNumber = Integer.parseInt(parts[2]) + 1;
                currentGlowrootURL = parts[0] + ":" + parts[1] + ":" + newPortNumber;
            }
            if (portChanged) {
                System.out.println("Changing Glowroot Server: " + currentServer + ", to URL: " + currentGlowrootURL);
                Agent.changeGlowrootFile(currentServer, Integer.toString(newPortNumber), Integer.toString(oriPortNumber));
            }
        }
    }

    public static String getGlowrootDirectory(String server) {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        List<String> javaOpts = mxBean.getInputArguments();
        for (String javaOpt : javaOpts) {
            if (!javaOpt.contains("glowroot.jar")) continue;
            javaOpt = javaOpt.substring(javaOpt.indexOf(":") + 1, javaOpt.length());
            javaOpt = javaOpt.replace("glowroot.jar", "agent-" + server);
            return javaOpt;
        }
        return "";
    }

    public static void changeGlowrootFile(String server, String newPortNumber, String oriPortNumber) {
        File glowrootFile = new File(Agent.getGlowrootDirectory(server) + File.separator + "admin.json");
        String adminJson = "";
        try {
            if (!Files.exists(glowrootFile.toPath(), new LinkOption[0])) {
                adminJson = Agent.getDefaultAdminFile();
                glowrootFile.getParentFile().mkdirs();
            } else {
                try (FileReader reader = new FileReader(glowrootFile.getPath());){
                    int character;
                    while ((character = reader.read()) != -1) {
                        adminJson = adminJson + (char)character;
                    }
                }
            }
            if (adminJson.contains("127.0.0.1")) {
                adminJson = adminJson.replaceAll("127.0.0.1", "0.0.0.0");
            }
            if (newPortNumber != null & oriPortNumber != null) {
                adminJson = adminJson.replaceAll(oriPortNumber, newPortNumber);
            }
            try (FileWriter writer = new FileWriter(glowrootFile, false);){
                writer.write(adminJson);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeServersIPFile(String server) {
        InputStream input = null;
        OutputStream output = null;
        Properties props = new Properties();
        File serversIPFile = new File(Agent.getBaseSharedDirectory() + "/serversIP.properties");
        try {
            if (Files.exists(serversIPFile.toPath(), new LinkOption[0])) {
                input = new FileInputStream(serversIPFile.getPath());
                props.load(input);
            }
            if (props.get(server) != null) {
                props.remove(server);
            }
            props.setProperty(server, Agent.getCurrentIPAddress());
            output = new FileOutputStream(serversIPFile.getPath());
            props.store(output, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getIPAddress(String server) {
        InputStream input = null;
        File serversIPFile = new File(Agent.getBaseSharedDirectory() + "/serversIP.properties");
        if (Files.exists(serversIPFile.toPath(), new LinkOption[0])) {
            try {
                Properties props = new Properties();
                input = new FileInputStream(serversIPFile.getPath());
                props.load(input);
                if (props.get(server) != null) {
                    String string = props.getProperty(server);
                    return string;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    public static String getGlowrootURLAndPort(String server) {
        String glowrootURL;
        block8: {
            File glowrootFile = new File(Agent.getGlowrootDirectory(server) + File.separator + "admin.json");
            glowrootURL = "";
            String port = "";
            try {
                if (!Files.exists(glowrootFile.toPath(), new LinkOption[0])) break block8;
                try (FileReader reader = new FileReader(glowrootFile.getPath());){
                    int character;
                    while ((character = reader.read()) != -1) {
                        glowrootURL = glowrootURL + (char)character;
                    }
                }
                glowrootURL = glowrootURL.substring(glowrootURL.lastIndexOf("\"web\":") + 1);
                glowrootURL = glowrootURL.substring(glowrootURL.indexOf("{"), glowrootURL.indexOf("}") + 1);
                port = glowrootURL.substring(glowrootURL.indexOf("\"port\":") + 7);
                port = port.substring(0, port.indexOf(","));
                port = port.replaceAll(" ", "");
                glowrootURL = "http://" + Agent.getIPAddress(server) + ":" + port;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return glowrootURL;
    }

    public static String getBaseSharedDirectory() {
        return System.getProperty(SYSTEM_PROPERTY_WFLOW_HOME, System.getProperty("user.home") + File.separator + "wflow" + File.separator);
    }

    public static String getBasedDirectory() {
        return System.getProperty(SYSTEM_PROPERTY_WFLOW_HOME, System.getProperty("user.home"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getServerList() {
        InputStream input = null;
        ArrayList<String> serverlist = new ArrayList<String>();
        File serversIPFile = new File(Agent.getBaseSharedDirectory() + "/serversIP.properties");
        if (Files.exists(serversIPFile.toPath(), new LinkOption[0])) {
            try {
                Properties props = new Properties();
                input = new FileInputStream(serversIPFile.getPath());
                props.load(input);
                Set<String> nodes = props.stringPropertyNames();
                for (String node : nodes) {
                    serverlist.add(node);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return serverlist;
    }

    public static String getServerName() {
        String serverName = System.getProperty(SYSTEM_PROPERTY_NODE_NAME);
        if (serverName == null) {
            serverName = "";
        }
        return serverName;
    }

    public static String normalizedFileName(String filename) {
        try {
            filename = URLDecoder.decode(filename, "UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String normalizedFileName = Normalizer.normalize(filename, Normalizer.Form.NFKC);
        if (normalizedFileName.contains("../") || normalizedFileName.contains("..\\")) {
            throw new SecurityException("Invalid filename " + normalizedFileName);
        }
        return normalizedFileName;
    }

    public static String getDefaultAdminFile() {
        return "{\"users\":[{\"username\":\"anonymous\",\"roles\":[\"Administrator\"]}],\"roles\":[{\"name\":\"Administrator\",\"permissions\":[\"agent:transaction\",\"agent:error\",\"agent:jvm\",\"agent:incident\",\"agent:config\",\"admin\"]}],\"web\":{\"port\":4000,\"bindAddress\":\"0.0.0.0\",\"contextPath\":\"/\",\"sessionTimeoutMinutes\":30,\"sessionCookieName\":\"GLOWROOT_SESSION_ID\"},\"storage\":{\"rollupExpirationHours\":[72,336,2160,2160],\"traceExpirationHours\":336,\"fullQueryTextExpirationHours\":336,\"rollupCappedDatabaseSizesMb\":[500,500,500,500],\"traceCappedDatabaseSizeMb\":500}}";
    }

    public static String getCurrentIPAddress() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                if (intf.isPointToPoint()) continue;
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

