/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.repo;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.repo.GaugeNameDao;
import org.glowroot.agent.embedded.sql.SQLException;
import org.glowroot.agent.embedded.util.DataSource;
import org.glowroot.agent.embedded.util.ImmutableColumn;
import org.glowroot.agent.embedded.util.Schemas;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.util.Checkers;

class SchemaUpgrade {
    private static final Logger startupLogger = LoggerFactory.getLogger((String)"org.glowroot");
    private static final int CURR_SCHEMA_VERSION = 6;
    private static final ImmutableList<Schemas.Column> columns = ImmutableList.of((Object)ImmutableColumn.of("schema_version", Schemas.ColumnType.BIGINT));
    private final DataSource dataSource;
    private final @Nullable Integer initialSchemaVersion;

    SchemaUpgrade(DataSource dataSource) throws SQLException {
        this.dataSource = dataSource;
        dataSource.syncTable("schema_version", (List<Schemas.Column>)columns);
        this.initialSchemaVersion = SchemaUpgrade.getSchemaVersion(dataSource);
    }

    public @Nullable Integer getInitialSchemaVersion() {
        return this.initialSchemaVersion;
    }

    public void upgrade() throws Exception {
        Preconditions.checkNotNull((Object)this.initialSchemaVersion);
        if (this.initialSchemaVersion == 6) {
            return;
        }
        if (this.initialSchemaVersion > 6) {
            startupLogger.warn("running an older version of glowroot on a newer glowroot schema (expecting glowroot schema version <= {} but found version {}), this could be problematic", (Object)6, (Object)this.initialSchemaVersion);
            return;
        }
        startupLogger.info("upgrading glowroot schema from version {} to version {}...", (Object)this.initialSchemaVersion, (Object)6);
        if (this.initialSchemaVersion < 3) {
            this.renameOldGaugeNameTable();
            this.updateSchemaVersion(3);
        }
        if (this.initialSchemaVersion < 4) {
            this.populateNewGaugeNameTable();
            this.updateSchemaVersion(4);
        }
        if (this.initialSchemaVersion == 4) {
            this.populateNewGaugeNameTable();
            this.updateSchemaVersion(5);
        } else {
            this.updateSchemaVersion(5);
        }
        if (this.initialSchemaVersion < 6) {
            this.renameAggregateColumnNames();
            this.updateSchemaVersion(6);
        }
        startupLogger.info("upgraded glowroot schema from version {} to version {}", (Object)this.initialSchemaVersion, (Object)6);
    }

    public void updateSchemaVersionToCurent() throws Exception {
        this.updateSchemaVersion(6);
    }

    private void updateSchemaVersion(int schemaVersion) throws Exception {
        int updated = this.dataSource.update("update schema_version set schema_version = ?", schemaVersion);
        if (updated == 0) {
            this.dataSource.update("insert into schema_version (schema_version) values (?)", schemaVersion);
        }
    }

    private void renameOldGaugeNameTable() throws SQLException {
        this.dataSource.renameTable("gauge_name", "gauge_id");
        this.dataSource.renameColumn("gauge_id", "id", "gauge_id");
    }

    private void populateNewGaugeNameTable() throws SQLException {
        startupLogger.info("populating new gauge name history table - this could take a few seconds on large data sets...");
        this.dataSource.syncTable("gauge_name", (List<Schemas.Column>)GaugeNameDao.columns);
        this.dataSource.syncIndexes("gauge_name", GaugeNameDao.indexes);
        this.dataSource.execute("truncate table gauge_name");
        long fixedIntervalMillis = TimeUnit.DAYS.toMillis(1L);
        String captureTimeSql = (String)Checkers.castUntainted((Object)("ceil(capture_time / " + fixedIntervalMillis + ".0) * " + fixedIntervalMillis));
        this.dataSource.update("insert into gauge_name (capture_time, gauge_name) select distinct " + captureTimeSql + ", gauge_name from gauge_value_rollup_4, gauge_id where gauge_value_rollup_4.gauge_id = gauge_id.gauge_id", new Object[0]);
        startupLogger.info("populating new gauge name history table - complete");
    }

    private void renameAggregateColumnNames() throws SQLException {
        for (int i = 0; i < 4; ++i) {
            String transactionTableName;
            String overallTableName = "aggregate_tt_rollup_" + Checkers.castUntainted((Object)i);
            if (this.dataSource.columnExists(overallTableName, "aux_thread_root_timers")) {
                this.dataSource.renameColumn(overallTableName, "aux_thread_root_timers", "aux_thread_root_timer");
            }
            if (this.dataSource.columnExists(overallTableName, "async_root_timers")) {
                this.dataSource.renameColumn(overallTableName, "async_root_timers", "async_timers");
            }
            if (this.dataSource.columnExists(transactionTableName = "aggregate_tn_rollup_" + Checkers.castUntainted((Object)i), "aux_thread_root_timers")) {
                this.dataSource.renameColumn(transactionTableName, "aux_thread_root_timers", "aux_thread_root_timer");
            }
            if (!this.dataSource.columnExists(transactionTableName, "async_root_timers")) continue;
            this.dataSource.renameColumn(transactionTableName, "async_root_timers", "async_timers");
        }
    }

    private static @Nullable Integer getSchemaVersion(DataSource dataSource) throws SQLException {
        Long schemaVersion = dataSource.queryForOptionalLong("select schema_version from schema_version", new Object[0]);
        if (schemaVersion != null) {
            return schemaVersion.intValue();
        }
        if (dataSource.tableExists("trace")) {
            return 1;
        }
        return null;
    }
}

