/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.RepoAdmin;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RepoAdmin.H2Table", generator="Immutables")
@Immutable
public final class ImmutableH2Table
implements RepoAdmin.H2Table {
    private final String name;
    private final long bytes;
    private final long rows;

    private ImmutableH2Table(String name, long bytes, long rows) {
        this.name = name;
        this.bytes = bytes;
        this.rows = rows;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="bytes")
    public long bytes() {
        return this.bytes;
    }

    @Override
    @JsonProperty(value="rows")
    public long rows() {
        return this.rows;
    }

    public final ImmutableH2Table withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableH2Table(newValue, this.bytes, this.rows);
    }

    public final ImmutableH2Table withBytes(long value) {
        if (this.bytes == value) {
            return this;
        }
        return new ImmutableH2Table(this.name, value, this.rows);
    }

    public final ImmutableH2Table withRows(long value) {
        if (this.rows == value) {
            return this;
        }
        return new ImmutableH2Table(this.name, this.bytes, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableH2Table && this.equalTo(0, (ImmutableH2Table)another);
    }

    private boolean equalTo(int synthetic, ImmutableH2Table another) {
        return this.name.equals(another.name) && this.bytes == another.bytes && this.rows == another.rows;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.bytes);
        h += (h << 5) + Longs.hashCode((long)this.rows);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"H2Table").omitNullValues().add("name", (Object)this.name).add("bytes", this.bytes).add("rows", this.rows).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableH2Table fromJson(Json json) {
        Builder builder = ImmutableH2Table.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.bytesIsSet) {
            builder.bytes(json.bytes);
        }
        if (json.rowsIsSet) {
            builder.rows(json.rows);
        }
        return builder.build();
    }

    public static ImmutableH2Table copyOf(RepoAdmin.H2Table instance) {
        if (instance instanceof ImmutableH2Table) {
            return (ImmutableH2Table)instance;
        }
        return ImmutableH2Table.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RepoAdmin.H2Table", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_BYTES = 2L;
        private static final long INIT_BIT_ROWS = 4L;
        private long initBits = 7L;
        @Nullable
        private String name;
        private long bytes;
        private long rows;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(RepoAdmin.H2Table instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.bytes(instance.bytes());
            this.rows(instance.rows());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder bytes(long bytes) {
            this.bytes = bytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rows(long rows) {
            this.rows = rows;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableH2Table build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableH2Table(this.name, this.bytes, this.rows);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bytes");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("rows");
            }
            return "Cannot build H2Table, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RepoAdmin.H2Table", generator="Immutables")
    static final class Json
    implements RepoAdmin.H2Table {
        @Nullable
        String name;
        long bytes;
        boolean bytesIsSet;
        long rows;
        boolean rowsIsSet;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="bytes")
        public void setBytes(long bytes) {
            this.bytes = bytes;
            this.bytesIsSet = true;
        }

        @JsonProperty(value="rows")
        public void setRows(long rows) {
            this.rows = rows;
            this.rowsIsSet = true;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long bytes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long rows() {
            throw new UnsupportedOperationException();
        }
    }
}

