/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.SyntheticResult;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.primitives.Doubles;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SyntheticResult", generator="Immutables")
@Immutable
public final class ImmutableSyntheticResult
implements SyntheticResult {
    private final long captureTime;
    private final double totalDurationNanos;
    private final long executionCount;
    private final ImmutableList<SyntheticResult.ErrorInterval> errorIntervals;

    private ImmutableSyntheticResult(long captureTime, double totalDurationNanos, long executionCount, ImmutableList<SyntheticResult.ErrorInterval> errorIntervals) {
        this.captureTime = captureTime;
        this.totalDurationNanos = totalDurationNanos;
        this.executionCount = executionCount;
        this.errorIntervals = errorIntervals;
    }

    @Override
    @JsonProperty(value="captureTime")
    public long captureTime() {
        return this.captureTime;
    }

    @Override
    @JsonProperty(value="totalDurationNanos")
    public double totalDurationNanos() {
        return this.totalDurationNanos;
    }

    @Override
    @JsonProperty(value="executionCount")
    public long executionCount() {
        return this.executionCount;
    }

    @JsonProperty(value="errorIntervals")
    public ImmutableList<SyntheticResult.ErrorInterval> errorIntervals() {
        return this.errorIntervals;
    }

    public final ImmutableSyntheticResult withCaptureTime(long value) {
        if (this.captureTime == value) {
            return this;
        }
        return new ImmutableSyntheticResult(value, this.totalDurationNanos, this.executionCount, this.errorIntervals);
    }

    public final ImmutableSyntheticResult withTotalDurationNanos(double value) {
        if (Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableSyntheticResult(this.captureTime, value, this.executionCount, this.errorIntervals);
    }

    public final ImmutableSyntheticResult withExecutionCount(long value) {
        if (this.executionCount == value) {
            return this;
        }
        return new ImmutableSyntheticResult(this.captureTime, this.totalDurationNanos, value, this.errorIntervals);
    }

    public final ImmutableSyntheticResult withErrorIntervals(SyntheticResult.ErrorInterval ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableSyntheticResult(this.captureTime, this.totalDurationNanos, this.executionCount, (ImmutableList<SyntheticResult.ErrorInterval>)newValue);
    }

    public final ImmutableSyntheticResult withErrorIntervals(Iterable<? extends SyntheticResult.ErrorInterval> elements) {
        if (this.errorIntervals == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableSyntheticResult(this.captureTime, this.totalDurationNanos, this.executionCount, (ImmutableList<SyntheticResult.ErrorInterval>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSyntheticResult && this.equalTo(0, (ImmutableSyntheticResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableSyntheticResult another) {
        return this.captureTime == another.captureTime && Double.doubleToLongBits(this.totalDurationNanos) == Double.doubleToLongBits(another.totalDurationNanos) && this.executionCount == another.executionCount && this.errorIntervals.equals(another.errorIntervals);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.captureTime);
        h += (h << 5) + Doubles.hashCode((double)this.totalDurationNanos);
        h += (h << 5) + Longs.hashCode((long)this.executionCount);
        h += (h << 5) + this.errorIntervals.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"SyntheticResult").omitNullValues().add("captureTime", this.captureTime).add("totalDurationNanos", this.totalDurationNanos).add("executionCount", this.executionCount).add("errorIntervals", this.errorIntervals).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSyntheticResult fromJson(Json json) {
        Builder builder = ImmutableSyntheticResult.builder();
        if (json.captureTimeIsSet) {
            builder.captureTime(json.captureTime);
        }
        if (json.totalDurationNanosIsSet) {
            builder.totalDurationNanos(json.totalDurationNanos);
        }
        if (json.executionCountIsSet) {
            builder.executionCount(json.executionCount);
        }
        if (json.errorIntervals != null) {
            builder.addAllErrorIntervals(json.errorIntervals);
        }
        return builder.build();
    }

    public static ImmutableSyntheticResult copyOf(SyntheticResult instance) {
        if (instance instanceof ImmutableSyntheticResult) {
            return (ImmutableSyntheticResult)instance;
        }
        return ImmutableSyntheticResult.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SyntheticResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CAPTURE_TIME = 1L;
        private static final long INIT_BIT_TOTAL_DURATION_NANOS = 2L;
        private static final long INIT_BIT_EXECUTION_COUNT = 4L;
        private long initBits = 7L;
        private long captureTime;
        private double totalDurationNanos;
        private long executionCount;
        private ImmutableList.Builder<SyntheticResult.ErrorInterval> errorIntervals = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(SyntheticResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.captureTime(instance.captureTime());
            this.totalDurationNanos(instance.totalDurationNanos());
            this.executionCount(instance.executionCount());
            this.addAllErrorIntervals(instance.errorIntervals());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder captureTime(long captureTime) {
            this.captureTime = captureTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder totalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executionCount(long executionCount) {
            this.executionCount = executionCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrorIntervals(SyntheticResult.ErrorInterval element) {
            this.errorIntervals.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addErrorIntervals(SyntheticResult.ErrorInterval ... elements) {
            this.errorIntervals.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder errorIntervals(Iterable<? extends SyntheticResult.ErrorInterval> elements) {
            this.errorIntervals = ImmutableList.builder();
            return this.addAllErrorIntervals(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllErrorIntervals(Iterable<? extends SyntheticResult.ErrorInterval> elements) {
            this.errorIntervals.addAll(elements);
            return this;
        }

        public ImmutableSyntheticResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSyntheticResult(this.captureTime, this.totalDurationNanos, this.executionCount, this.errorIntervals.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("captureTime");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("totalDurationNanos");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("executionCount");
            }
            return "Cannot build SyntheticResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SyntheticResult", generator="Immutables")
    static final class Json
    implements SyntheticResult {
        long captureTime;
        boolean captureTimeIsSet;
        double totalDurationNanos;
        boolean totalDurationNanosIsSet;
        long executionCount;
        boolean executionCountIsSet;
        @Nullable
        List<SyntheticResult.ErrorInterval> errorIntervals = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="captureTime")
        public void setCaptureTime(long captureTime) {
            this.captureTime = captureTime;
            this.captureTimeIsSet = true;
        }

        @JsonProperty(value="totalDurationNanos")
        public void setTotalDurationNanos(double totalDurationNanos) {
            this.totalDurationNanos = totalDurationNanos;
            this.totalDurationNanosIsSet = true;
        }

        @JsonProperty(value="executionCount")
        public void setExecutionCount(long executionCount) {
            this.executionCount = executionCount;
            this.executionCountIsSet = true;
        }

        @JsonProperty(value="errorIntervals")
        public void setErrorIntervals(List<SyntheticResult.ErrorInterval> errorIntervals) {
            this.errorIntervals = errorIntervals;
        }

        @Override
        public long captureTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double totalDurationNanos() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long executionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SyntheticResult.ErrorInterval> errorIntervals() {
            throw new UnsupportedOperationException();
        }
    }
}

