/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.StorageConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.org.glowroot.common.util.Clock;

public class RollupLevelService {
    private final ConfigRepository configRepository;
    private final Clock clock;

    public RollupLevelService(ConfigRepository configRepository, Clock clock) {
        this.configRepository = configRepository;
        this.clock = clock;
    }

    public int getRollupLevelForView(long from, long to, DataKind dataKind) {
        long millis = to - from;
        long timeAgoMillis = this.clock.currentTimeMillis() - from;
        List<Integer> rollupExpirationHours = this.getRollupExpirationHours(dataKind);
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            ConfigRepository.RollupConfig nextRollupConfig = rollupConfigs.get(i + 1);
            int expirationHours = rollupExpirationHours.get(i);
            if (millis >= nextRollupConfig.viewThresholdMillis() || expirationHours != 0 && TimeUnit.HOURS.toMillis(expirationHours) <= timeAgoMillis) continue;
            return i;
        }
        return rollupConfigs.size() - 1;
    }

    public int getRollupLevelForReport(long from, DataKind dataKind) throws Exception {
        long timeAgoMillis = this.clock.currentTimeMillis() - from;
        List<Integer> rollupExpirationHours = this.getRollupExpirationHours(dataKind);
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            int expirationHours = rollupExpirationHours.get(i);
            if (expirationHours != 0 && TimeUnit.HOURS.toMillis(expirationHours) <= timeAgoMillis) continue;
            return i;
        }
        return rollupConfigs.size() - 1;
    }

    public int getGaugeRollupLevelForView(long from, long to, boolean agentRollup) {
        long millis = to - from;
        long timeAgoMillis = this.clock.currentTimeMillis() - from;
        ImmutableList<Integer> rollupExpirationHours = this.configRepository.getStorageConfig().rollupExpirationHours();
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        long viewThresholdMillis = rollupConfigs.get(0).viewThresholdMillis();
        int expirationHours = (Integer)rollupExpirationHours.get(0);
        if (millis < viewThresholdMillis * 4L && (expirationHours == 0 || TimeUnit.HOURS.toMillis(expirationHours) > timeAgoMillis)) {
            return agentRollup ? 1 : 0;
        }
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            viewThresholdMillis = rollupConfigs.get(i + 1).viewThresholdMillis();
            expirationHours = (Integer)rollupExpirationHours.get(i);
            if (millis >= viewThresholdMillis * 4L || expirationHours != 0 && TimeUnit.HOURS.toMillis(expirationHours) <= timeAgoMillis) continue;
            return i + 1;
        }
        return rollupConfigs.size();
    }

    public int getGaugeRollupLevelForReport(long from) throws Exception {
        long timeAgoMillis = this.clock.currentTimeMillis() - from;
        ImmutableList<Integer> rollupExpirationHours = this.configRepository.getStorageConfig().rollupExpirationHours();
        List<ConfigRepository.RollupConfig> rollupConfigs = this.configRepository.getRollupConfigs();
        int expirationHours = (Integer)rollupExpirationHours.get(0);
        if (expirationHours == 0 || TimeUnit.HOURS.toMillis(expirationHours) > timeAgoMillis) {
            return 0;
        }
        for (int i = 0; i < rollupConfigs.size() - 1; ++i) {
            expirationHours = (Integer)rollupExpirationHours.get(i);
            if (expirationHours != 0 && TimeUnit.HOURS.toMillis(expirationHours) <= timeAgoMillis) continue;
            return i + 1;
        }
        return rollupConfigs.size();
    }

    private List<Integer> getRollupExpirationHours(DataKind dataKind) {
        StorageConfig storageConfig = this.configRepository.getStorageConfig();
        switch (dataKind) {
            case GENERAL: {
                return storageConfig.rollupExpirationHours();
            }
            case QUERY: {
                return storageConfig.queryAndServiceCallRollupExpirationHours();
            }
            case SERVICE_CALL: {
                return storageConfig.queryAndServiceCallRollupExpirationHours();
            }
            case PROFILE: {
                return storageConfig.profileRollupExpirationHours();
            }
        }
        throw new RuntimeException("Unexpected data kind: " + (Object)((Object)dataKind));
    }

    public static long getSafeRollupTime(long safeCurrentTime, long intervalMillis) {
        return RollupLevelService.getFloorRollupTime(safeCurrentTime, intervalMillis);
    }

    public static long getFloorRollupTime(long captureTime, long intervalMillis) {
        return (long)Math.floor((double)captureTime / (double)intervalMillis) * intervalMillis;
    }

    public static long getCeilRollupTime(long captureTime, long intervalMillis) {
        return (long)Math.ceil((double)captureTime / (double)intervalMillis) * intervalMillis;
    }

    public static enum DataKind {
        GENERAL,
        QUERY,
        SERVICE_CALL,
        PROFILE;

    }
}

