/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.DataSeries;
import org.glowroot.agent.shaded.org.glowroot.common.util.CaptureTimes;

class DataSeriesHelper {
    private final long liveCaptureTime;
    private final long dataPointIntervalMillis;

    DataSeriesHelper(long liveCaptureTime, long dataPointIntervalMillis) {
        this.liveCaptureTime = liveCaptureTime;
        this.dataPointIntervalMillis = dataPointIntervalMillis;
    }

    void addInitialUpslopeIfNeeded(long requestFrom, long captureTime, List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries) {
        if (captureTime == requestFrom) {
            return;
        }
        long priorCaptureTime = this.getPriorCaptureTime(captureTime);
        for (DataSeries dataSeries : dataSeriesList) {
            dataSeries.add(priorCaptureTime, 0.0);
        }
        if (otherDataSeries != null) {
            otherDataSeries.add(priorCaptureTime, 0.0);
        }
    }

    void addGapIfNeeded(long lastCaptureTime, long captureTime, List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries) {
        long millisecondsSinceLastPoint = captureTime - lastCaptureTime;
        if (millisecondsSinceLastPoint <= this.dataPointIntervalMillis) {
            return;
        }
        for (DataSeries dataSeries : dataSeriesList) {
            this.addGap(dataSeries, lastCaptureTime, captureTime);
        }
        if (otherDataSeries != null) {
            this.addGap(otherDataSeries, lastCaptureTime, captureTime);
        }
    }

    void addFinalDownslopeIfNeeded(List<DataSeries> dataSeriesList, @Nullable DataSeries otherDataSeries, long lastCaptureTime) {
        long downslopeCaptureTime = this.finalDownslopeCaptureTime(lastCaptureTime);
        if (downslopeCaptureTime != 0L) {
            for (DataSeries dataSeries : dataSeriesList) {
                dataSeries.add(downslopeCaptureTime, 0.0);
            }
            if (otherDataSeries != null) {
                otherDataSeries.add(downslopeCaptureTime, 0.0);
            }
        }
    }

    void addInitialUpslopeIfNeeded(long requestFrom, long captureTime, DataSeries dataSeries) {
        if (captureTime == requestFrom) {
            return;
        }
        long priorCaptureTime = this.getPriorCaptureTime(captureTime);
        dataSeries.add(priorCaptureTime, 0.0);
    }

    void addGapIfNeeded(long lastCaptureTime, long captureTime, DataSeries dataSeries) {
        long millisecondsSinceLastPoint = captureTime - lastCaptureTime;
        if (millisecondsSinceLastPoint <= this.dataPointIntervalMillis) {
            return;
        }
        this.addGap(dataSeries, lastCaptureTime, captureTime);
    }

    void addFinalDownslopeIfNeeded(DataSeries dataSeries, long lastCaptureTime) {
        long downslopeCaptureTime = this.finalDownslopeCaptureTime(lastCaptureTime);
        if (downslopeCaptureTime != 0L) {
            dataSeries.add(downslopeCaptureTime, 0.0);
        }
    }

    private void addGap(DataSeries dataSeries, long lastCaptureTime, long captureTime) {
        long currentCaptureTime = this.getCurrentCaptureTime(captureTime);
        if (currentCaptureTime - lastCaptureTime == 2L * this.dataPointIntervalMillis) {
            dataSeries.add(lastCaptureTime + this.dataPointIntervalMillis, 0.0);
        } else {
            dataSeries.add(lastCaptureTime + this.dataPointIntervalMillis, 0.0);
            dataSeries.addNull();
            dataSeries.add(currentCaptureTime - this.dataPointIntervalMillis, 0.0);
        }
    }

    private long finalDownslopeCaptureTime(long lastCaptureTime) {
        if ((double)(this.liveCaptureTime - lastCaptureTime) > 1.5 * (double)this.dataPointIntervalMillis) {
            return lastCaptureTime + this.dataPointIntervalMillis;
        }
        return 0L;
    }

    private long getPriorCaptureTime(long captureTime) {
        return this.getCurrentCaptureTime(captureTime) - this.dataPointIntervalMillis;
    }

    private long getCurrentCaptureTime(long captureTime) {
        return CaptureTimes.getRollup((long)captureTime, (long)this.dataPointIntervalMillis);
    }
}

