/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.AggregateRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.shaded.org.glowroot.common.live.ImmutableSummaryQuery;
import org.glowroot.agent.shaded.org.glowroot.common.live.LiveAggregateRepository;
import org.glowroot.agent.shaded.org.glowroot.common.model.OverallErrorSummaryCollector;
import org.glowroot.agent.shaded.org.glowroot.common.model.Result;
import org.glowroot.agent.shaded.org.glowroot.common.model.TransactionNameErrorSummaryCollector;

class ErrorCommonService {
    private final AggregateRepository aggregateRepository;
    private final LiveAggregateRepository liveAggregateRepository;

    ErrorCommonService(AggregateRepository aggregateRepository, LiveAggregateRepository liveAggregateRepository) {
        this.aggregateRepository = aggregateRepository;
        this.liveAggregateRepository = liveAggregateRepository;
    }

    OverallErrorSummaryCollector readOverallErrorSummary(String agentRollupId, LiveAggregateRepository.SummaryQuery query, boolean autoRefresh) throws Exception {
        OverallErrorSummaryCollector collector = new OverallErrorSummaryCollector();
        long revisedFrom = query.from();
        long revisedTo = autoRefresh ? query.to() : this.liveAggregateRepository.mergeInOverallErrorSummary(agentRollupId, query, collector);
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableSummaryQuery revisedQuery = ImmutableSummaryQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            this.aggregateRepository.mergeOverallErrorSummaryInto(agentRollupId, (LiveAggregateRepository.SummaryQuery)revisedQuery, collector, CassandraProfile.web).toCompletableFuture().join();
            long lastRolledUpTime = collector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return collector;
    }

    Result<TransactionNameErrorSummaryCollector.TransactionNameErrorSummary> readTransactionNameErrorSummaries(String agentRollupId, LiveAggregateRepository.SummaryQuery query, TransactionNameErrorSummaryCollector.ErrorSummarySortOrder sortOrder, int limit, boolean autoRefresh) throws Exception {
        TransactionNameErrorSummaryCollector collector = new TransactionNameErrorSummaryCollector();
        long revisedFrom = query.from();
        long revisedTo = autoRefresh ? query.to() : this.liveAggregateRepository.mergeInTransactionNameErrorSummaries(agentRollupId, query, collector);
        for (int rollupLevel = query.rollupLevel(); rollupLevel >= 0; --rollupLevel) {
            ImmutableSummaryQuery revisedQuery = ImmutableSummaryQuery.builder().copyFrom(query).from(revisedFrom).to(revisedTo).rollupLevel(rollupLevel).build();
            this.aggregateRepository.mergeTransactionNameErrorSummariesInto(agentRollupId, (LiveAggregateRepository.SummaryQuery)revisedQuery, sortOrder, limit, collector, CassandraProfile.web).toCompletableFuture().join();
            long lastRolledUpTime = collector.getLastCaptureTime();
            revisedFrom = Math.max(revisedFrom, lastRolledUpTime + 1L);
            if (revisedFrom > revisedTo) break;
        }
        return collector.getResult(sortOrder, limit);
    }
}

