/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ChunkSource;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.CommonHandler;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.HttpSessionManager;
import org.glowroot.agent.shaded.com.google.common.collect.EvictingQueue;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.com.google.common.io.Files;
import org.glowroot.agent.shaded.com.google.common.io.LineProcessor;
import org.glowroot.agent.shaded.com.google.common.net.MediaType;
import org.glowroot.agent.shaded.com.google.common.primitives.Longs;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;

class GlowrootLogHttpService
implements HttpService {
    private static final int DEFAULT_MAX_LINES = 1000;
    private static final Ordering<File> byLastModified = new Ordering<File>(){

        public int compare(File left, File right) {
            return Longs.compare((long)left.lastModified(), (long)right.lastModified());
        }
    };
    private final File logDir;
    private final Pattern logFileNamePattern;

    GlowrootLogHttpService(File logDir, Pattern logFileNamePattern) {
        this.logDir = logDir;
        this.logFileNamePattern = logFileNamePattern;
    }

    @Override
    public String getPermission() {
        return "admin:view:log";
    }

    @Override
    public CommonHandler.CommonResponse handleRequest(CommonHandler.CommonRequest request, HttpSessionManager.Authentication authentication) throws Exception {
        List<String> maxLinesParams = request.getParameters("max-lines");
        if (maxLinesParams.isEmpty()) {
            CommonHandler.CommonResponse response = new CommonHandler.CommonResponse(HttpResponseStatus.FOUND);
            response.setHeader((CharSequence)HttpHeaderNames.LOCATION, "log?max-lines=1000");
            return response;
        }
        int maxLines = Integer.parseInt(maxLinesParams.get(0));
        File[] list = this.logDir.listFiles();
        if (list == null) {
            throw new IllegalStateException("Could not list directory: " + this.logDir.getAbsolutePath());
        }
        List<File> files = Lists.newArrayList();
        for (File file : list) {
            if (!file.isFile() || !this.logFileNamePattern.matcher(file.getName()).matches()) continue;
            files.add(file);
        }
        files = byLastModified.reverse().sortedCopy((Iterable)files);
        List lines = Lists.newArrayList();
        for (File file : files) {
            Collection olderLines = (Collection)Files.readLines((File)file, (Charset)Charset.defaultCharset(), (LineProcessor)new ReadLastNLines(maxLines + 1 - lines.size()));
            lines.addAll(0, olderLines);
            if (lines.size() <= maxLines) continue;
            break;
        }
        ArrayList chunkSources = Lists.newArrayList();
        if (lines.size() > maxLines) {
            lines = lines.subList(lines.size() - maxLines, lines.size());
            chunkSources.add(ChunkSource.wrap("[earlier log entries truncated]\n\n"));
        }
        for (String line : lines) {
            chunkSources.add(ChunkSource.wrap(line + '\n'));
        }
        return new CommonHandler.CommonResponse(HttpResponseStatus.OK, MediaType.PLAIN_TEXT_UTF_8, ChunkSource.concat(chunkSources));
    }

    private static class ReadLastNLines
    implements LineProcessor<Collection<String>> {
        private final Collection<String> queue;

        private ReadLastNLines(int nLines) {
            this.queue = EvictingQueue.create((int)nLines);
        }

        public boolean processLine(String line) {
            this.queue.add(line);
            return true;
        }

        public Collection<String> getResult() {
            return this.queue;
        }
    }
}

