/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.AllConfigDto;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.glowroot.agent.shaded.org.glowroot.common.config.PropertyValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AllConfigDto.PluginConfig", generator="Immutables")
@Immutable
final class ImmutablePluginConfig
extends AllConfigDto.PluginConfig {
    private final String id;
    private final ImmutableMap<String, PropertyValue> properties;

    private ImmutablePluginConfig(String id, ImmutableMap<String, PropertyValue> properties) {
        this.id = id;
        this.properties = properties;
    }

    @Override
    @JsonProperty(value="id")
    String id() {
        return this.id;
    }

    @JsonProperty(value="properties")
    ImmutableMap<String, PropertyValue> properties() {
        return this.properties;
    }

    public final ImmutablePluginConfig withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginConfig(newValue, this.properties);
    }

    public final ImmutablePluginConfig withProperties(Map<String, ? extends PropertyValue> entries) {
        if (this.properties == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutablePluginConfig(this.id, (ImmutableMap<String, PropertyValue>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginConfig && this.equalTo(0, (ImmutablePluginConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginConfig another) {
        return this.id.equals(another.id) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.properties.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PluginConfig").omitNullValues().add("id", (Object)this.id).add("properties", this.properties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginConfig fromJson(Json json) {
        Builder builder = ImmutablePluginConfig.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.properties != null) {
            builder.putAllProperties(json.properties);
        }
        return builder.build();
    }

    public static ImmutablePluginConfig copyOf(AllConfigDto.PluginConfig instance) {
        if (instance instanceof ImmutablePluginConfig) {
            return (ImmutablePluginConfig)instance;
        }
        return ImmutablePluginConfig.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AllConfigDto.PluginConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        private ImmutableMap.Builder<String, PropertyValue> properties = ImmutableMap.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(AllConfigDto.PluginConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.putAllProperties(instance.properties());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, PropertyValue value) {
            this.properties.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends PropertyValue> entry) {
            this.properties.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends PropertyValue> entries) {
            this.properties = ImmutableMap.builder();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends PropertyValue> entries) {
            this.properties.putAll(entries);
            return this;
        }

        public ImmutablePluginConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginConfig(this.id, this.properties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            return "Cannot build PluginConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AllConfigDto.PluginConfig", generator="Immutables")
    static final class Json
    extends AllConfigDto.PluginConfig {
        @Nullable
        String id;
        @Nullable
        Map<String, PropertyValue> properties = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="properties")
        public void setProperties(Map<String, PropertyValue> properties) {
            this.properties = properties;
        }

        @Override
        String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        Map<String, PropertyValue> properties() {
            throw new UnsupportedOperationException();
        }
    }
}

