/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.primitives.Booleans;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigJsonService.PluginResponse", generator="Immutables")
@Immutable
final class ImmutablePluginResponse
implements ConfigJsonService.PluginResponse {
    private final String id;
    private final String name;
    private final boolean hasConfig;

    private ImmutablePluginResponse(String id, String name, boolean hasConfig) {
        this.id = id;
        this.name = name;
        this.hasConfig = hasConfig;
    }

    @Override
    @JsonProperty(value="id")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="hasConfig")
    public boolean hasConfig() {
        return this.hasConfig;
    }

    public final ImmutablePluginResponse withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginResponse(newValue, this.name, this.hasConfig);
    }

    public final ImmutablePluginResponse withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutablePluginResponse(this.id, newValue, this.hasConfig);
    }

    public final ImmutablePluginResponse withHasConfig(boolean value) {
        if (this.hasConfig == value) {
            return this;
        }
        return new ImmutablePluginResponse(this.id, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePluginResponse && this.equalTo(0, (ImmutablePluginResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutablePluginResponse another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && this.hasConfig == another.hasConfig;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.hasConfig);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PluginResponse").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("hasConfig", this.hasConfig).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePluginResponse fromJson(Json json) {
        Builder builder = ImmutablePluginResponse.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.hasConfigIsSet) {
            builder.hasConfig(json.hasConfig);
        }
        return builder.build();
    }

    public static ImmutablePluginResponse copyOf(ConfigJsonService.PluginResponse instance) {
        if (instance instanceof ImmutablePluginResponse) {
            return (ImmutablePluginResponse)instance;
        }
        return ImmutablePluginResponse.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigJsonService.PluginResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_HAS_CONFIG = 4L;
        private long initBits = 7L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        private boolean hasConfig;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(ConfigJsonService.PluginResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.hasConfig(instance.hasConfig());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder hasConfig(boolean hasConfig) {
            this.hasConfig = hasConfig;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutablePluginResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePluginResponse(this.id, this.name, this.hasConfig);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("hasConfig");
            }
            return "Cannot build PluginResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfigJsonService.PluginResponse", generator="Immutables")
    static final class Json
    implements ConfigJsonService.PluginResponse {
        @Nullable
        String id;
        @Nullable
        String name;
        boolean hasConfig;
        boolean hasConfigIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="hasConfig")
        public void setHasConfig(boolean hasConfig) {
            this.hasConfig = hasConfig;
            this.hasConfigIsSet = true;
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

