/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableRolePermissionBlock;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.RoleConfigJsonService;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.agent.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.agent.shaded.com.google.common.base.MoreObjects;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RoleConfigJsonService.RoleConfigDto", generator="Immutables")
@Immutable
final class ImmutableRoleConfigDto
extends RoleConfigJsonService.RoleConfigDto {
    private final String name;
    private final ImmutableList<String> permissions;
    private final ImmutableList<ImmutableRolePermissionBlock> permissionBlocks;
    private final Optional<String> version;

    private ImmutableRoleConfigDto(String name, ImmutableList<String> permissions, ImmutableList<ImmutableRolePermissionBlock> permissionBlocks, Optional<String> version) {
        this.name = name;
        this.permissions = permissions;
        this.permissionBlocks = permissionBlocks;
        this.version = version;
    }

    @Override
    @JsonProperty(value="name")
    String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="permissions")
    ImmutableList<String> permissions() {
        return this.permissions;
    }

    @Override
    @JsonProperty(value="permissionBlocks")
    ImmutableList<ImmutableRolePermissionBlock> permissionBlocks() {
        return this.permissionBlocks;
    }

    @Override
    @JsonProperty(value="version")
    Optional<String> version() {
        return this.version;
    }

    public final ImmutableRoleConfigDto withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableRoleConfigDto(newValue, this.permissions, this.permissionBlocks, this.version);
    }

    public final ImmutableRoleConfigDto withPermissions(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleConfigDto(this.name, (ImmutableList<String>)newValue, this.permissionBlocks, this.version);
    }

    public final ImmutableRoleConfigDto withPermissions(Iterable<String> elements) {
        if (this.permissions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleConfigDto(this.name, (ImmutableList<String>)newValue, this.permissionBlocks, this.version);
    }

    public final ImmutableRoleConfigDto withPermissionBlocks(ImmutableRolePermissionBlock ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableRoleConfigDto(this.name, this.permissions, (ImmutableList<ImmutableRolePermissionBlock>)newValue, this.version);
    }

    public final ImmutableRoleConfigDto withPermissionBlocks(Iterable<? extends ImmutableRolePermissionBlock> elements) {
        if (this.permissionBlocks == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableRoleConfigDto(this.name, this.permissions, (ImmutableList<ImmutableRolePermissionBlock>)newValue, this.version);
    }

    public final ImmutableRoleConfigDto withVersion(String value) {
        Optional newValue = Optional.of((Object)value);
        if (this.version.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableRoleConfigDto(this.name, this.permissions, this.permissionBlocks, (Optional<String>)newValue);
    }

    public final ImmutableRoleConfigDto withVersion(Optional<String> optional) {
        Optional<String> value = optional;
        if (this.version.equals(value)) {
            return this;
        }
        return new ImmutableRoleConfigDto(this.name, this.permissions, this.permissionBlocks, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRoleConfigDto && this.equalTo(0, (ImmutableRoleConfigDto)another);
    }

    private boolean equalTo(int synthetic, ImmutableRoleConfigDto another) {
        return this.name.equals(another.name) && this.permissions.equals(another.permissions) && this.permissionBlocks.equals(another.permissionBlocks) && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.permissions.hashCode();
        h += (h << 5) + this.permissionBlocks.hashCode();
        h += (h << 5) + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RoleConfigDto").omitNullValues().add("name", (Object)this.name).add("permissions", this.permissions).add("permissionBlocks", this.permissionBlocks).add("version", this.version.orNull()).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRoleConfigDto fromJson(Json json) {
        Builder builder = ImmutableRoleConfigDto.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.permissions != null) {
            builder.addAllPermissions((Iterable<String>)json.permissions);
        }
        if (json.permissionBlocks != null) {
            builder.addAllPermissionBlocks((Iterable<? extends ImmutableRolePermissionBlock>)json.permissionBlocks);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static ImmutableRoleConfigDto copyOf(RoleConfigJsonService.RoleConfigDto instance) {
        if (instance instanceof ImmutableRoleConfigDto) {
            return (ImmutableRoleConfigDto)instance;
        }
        return ImmutableRoleConfigDto.builder().copyFrom(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RoleConfigJsonService.RoleConfigDto", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        private ImmutableList.Builder<String> permissions = ImmutableList.builder();
        private ImmutableList.Builder<ImmutableRolePermissionBlock> permissionBlocks = ImmutableList.builder();
        private Optional<String> version = Optional.absent();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder copyFrom(RoleConfigJsonService.RoleConfigDto instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.addAllPermissions((Iterable<String>)instance.permissions());
            this.addAllPermissionBlocks((Iterable<? extends ImmutableRolePermissionBlock>)instance.permissionBlocks());
            Optional<String> versionOptional = instance.version();
            if (versionOptional.isPresent()) {
                this.version(versionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissions(String element) {
            this.permissions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissions(String ... elements) {
            this.permissions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder permissions(Iterable<String> elements) {
            this.permissions = ImmutableList.builder();
            return this.addAllPermissions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPermissions(Iterable<String> elements) {
            this.permissions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissionBlocks(ImmutableRolePermissionBlock element) {
            this.permissionBlocks.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPermissionBlocks(ImmutableRolePermissionBlock ... elements) {
            this.permissionBlocks.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder permissionBlocks(Iterable<? extends ImmutableRolePermissionBlock> elements) {
            this.permissionBlocks = ImmutableList.builder();
            return this.addAllPermissionBlocks(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPermissionBlocks(Iterable<? extends ImmutableRolePermissionBlock> elements) {
            this.permissionBlocks.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(String version) {
            this.version = Optional.of((Object)version);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder version(Optional<String> version) {
            this.version = version;
            return this;
        }

        public ImmutableRoleConfigDto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRoleConfigDto(this.name, this.permissions.build(), this.permissionBlocks.build(), this.version);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build RoleConfigDto, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RoleConfigJsonService.RoleConfigDto", generator="Immutables")
    static final class Json
    extends RoleConfigJsonService.RoleConfigDto {
        @Nullable
        String name;
        @Nullable
        ImmutableList<String> permissions = ImmutableList.of();
        @Nullable
        ImmutableList<ImmutableRolePermissionBlock> permissionBlocks = ImmutableList.of();
        @Nullable
        Optional<String> version = Optional.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="permissions")
        public void setPermissions(ImmutableList<String> permissions) {
            this.permissions = permissions;
        }

        @JsonProperty(value="permissionBlocks")
        public void setPermissionBlocks(ImmutableList<ImmutableRolePermissionBlock> permissionBlocks) {
            this.permissionBlocks = permissionBlocks;
        }

        @JsonProperty(value="version")
        public void setVersion(Optional<String> version) {
            this.version = version;
        }

        @Override
        String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<String> permissions() {
            throw new UnsupportedOperationException();
        }

        @Override
        ImmutableList<ImmutableRolePermissionBlock> permissionBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        Optional<String> version() {
            throw new UnsupportedOperationException();
        }
    }
}

