/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.api.Instrumentation;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.LdapConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.Encryption;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.util.LazySecretKey;
import org.glowroot.agent.shaded.com.google.common.base.Preconditions;
import org.glowroot.agent.shaded.com.google.common.collect.Sets;
import org.immutables.value.Value;

class LdapAuthentication {
    LdapAuthentication() {
    }

    static Set<String> getGlowrootRoles(Set<String> ldapGroupDns, LdapConfig ldapConfig) {
        HashSet glowrootRoles = Sets.newHashSet();
        for (String ldapGroupDn : ldapGroupDns) {
            List<String> roles = ldapConfig.roleMappings().get(ldapGroupDn);
            if (roles == null) continue;
            glowrootRoles.addAll(roles);
        }
        return glowrootRoles;
    }

    static Set<String> authenticateAndGetLdapGroupDns(String username, String password, LdapConfig ldapConfig, @Nullable String passwordOverride, LazySecretKey lazySecretKey) throws Exception {
        String userDn;
        LdapContext ldapContext;
        String systemUsername = ldapConfig.username();
        String systemPassword = LdapAuthentication.getPassword(ldapConfig, passwordOverride, lazySecretKey);
        try {
            ldapContext = LdapAuthentication.createLdapContext(systemUsername, systemPassword, ldapConfig);
        }
        catch (NamingException e) {
            throw new AuthenticationException("System LDAP authentication failed", e);
        }
        try {
            userDn = LdapAuthentication.getUserDn(ldapContext, username, ldapConfig);
        }
        catch (NamingException e) {
            throw new AuthenticationException(e);
        }
        if (userDn == null) {
            throw new AuthenticationException("User not found: " + username);
        }
        try {
            LdapAuthentication.createLdapContext(userDn, password, ldapConfig);
            return LdapAuthentication.getGroupDnsForUserDn(ldapContext, userDn, ldapConfig);
        }
        catch (NamingException e) {
            throw new AuthenticationException(e);
        }
    }

    @Instrumentation.TraceEntry(message="create ldap context", timer="ldap")
    private static LdapContext createLdapContext(String username, String password, LdapConfig ldapConfig) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", username);
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapConfig.url());
        env.put("com.sun.jndi.ldap.connect.timeout", "10000");
        return new InitialLdapContext(env, null);
    }

    private static String getPassword(LdapConfig ldapConfig, @Nullable String passwordOverride, LazySecretKey lazySecretKey) throws Exception {
        if (passwordOverride != null) {
            return passwordOverride;
        }
        String password = ldapConfig.encryptedPassword();
        if (password.isEmpty()) {
            return "";
        }
        return Encryption.decrypt(password, lazySecretKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Instrumentation.TraceEntry(message="get ldap user DN for username: {{1}}", timer="ldap")
    private static @Nullable String getUserDn(LdapContext ldapContext, String username, LdapConfig ldapConfig) throws NamingException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        try (NamingEnumeration<SearchResult> namingEnum = ldapContext.search(ldapConfig.userBaseDn(), ldapConfig.userSearchFilter(), (Object[])new String[]{username}, searchCtls);){
            if (!namingEnum.hasMore()) {
                String string = null;
                return string;
            }
            SearchResult result = (SearchResult)Preconditions.checkNotNull((Object)namingEnum.next());
            String userDn = result.getNameInNamespace();
            if (namingEnum.hasMore()) {
                throw new IllegalStateException("More than matching user: " + username);
            }
            String string = userDn;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Instrumentation.TraceEntry(message="get ldap group DNs for user DN: {{1}}", timer="ldap")
    private static Set<String> getGroupDnsForUserDn(LdapContext ldapContext, String userDn, LdapConfig ldapConfig) throws NamingException {
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        try (NamingEnumeration<SearchResult> namingEnum = ldapContext.search(ldapConfig.groupBaseDn(), ldapConfig.groupSearchFilter(), (Object[])new String[]{userDn}, searchCtls);){
            HashSet ldapGroups = Sets.newHashSet();
            while (namingEnum.hasMore()) {
                SearchResult result = (SearchResult)Preconditions.checkNotNull((Object)namingEnum.next());
                ldapGroups.add(result.getNameInNamespace());
            }
            HashSet hashSet = ldapGroups;
            return hashSet;
        }
    }

    static class AuthenticationException
    extends Exception {
        AuthenticationException(String message) {
            super(message);
        }

        private AuthenticationException(Throwable cause) {
            super(cause);
        }

        private AuthenticationException(String message, @Nullable Throwable cause) {
            super(message, cause);
        }
    }

    @Value.Immutable
    static interface AuthenticationResult {
        public String userDn();

        public Set<String> ldapGroupDns();
    }
}

