/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.glowroot.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.ImmutableRoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.PermissionParser;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.config.RoleConfig;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ActiveAgentRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.CassandraProfile;
import org.glowroot.agent.embedded.shaded.org.glowroot.common2.repo.ConfigRepository;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.BindRequest;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.GET;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableFlattenedAgentRollup;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableRoleConfigDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableRoleConfigListDto;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableRoleConfigResponse;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.ImmutableRolePermissionBlock;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonService;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.JsonServiceException;
import org.glowroot.agent.embedded.shaded.org.glowroot.ui.POST;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.Module;
import org.glowroot.agent.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.agent.shaded.com.google.common.base.Optional;
import org.glowroot.agent.shaded.com.google.common.collect.HashMultimap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.Lists;
import org.glowroot.agent.shaded.com.google.common.collect.Ordering;
import org.glowroot.agent.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.glowroot.agent.shaded.org.glowroot.common.util.ObjectMappers;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.immutables.value.Value;

@JsonService
class RoleConfigJsonService {
    private static final Logger logger = LoggerFactory.getLogger(RoleConfigJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create((Module[])new Module[0]);
    private static final Ordering<RoleConfig> orderingByName = new Ordering<RoleConfig>(){

        public int compare(RoleConfig left, RoleConfig right) {
            return left.name().compareToIgnoreCase(right.name());
        }
    };
    private final boolean central;
    private final ConfigRepository configRepository;
    private final ActiveAgentRepository activeAgentRepository;

    RoleConfigJsonService(boolean central, ConfigRepository configRepository, ActiveAgentRepository activeAgentRepository) {
        this.central = central;
        this.configRepository = configRepository;
        this.activeAgentRepository = activeAgentRepository;
    }

    @GET(path="/backend/admin/roles", permission="admin:view:role")
    String getRoleConfig(@BindRequest RoleConfigRequest request) throws Exception {
        Optional<String> name = request.name();
        if (name.isPresent()) {
            return this.getRoleConfigInternal((String)name.get());
        }
        ArrayList responses = Lists.newArrayList();
        ImmutableList roleConfigs = this.configRepository.getRoleConfigs().toCompletableFuture().join();
        roleConfigs = orderingByName.immutableSortedCopy(roleConfigs);
        for (RoleConfig roleConfig : roleConfigs) {
            responses.add(RoleConfigListDto.create(roleConfig));
        }
        return mapper.writeValueAsString((Object)responses);
    }

    @GET(path="/backend/admin/all-active-agent-rollups", permission="admin:edit:role")
    String getAllAgentRollups() throws Exception {
        return mapper.writeValueAsString(this.getFlattenedAgentRollups());
    }

    @POST(path="/backend/admin/roles/add", permission="admin:edit:role")
    String addRole(@BindRequest RoleConfigDto roleConfigDto) throws Exception {
        RoleConfig roleConfig = roleConfigDto.convert(this.central);
        try {
            this.configRepository.insertRoleConfig(roleConfig, CassandraProfile.web).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof ConfigRepository.DuplicateRoleNameException) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new JsonServiceException(HttpResponseStatus.CONFLICT, "name");
            }
            throw (Exception)e.getCause();
        }
        return this.getRoleConfigInternal(roleConfig.name());
    }

    @POST(path="/backend/admin/roles/update", permission="admin:edit:role")
    String updateRole(@BindRequest RoleConfigDto roleConfigDto) throws Exception {
        RoleConfig roleConfig = roleConfigDto.convert(this.central);
        String version = (String)roleConfigDto.version().get();
        try {
            this.configRepository.updateRoleConfig(roleConfig, version, CassandraProfile.web).toCompletableFuture().join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof ConfigRepository.DuplicateRoleNameException) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new JsonServiceException(HttpResponseStatus.CONFLICT, "name");
            }
            throw (Exception)e.getCause();
        }
        return this.getRoleConfigInternal(roleConfig.name());
    }

    @POST(path="/backend/admin/roles/remove", permission="admin:edit:role")
    String removeRole(@BindRequest RoleConfigRequest request) throws Exception {
        try {
            try {
                this.configRepository.deleteRoleConfig((String)request.name().get(), CassandraProfile.web).toCompletableFuture().join();
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof ConfigRepository.CannotDeleteLastRoleException) {
                    throw (ConfigRepository.CannotDeleteLastRoleException)e.getCause();
                }
                throw e;
            }
        }
        catch (ConfigRepository.CannotDeleteLastRoleException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            return "{\"errorCannotDeleteLastRole\":true}";
        }
        return "{}";
    }

    private String getRoleConfigInternal(String name) throws Exception {
        RoleConfig roleConfig = this.configRepository.getRoleConfig(name).toCompletableFuture().join();
        if (roleConfig == null) {
            throw new JsonServiceException(HttpResponseStatus.NOT_FOUND);
        }
        ImmutableRoleConfigResponse.Builder response = ImmutableRoleConfigResponse.builder().config(RoleConfigDto.create(roleConfig, this.central));
        if (this.central) {
            response.allActiveAgentRollups(this.getFlattenedAgentRollups());
        }
        return mapper.writeValueAsString((Object)response.build());
    }

    private List<FlattenedAgentRollup> getFlattenedAgentRollups() {
        List<ActiveAgentRepository.AgentRollup> agentRollups = this.activeAgentRepository.readRecentlyActiveAgentRollups(TimeUnit.DAYS.toMillis(7L), CassandraProfile.web).toCompletableFuture().join();
        ArrayList flattenedAgentRollups = Lists.newArrayList();
        for (ActiveAgentRepository.AgentRollup agentRollup : agentRollups) {
            flattenedAgentRollups.addAll(RoleConfigJsonService.getFlattenedAgentRollups(agentRollup, 0));
        }
        return flattenedAgentRollups;
    }

    private static List<FlattenedAgentRollup> getFlattenedAgentRollups(ActiveAgentRepository.AgentRollup agentRollup, int depth) {
        ArrayList flattenedAgentRollups = Lists.newArrayList();
        flattenedAgentRollups.add(ImmutableFlattenedAgentRollup.builder().id(agentRollup.id()).display(agentRollup.display()).lastDisplayPart(agentRollup.lastDisplayPart()).depth(depth).build());
        for (ActiveAgentRepository.AgentRollup childAgentRollup : agentRollup.children()) {
            flattenedAgentRollups.addAll(RoleConfigJsonService.getFlattenedAgentRollups(childAgentRollup, depth + 1));
        }
        return flattenedAgentRollups;
    }

    @Value.Immutable
    static interface RolePermissionBlock {
        public ImmutableList<String> agentRollupIds();

        public ImmutableList<String> permissions();
    }

    @Value.Immutable
    static abstract class RoleConfigDto {
        RoleConfigDto() {
        }

        abstract String name();

        abstract ImmutableList<String> permissions();

        abstract ImmutableList<ImmutableRolePermissionBlock> permissionBlocks();

        abstract Optional<String> version();

        private RoleConfig convert(boolean central) {
            ImmutableRoleConfig.Builder builder = ImmutableRoleConfig.builder().central(central).name(this.name());
            if (central) {
                for (String permission : this.permissions()) {
                    if (permission.startsWith("agent:")) {
                        builder.addPermissions("agent:*:" + permission.substring("agent:".length()));
                        continue;
                    }
                    builder.addPermissions(permission);
                }
            } else {
                builder.addAllPermissions((Iterable<String>)this.permissions());
            }
            for (RolePermissionBlock permissionBlock : this.permissionBlocks()) {
                String agentIds = PermissionParser.quoteIfNeededAndJoin(permissionBlock.agentRollupIds());
                for (String permission : permissionBlock.permissions()) {
                    builder.addPermissions("agent:" + agentIds + ":" + permission.substring("agent:".length()));
                }
            }
            return builder.build();
        }

        private static RoleConfigDto create(RoleConfig roleConfig, boolean central) {
            ImmutableRoleConfigDto.Builder builder = ImmutableRoleConfigDto.builder().name(roleConfig.name());
            if (central) {
                HashMultimap permissionBlocks = HashMultimap.create();
                for (String permission : roleConfig.permissions()) {
                    if (permission.startsWith("agent:")) {
                        PermissionParser parser = new PermissionParser(permission);
                        parser.parse();
                        if (parser.getAgentRollupIds().size() == 1 && parser.getAgentRollupIds().get(0).equals("*")) {
                            builder.addPermissions(parser.getPermission());
                            continue;
                        }
                        List agentIds = Ordering.natural().sortedCopy(parser.getAgentRollupIds());
                        permissionBlocks.put((Object)agentIds, (Object)parser.getPermission());
                        continue;
                    }
                    builder.addPermissions(permission);
                }
                for (Map.Entry entry : permissionBlocks.asMap().entrySet()) {
                    builder.addPermissionBlocks(ImmutableRolePermissionBlock.builder().addAllAgentRollupIds((Iterable)entry.getKey()).addAllPermissions((Iterable)entry.getValue()).build());
                }
            } else {
                builder.addAllPermissions((Iterable<String>)roleConfig.permissions());
            }
            return builder.version(roleConfig.version()).build();
        }
    }

    @Value.Immutable
    static abstract class RoleConfigListDto {
        RoleConfigListDto() {
        }

        abstract String name();

        abstract String version();

        private static RoleConfigListDto create(RoleConfig config) {
            return ImmutableRoleConfigListDto.builder().name(config.name()).version(config.version()).build();
        }
    }

    @Value.Immutable
    static interface FlattenedAgentRollup {
        public int depth();

        public String id();

        public String display();

        public String lastDisplayPart();
    }

    @Value.Immutable
    static interface RoleConfigResponse {
        public RoleConfigDto config();

        public ImmutableList<FlattenedAgentRollup> allActiveAgentRollups();
    }

    @Value.Immutable
    static interface RoleConfigRequest {
        public Optional<String> name();
    }
}

