/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.embedded.shaded.org.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.glowroot.agent.embedded.shaded.org.h2.compress.Compressor;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.Chunk;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.DataUtils;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.FileStore;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.MVMap;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.MVStore;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.WriteBuffer;
import org.glowroot.agent.embedded.shaded.org.h2.mvstore.type.DataType;

public class Page {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final MVMap<?, ?> map;
    private long version;
    private long pos;
    private long totalCount;
    private int keyCount;
    private int childCount;
    private int cachedCompare;
    private int sharedFlags;
    private int memory;
    private Object[] keys;
    private Object[] values;
    private long[] children;
    private Page[] childrenPages;
    private long[] counts;

    Page(MVMap<?, ?> mVMap, long l) {
        this.map = mVMap;
        this.version = l;
    }

    static Page createEmpty(MVMap<?, ?> mVMap, long l) {
        return Page.create(mVMap, l, 0, EMPTY_OBJECT_ARRAY, EMPTY_OBJECT_ARRAY, 0, null, null, null, 0L, 0, 128);
    }

    public static Page create(MVMap<?, ?> mVMap, long l, int n, Object[] objectArray, Object[] objectArray2, int n2, long[] lArray, Page[] pageArray, long[] lArray2, long l2, int n3, int n4) {
        Page page = new Page(mVMap, l);
        page.keyCount = n;
        page.keys = objectArray;
        page.values = objectArray2;
        page.childCount = n2;
        page.children = lArray;
        page.childrenPages = pageArray;
        page.counts = lArray2;
        page.totalCount = l2;
        page.sharedFlags = n3;
        if (n4 == 0) {
            page.recalculateMemory();
        } else {
            page.addMemory(n4);
        }
        MVStore mVStore = mVMap.store;
        if (mVStore != null) {
            mVStore.registerUnsavedPage(page.memory);
        }
        return page;
    }

    static Page read(FileStore fileStore, MVMap<?, ?> mVMap, long l, long l2, long l3) {
        int n;
        ByteBuffer byteBuffer;
        int n2 = DataUtils.getPageMaxLength(l);
        if (n2 == 0x200000) {
            byteBuffer = fileStore.readFully(l2, 128);
            n2 = byteBuffer.getInt();
        }
        if ((n = (n2 = (int)Math.min(l3 - l2, (long)n2))) < 0) {
            throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; file size {2} ", n, l2, l3);
        }
        byteBuffer = fileStore.readFully(l2, n);
        Page page = new Page(mVMap, 0L);
        page.pos = l;
        int n3 = DataUtils.getPageChunkId(l);
        int n4 = DataUtils.getPageOffset(l);
        page.read(byteBuffer, n3, n4, n2);
        return page;
    }

    public Object getKey(int n) {
        return this.keys[n];
    }

    public Page getChildPage(int n) {
        Page page = this.childrenPages[n];
        return page != null ? page : this.map.readPage(this.children[n]);
    }

    public Object getValue(int n) {
        return this.values[n];
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public long getPos() {
        return this.pos;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id: ").append(System.identityHashCode(this)).append('\n');
        stringBuilder.append("pos: ").append(Long.toHexString(this.pos)).append("\n");
        for (int i = 0; i <= this.keyCount; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            if (this.children != null) {
                stringBuilder.append("[" + Long.toHexString(this.children[i]) + "] ");
            }
            if (i >= this.keyCount) continue;
            stringBuilder.append(this.keys[i]);
            if (this.values == null) continue;
            stringBuilder.append(':');
            stringBuilder.append(this.values[i]);
        }
        return stringBuilder.toString();
    }

    public Page copy(long l) {
        Page page = Page.create(this.map, l, this.keyCount, this.keys, this.values, this.childCount, this.children, this.childrenPages, this.counts, this.totalCount, 15, this.getMemory());
        this.removePage();
        page.cachedCompare = this.cachedCompare;
        return page;
    }

    public int binarySearch(Object object) {
        int n = 0;
        int n2 = this.keyCount - 1;
        int n3 = this.cachedCompare - 1;
        if (n3 < 0 || n3 > n2) {
            n3 = n + n2 >>> 1;
        }
        Object[] objectArray = this.keys;
        while (n <= n2) {
            int n4 = this.map.compare(object, objectArray[n3]);
            if (n4 > 0) {
                n = n3 + 1;
            } else if (n4 < 0) {
                n2 = n3 - 1;
            } else {
                this.cachedCompare = n3 + 1;
                return n3;
            }
            n3 = n + n2 >>> 1;
        }
        this.cachedCompare = n;
        return -(n + 1);
    }

    Page split(int n) {
        return this.isLeaf() ? this.splitLeaf(n) : this.splitNode(n);
    }

    private Page splitLeaf(int n) {
        int n2 = n;
        int n3 = this.keyCount - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2, objectArray2, 0, n3);
        this.keys = objectArray;
        this.keyCount = n2;
        Object[] objectArray3 = new Object[n2];
        Object[] objectArray4 = new Object[n3];
        objectArray4 = new Object[n3];
        System.arraycopy(this.values, 0, objectArray3, 0, n2);
        System.arraycopy(this.values, n2, objectArray4, 0, n3);
        this.values = objectArray3;
        this.sharedFlags &= 0xFFFFFFFC;
        this.totalCount = n2;
        Page page = Page.create(this.map, this.version, n3, objectArray2, objectArray4, 0, null, null, null, objectArray2.length, 0, 0);
        this.recalculateMemory();
        page.recalculateMemory();
        return page;
    }

    private Page splitNode(int n) {
        int n2 = n;
        int n3 = this.keyCount - n2;
        Object[] objectArray = new Object[n2];
        Object[] objectArray2 = new Object[n3 - 1];
        System.arraycopy(this.keys, 0, objectArray, 0, n2);
        System.arraycopy(this.keys, n2 + 1, objectArray2, 0, n3 - 1);
        this.keys = objectArray;
        this.keyCount = n2;
        long[] lArray = new long[n2 + 1];
        long[] lArray2 = new long[n3];
        System.arraycopy(this.children, 0, lArray, 0, n2 + 1);
        System.arraycopy(this.children, n2 + 1, lArray2, 0, n3);
        this.children = lArray;
        Page[] pageArray = new Page[n2 + 1];
        Page[] pageArray2 = new Page[n3];
        System.arraycopy(this.childrenPages, 0, pageArray, 0, n2 + 1);
        System.arraycopy(this.childrenPages, n2 + 1, pageArray2, 0, n3);
        this.childrenPages = pageArray;
        long[] lArray3 = new long[n2 + 1];
        long[] lArray4 = new long[n3];
        System.arraycopy(this.counts, 0, lArray3, 0, n2 + 1);
        System.arraycopy(this.counts, n2 + 1, lArray4, 0, n3);
        this.counts = lArray3;
        this.childCount = n2 + 1;
        this.sharedFlags &= 0xFFFFFFF2;
        long l = 0L;
        for (long l2 : lArray3) {
            l += l2;
        }
        this.totalCount = l;
        l = 0L;
        for (long l2 : lArray4) {
            l += l2;
        }
        Object object = Page.create(this.map, this.version, n3 - 1, objectArray2, null, n3, lArray2, pageArray2, lArray4, l, 0, 0);
        this.recalculateMemory();
        super.recalculateMemory();
        return object;
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    long getCounts(int n) {
        return this.counts[n];
    }

    public void setChild(int n, Page page) {
        if (page != this.childrenPages[n] || page.getPos() != this.children[n]) {
            if ((this.sharedFlags & 4) != 0) {
                this.children = Arrays.copyOf(this.children, this.children.length);
                this.childrenPages = Arrays.copyOf(this.childrenPages, this.childrenPages.length);
                this.sharedFlags &= 0xFFFFFFFB;
            }
            this.children[n] = page.getPos();
            this.childrenPages[n] = page;
        }
    }

    public void setCounts(int n, Page page) {
        this.setCounts(n, page.totalCount);
    }

    private void setCounts(int n, long l) {
        if (l != this.counts[n]) {
            if ((this.sharedFlags & 8) != 0) {
                this.counts = Arrays.copyOf(this.counts, this.counts.length);
                this.sharedFlags &= 0xFFFFFFF7;
            }
            long l2 = this.counts[n];
            this.counts[n] = l;
            this.totalCount += this.counts[n] - l2;
        }
    }

    public void setKey(int n, Object object) {
        if ((this.sharedFlags & 1) != 0) {
            this.keys = Arrays.copyOf(this.keys, this.keys.length);
            this.sharedFlags &= 0xFFFFFFFE;
        }
        Object object2 = this.keys[n];
        DataType dataType = this.map.getKeyType();
        int n2 = dataType.getMemory(object);
        if (object2 != null) {
            n2 -= dataType.getMemory(object2);
        }
        this.addMemory(n2);
        this.keys[n] = object;
    }

    public Object setValue(int n, Object object) {
        Object object2 = this.values[n];
        if ((this.sharedFlags & 2) != 0) {
            this.values = Arrays.copyOf(this.values, this.values.length);
            this.sharedFlags &= 0xFFFFFFFD;
        }
        DataType dataType = this.map.getValueType();
        this.addMemory(dataType.getMemory(object) - dataType.getMemory(object2));
        this.values[n] = object;
        return object2;
    }

    void removeAllRecursive() {
        if (this.children != null) {
            int n = this.childCount;
            for (int i = 0; i < n; ++i) {
                Page page = this.childrenPages[i];
                if (page != null) {
                    page.removeAllRecursive();
                    continue;
                }
                long l = this.children[i];
                int n2 = DataUtils.getPageType(l);
                if (n2 == 0) {
                    int n3 = DataUtils.getPageMaxLength(l);
                    this.map.removePage(l, n3);
                    continue;
                }
                this.map.readPage(l).removeAllRecursive();
            }
        }
        this.removePage();
    }

    public void insertLeaf(int n, Object object, Object object2) {
        if ((this.sharedFlags & 1) == 0 && this.keys.length > this.keyCount + 1) {
            if (n < this.keyCount) {
                System.arraycopy(this.keys, n, this.keys, n + 1, this.keyCount - n);
                System.arraycopy(this.values, n, this.values, n + 1, this.keyCount - n);
            }
        } else {
            int n2 = this.keyCount + 6;
            Object[] objectArray = new Object[n2];
            DataUtils.copyWithGap(this.keys, objectArray, this.keyCount, n);
            this.keys = objectArray;
            Object[] objectArray2 = new Object[n2];
            DataUtils.copyWithGap(this.values, objectArray2, this.keyCount, n);
            this.values = objectArray2;
        }
        this.keys[n] = object;
        this.values[n] = object2;
        ++this.keyCount;
        this.sharedFlags &= 0xFFFFFFFC;
        ++this.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + this.map.getValueType().getMemory(object2));
    }

    public void insertNode(int n, Object object, Page page) {
        Object[] objectArray = new Object[this.keyCount + 1];
        DataUtils.copyWithGap(this.keys, objectArray, this.keyCount, n);
        objectArray[n] = object;
        this.keys = objectArray;
        ++this.keyCount;
        long[] lArray = new long[this.childCount + 1];
        DataUtils.copyWithGap(this.children, lArray, this.childCount, n);
        lArray[n] = page.getPos();
        this.children = lArray;
        Page[] pageArray = new Page[this.childCount + 1];
        DataUtils.copyWithGap(this.childrenPages, pageArray, this.childCount, n);
        pageArray[n] = page;
        this.childrenPages = pageArray;
        long[] lArray2 = new long[this.childCount + 1];
        DataUtils.copyWithGap(this.counts, lArray2, this.childCount, n);
        lArray2[n] = page.totalCount;
        this.counts = lArray2;
        ++this.childCount;
        this.sharedFlags &= 0xFFFFFFF2;
        this.totalCount += page.totalCount;
        this.addMemory(this.map.getKeyType().getMemory(object) + 16);
    }

    public void remove(int n) {
        Object[] objectArray;
        int n2 = n >= this.keyCount ? n - 1 : n;
        Object object = this.keys[n2];
        this.addMemory(-this.map.getKeyType().getMemory(object));
        if ((this.sharedFlags & 1) == 0 && this.keys.length > this.keyCount - 4) {
            if (n2 < this.keyCount - 1) {
                System.arraycopy(this.keys, n2 + 1, this.keys, n2, this.keyCount - n2 - 1);
            }
            this.keys[this.keyCount - 1] = null;
        } else {
            objectArray = new Object[this.keyCount - 1];
            DataUtils.copyExcept(this.keys, objectArray, this.keyCount, n2);
            this.keys = objectArray;
            this.sharedFlags &= 0xFFFFFFFE;
        }
        if (this.values != null) {
            object = this.values[n];
            this.addMemory(-this.map.getValueType().getMemory(object));
            if ((this.sharedFlags & 2) == 0 && this.values.length > this.keyCount - 4) {
                if (n < this.keyCount - 1) {
                    System.arraycopy(this.values, n + 1, this.values, n, this.keyCount - n - 1);
                }
                this.values[this.keyCount - 1] = null;
            } else {
                objectArray = new Object[this.keyCount - 1];
                DataUtils.copyExcept(this.values, objectArray, this.keyCount, n);
                this.values = objectArray;
                this.sharedFlags &= 0xFFFFFFFD;
            }
            --this.totalCount;
        }
        --this.keyCount;
        if (this.children != null) {
            this.addMemory(-16);
            long l = this.counts[n];
            long[] lArray = new long[this.childCount - 1];
            DataUtils.copyExcept(this.children, lArray, this.childCount, n);
            this.children = lArray;
            Page[] pageArray = new Page[this.childCount - 1];
            DataUtils.copyExcept(this.childrenPages, pageArray, this.childCount, n);
            this.childrenPages = pageArray;
            long[] lArray2 = new long[this.childCount - 1];
            DataUtils.copyExcept(this.counts, lArray2, this.childCount, n);
            this.counts = lArray2;
            this.sharedFlags &= 0xFFFFFFF3;
            this.totalCount -= l;
            --this.childCount;
        }
    }

    void read(ByteBuffer byteBuffer, int n, int n2, int n3) {
        boolean bl;
        int n4;
        boolean bl2;
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.getInt();
        if (n6 > n3) {
            throw DataUtils.newIllegalStateException(6, "File corrupted, expected page length =< {0}, got {1}", n3, n6);
        }
        short s = byteBuffer.getShort();
        int n7 = DataUtils.readVarInt(byteBuffer);
        if (n7 != this.map.getId()) {
            throw DataUtils.newIllegalStateException(6, "File corrupted, expected map id {0}, got {1}", this.map.getId(), n7);
        }
        int n8 = DataUtils.getCheckValue(n) ^ DataUtils.getCheckValue(n2) ^ DataUtils.getCheckValue(n6);
        if (s != (short)n8) {
            throw DataUtils.newIllegalStateException(6, "File corrupted, expected check value {0}, got {1}", n8, s);
        }
        int n9 = DataUtils.readVarInt(byteBuffer);
        this.keys = new Object[n9];
        this.keyCount = n9;
        byte by = byteBuffer.get();
        boolean bl3 = bl2 = (by & 1) == 1;
        if (bl2) {
            this.childCount = n9 + 1;
            this.children = new long[n9 + 1];
            for (int i = 0; i <= n9; ++i) {
                this.children[i] = byteBuffer.getLong();
            }
            this.childrenPages = new Page[n9 + 1];
            this.counts = new long[n9 + 1];
            long l = 0L;
            for (n4 = 0; n4 <= n9; ++n4) {
                long l2 = DataUtils.readVarLong(byteBuffer);
                l += l2;
                this.counts[n4] = l2;
            }
            this.totalCount = l;
        }
        boolean bl4 = bl = (by & 2) != 0;
        if (bl) {
            Compressor compressor = (by & 6) == 6 ? this.map.getStore().getCompressorHigh() : this.map.getStore().getCompressorFast();
            n4 = DataUtils.readVarInt(byteBuffer);
            int n10 = n6 + n5 - byteBuffer.position();
            byte[] byArray = DataUtils.newBytes(n10);
            byteBuffer.get(byArray);
            int n11 = n10 + n4;
            byteBuffer = ByteBuffer.allocate(n11);
            compressor.expand(byArray, 0, n10, byteBuffer.array(), byteBuffer.arrayOffset(), n11);
        }
        this.map.getKeyType().read(byteBuffer, this.keys, n9, true);
        if (!bl2) {
            this.values = new Object[n9];
            this.map.getValueType().read(byteBuffer, this.values, n9, false);
            this.totalCount = n9;
        }
        this.recalculateMemory();
    }

    private int write(Chunk chunk, WriteBuffer writeBuffer) {
        int n;
        int n2;
        int n3;
        int n4 = writeBuffer.position();
        int n5 = this.keyCount;
        int n6 = this.children != null ? 1 : 0;
        writeBuffer.putInt(0).putShort((short)0).putVarInt(this.map.getId()).putVarInt(n5);
        int n7 = writeBuffer.position();
        writeBuffer.put((byte)n6);
        if (n6 == 1) {
            this.writeChildren(writeBuffer);
            for (n3 = 0; n3 <= n5; ++n3) {
                writeBuffer.putVarLong(this.counts[n3]);
            }
        }
        n3 = writeBuffer.position();
        this.map.getKeyType().write(writeBuffer, this.keys, n5, true);
        if (n6 == 0) {
            this.map.getValueType().write(writeBuffer, this.values, n5, false);
        }
        MVStore mVStore = this.map.getStore();
        int n8 = writeBuffer.position() - n3;
        if (n8 > 16 && (n2 = mVStore.getCompressionLevel()) > 0) {
            Compressor compressor;
            if (n2 == 1) {
                compressor = this.map.getStore().getCompressorFast();
                n = 2;
            } else {
                compressor = this.map.getStore().getCompressorHigh();
                n = 6;
            }
            byte[] byArray = new byte[n8];
            writeBuffer.position(n3).get(byArray);
            byte[] byArray2 = new byte[n8 * 2];
            int n9 = compressor.compress(byArray, n8, byArray2, 0);
            int n10 = DataUtils.getVarIntLen(n9 - n8);
            if (n9 + n10 < n8) {
                writeBuffer.position(n7).put((byte)(n6 + n));
                writeBuffer.position(n3).putVarInt(n8 - n9).put(byArray2, 0, n9);
            }
        }
        n2 = writeBuffer.position() - n4;
        int n11 = chunk.id;
        n = DataUtils.getCheckValue(n11) ^ DataUtils.getCheckValue(n4) ^ DataUtils.getCheckValue(n2);
        writeBuffer.putInt(n4, n2).putShort(n4 + 4, (short)n);
        if (this.pos != 0L) {
            throw DataUtils.newIllegalStateException(3, "Page already stored", new Object[0]);
        }
        this.pos = DataUtils.getPagePos(n11, n4, n2, n6);
        mVStore.cachePage(this.pos, this, this.getMemory());
        long l = DataUtils.getPageMaxLength(this.pos);
        chunk.maxLen += l;
        chunk.maxLenLive += l;
        ++chunk.pageCount;
        ++chunk.pageCountLive;
        return n7 + 1;
    }

    private void writeChildren(WriteBuffer writeBuffer) {
        int n = this.keyCount;
        for (int i = 0; i <= n; ++i) {
            writeBuffer.putLong(this.children[i]);
        }
    }

    void writeUnsavedRecursive(Chunk chunk, WriteBuffer writeBuffer) {
        if (this.pos != 0L) {
            return;
        }
        int n = this.write(chunk, writeBuffer);
        if (!this.isLeaf()) {
            int n2;
            int n3 = this.childCount;
            for (n2 = 0; n2 < n3; ++n2) {
                Page page = this.childrenPages[n2];
                if (page == null) continue;
                page.writeUnsavedRecursive(chunk, writeBuffer);
                this.children[n2] = page.getPos();
            }
            n2 = writeBuffer.position();
            writeBuffer.position(n);
            this.writeChildren(writeBuffer);
            writeBuffer.position(n2);
        }
    }

    void writeEnd() {
        if (!this.isLeaf()) {
            int n = this.childCount;
            for (int i = 0; i < n; ++i) {
                Page page = this.childrenPages[i];
                if (page == null) continue;
                if (page.getPos() == 0L) {
                    throw DataUtils.newIllegalStateException(3, "Page not written", new Object[0]);
                }
                page.writeEnd();
                this.childrenPages[i] = null;
            }
        }
    }

    long getVersion() {
        return this.version;
    }

    public int getChildPageCount() {
        return this.childCount;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Page) {
            if (this.pos != 0L && ((Page)object).pos == this.pos) {
                return true;
            }
            return this == object;
        }
        return false;
    }

    public int hashCode() {
        return this.pos != 0L ? (int)(this.pos | this.pos >>> 32) : super.hashCode();
    }

    public int getMemory() {
        return this.memory;
    }

    private void addMemory(int n) {
        this.memory += n;
    }

    private void recalculateMemory() {
        int n = 128;
        DataType dataType = this.map.getKeyType();
        for (int i = 0; i < this.keyCount; ++i) {
            n += dataType.getMemory(this.keys[i]);
        }
        if (this.isLeaf()) {
            DataType dataType2 = this.map.getValueType();
            for (int i = 0; i < this.keyCount; ++i) {
                n += dataType2.getMemory(this.values[i]);
            }
        } else {
            n += this.getChildPageCount() * 16;
        }
        this.addMemory(n - this.memory);
    }

    void setVersion(long l) {
        this.version = l;
    }

    public void removePage() {
        this.map.removePage(this.pos, this.memory);
    }
}

