/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glowroot.agent.impl.TimerNameCache;
import org.glowroot.agent.plugin.api.TimerName;
import org.glowroot.agent.plugin.api.config.ConfigService;
import org.glowroot.agent.plugin.api.internal.PluginService;
import org.glowroot.agent.shaded.com.google.common.base.Strings;
import org.glowroot.agent.shaded.com.google.common.cache.CacheBuilder;
import org.glowroot.agent.shaded.com.google.common.cache.CacheLoader;
import org.glowroot.agent.shaded.com.google.common.cache.LoadingCache;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableList;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableMap;
import org.glowroot.agent.shaded.com.google.common.collect.ImmutableSet;
import org.glowroot.agent.shaded.com.google.common.collect.Maps;
import org.glowroot.agent.shaded.org.slf4j.Logger;
import org.glowroot.agent.shaded.org.slf4j.LoggerFactory;
import org.glowroot.agent.weaving.Beans;

public class PluginServiceImpl
implements PluginService {
    private static final Logger logger = LoggerFactory.getLogger(PluginServiceImpl.class);
    private final TimerNameCache timerNameCache;
    private final LoadingCache<String, ConfigService> configServices;

    public PluginServiceImpl(TimerNameCache timerNameCache, final ConfigServiceFactory configServiceFactory) {
        this.timerNameCache = timerNameCache;
        this.configServices = CacheBuilder.newBuilder().build(new CacheLoader<String, ConfigService>(){

            @Override
            public ConfigService load(String pluginId) {
                return configServiceFactory.create(pluginId);
            }
        });
    }

    @Override
    public TimerName getTimerName(Class<?> adviceClass) {
        return this.timerNameCache.getTimerName(adviceClass);
    }

    @Override
    public TimerName getTimerName(String name) {
        return this.timerNameCache.getTimerName(name);
    }

    @Override
    public ConfigService getConfigService(String pluginId) {
        return this.configServices.getUnchecked(pluginId);
    }

    @Override
    public <E> List<E> toImmutableList(Collection<E> elements) {
        return ImmutableList.copyOf(elements);
    }

    @Override
    public <E> Set<E> toImmutableSet(Collection<E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    public <K, V> Map<K, V> toImmutableMap(Map<K, V> map) {
        return ImmutableMap.copyOf(map);
    }

    @Override
    public @Nullable Object getBeanValue(@Nullable Object obj, List<String> path) throws Exception {
        return Beans.value(obj, path);
    }

    @Override
    public Map<String, String> getBeanPropertiesAsText(Object obj) {
        return Beans2.propertiesAsText(obj);
    }

    static class Beans2 {
        private static final LoadingCache<Class<?>, Map<String, Method>> wildcardGetters = CacheBuilder.newBuilder().weakKeys().build(new WildcardGettersCacheLoader());

        private Beans2() {
        }

        static Map<String, String> propertiesAsText(Object obj) {
            HashMap<String, String> properties = Maps.newHashMap();
            Map<String, Method> allGettersForObj = wildcardGetters.getUnchecked(obj.getClass());
            for (Map.Entry<String, Method> entry : allGettersForObj.entrySet()) {
                try {
                    Object value = entry.getValue().invoke(obj, new Object[0]);
                    if (value == null) continue;
                    properties.put(entry.getKey(), Strings.nullToEmpty(value.toString()));
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), e);
                    properties.put(entry.getKey(), "<could not access>");
                }
            }
            return properties;
        }

        private static void sentinelMethod() {
        }

        private static class WildcardGettersCacheLoader
        extends CacheLoader<Class<?>, Map<String, Method>> {
            private WildcardGettersCacheLoader() {
            }

            @Override
            public Map<String, Method> load(Class<?> clazz) {
                HashMap<String, Method> propertyNames = Maps.newHashMap();
                for (Method method : clazz.getMethods()) {
                    Method otherMethod;
                    String propertyName = WildcardGettersCacheLoader.getPropertyName(method);
                    if (propertyName == null || (otherMethod = (Method)propertyNames.get(propertyName)) != null && otherMethod.getName().startsWith("get")) continue;
                    method.setAccessible(true);
                    propertyNames.put(propertyName, method);
                }
                return ImmutableMap.copyOf(propertyNames);
            }

            private static @Nullable String getPropertyName(Method method) {
                if (method.getParameterTypes().length > 0) {
                    return null;
                }
                String methodName = method.getName();
                if (methodName.equals("getClass")) {
                    return null;
                }
                if (WildcardGettersCacheLoader.startsWithAndThenUpperCaseChar(methodName, "get")) {
                    return WildcardGettersCacheLoader.getRemainingWithFirstCharLowercased(methodName, "get");
                }
                if (WildcardGettersCacheLoader.startsWithAndThenUpperCaseChar(methodName, "is")) {
                    return WildcardGettersCacheLoader.getRemainingWithFirstCharLowercased(methodName, "is");
                }
                return null;
            }

            private static boolean startsWithAndThenUpperCaseChar(String str, String prefix) {
                return str.startsWith(prefix) && str.length() > prefix.length() && Character.isUpperCase(str.charAt(prefix.length()));
            }

            private static String getRemainingWithFirstCharLowercased(String str, String prefix) {
                return Character.toLowerCase(str.charAt(prefix.length())) + str.substring(prefix.length() + 1);
            }
        }
    }

    public static interface ConfigServiceFactory {
        public ConfigService create(String var1);
    }
}

