/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.api;

import java.util.Collections;
import java.util.Map;
import org.glowroot.agent.plugin.api.internal.ReadableQueryMessage;

public abstract class QueryMessage {
    private static final Map<String, Object> EMPTY_DETAIL = Collections.emptyMap();

    public static QueryMessage create(String prefix) {
        return new QueryMessageImpl(prefix, "", EMPTY_DETAIL);
    }

    public static QueryMessage create(String prefix, String suffix) {
        return new QueryMessageImpl(prefix, suffix, EMPTY_DETAIL);
    }

    public static QueryMessage create(String prefix, String suffix, Map<String, ?> detail) {
        return new QueryMessageImpl(prefix, suffix, detail);
    }

    private QueryMessage() {
    }

    private static class QueryMessageImpl
    extends QueryMessage
    implements ReadableQueryMessage {
        private final String prefix;
        private final String suffix;
        private final Map<String, ?> detail;

        private QueryMessageImpl(String prefix, String suffix, Map<String, ?> detail) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.detail = detail;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public String getSuffix() {
            return this.suffix;
        }

        @Override
        public Map<String, ?> getDetail() {
            return this.detail;
        }
    }
}

