/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.agent.plugin.cassandra;

import org.glowroot.agent.plugin.api.QueryEntry;
import org.glowroot.agent.plugin.api.Timer;
import org.glowroot.agent.plugin.api.checker.Nullable;
import org.glowroot.agent.plugin.api.weaving.BindReceiver;
import org.glowroot.agent.plugin.api.weaving.BindReturn;
import org.glowroot.agent.plugin.api.weaving.BindTraveler;
import org.glowroot.agent.plugin.api.weaving.Mixin;
import org.glowroot.agent.plugin.api.weaving.OnAfter;
import org.glowroot.agent.plugin.api.weaving.OnBefore;
import org.glowroot.agent.plugin.api.weaving.OnReturn;
import org.glowroot.agent.plugin.api.weaving.Pointcut;

public class ResultSetAspect {

    @Pointcut(className="com.datastax.driver.core.PagingIterable|com.datastax.driver.core.ResultSet", subTypeRestriction="com.datastax.driver.core.ResultSet", methodName="isExhausted", methodParameterTypes={})
    public static class IsExhaustedAdvice {
        @OnBefore
        @Nullable
        public static Timer onBefore(@BindReceiver ResultSetMixin resultSet) {
            QueryEntry queryEntry = resultSet.glowroot$getQueryEntry();
            return queryEntry == null ? null : queryEntry.extend();
        }

        @OnReturn
        public static void onReturn(@BindReceiver ResultSetMixin resultSet) {
            QueryEntry queryEntry = resultSet.glowroot$getQueryEntry();
            if (queryEntry == null) {
                return;
            }
            queryEntry.rowNavigationAttempted();
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    @Pointcut(className="java.lang.Iterable", subTypeRestriction="com.datastax.driver.core.ResultSet", methodName="iterator", methodParameterTypes={})
    public static class IteratorAdvice {
        @OnReturn
        public static void onReturn(@BindReceiver ResultSetMixin resultSet) {
            QueryEntry queryEntry = resultSet.glowroot$getQueryEntry();
            if (queryEntry == null) {
                return;
            }
            queryEntry.rowNavigationAttempted();
        }
    }

    @Pointcut(className="com.datastax.driver.core.ResultSet", methodName="one", methodParameterTypes={})
    public static class OneAdvice {
        @OnBefore
        @Nullable
        public static Timer onBefore(@BindReceiver ResultSetMixin resultSet) {
            QueryEntry queryEntry = resultSet.glowroot$getQueryEntry();
            return queryEntry == null ? null : queryEntry.extend();
        }

        @OnReturn
        public static void onReturn(@BindReturn @Nullable Object row, @BindReceiver ResultSetMixin resultSet) {
            QueryEntry queryEntry = resultSet.glowroot$getQueryEntry();
            if (queryEntry == null) {
                return;
            }
            if (row != null) {
                queryEntry.incrementCurrRow();
            } else {
                queryEntry.rowNavigationAttempted();
            }
        }

        @OnAfter
        public static void onAfter(@BindTraveler @Nullable Timer timer) {
            if (timer != null) {
                timer.stop();
            }
        }
    }

    public static interface ResultSetMixin {
        @Nullable
        public QueryEntry glowroot$getQueryEntry();

        public void glowroot$setQueryEntry(@Nullable QueryEntry var1);
    }

    @Mixin(value={"com.datastax.driver.core.ResultSet"})
    public static class ResultSetImpl
    implements ResultSetMixin {
        @Nullable
        private volatile transient QueryEntry glowroot$queryEntry;

        @Override
        @Nullable
        public QueryEntry glowroot$getQueryEntry() {
            return this.glowroot$queryEntry;
        }

        @Override
        public void glowroot$setQueryEntry(@Nullable QueryEntry queryEntry) {
            this.glowroot$queryEntry = queryEntry;
        }
    }
}

